/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.inventory.container;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.inventory.HTContainerItemSlot;
import hiiragi283.ragium.api.inventory.HTSlotHelper;
import hiiragi283.ragium.api.registry.impl.HTDeferredMenuType;
import hiiragi283.ragium.api.storage.item.HTItemHandler;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0004J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0004J&\u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010%\u001a\u00020\u0010H\u0004R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lhiiragi283/ragium/api/inventory/container/HTContainerMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "menuType", "Lhiiragi283/ragium/api/registry/impl/HTDeferredMenuType;", "containerId", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "<init>", "(Lhiiragi283/ragium/api/registry/impl/HTDeferredMenuType;ILnet/minecraft/world/entity/player/Inventory;)V", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "index", "moveToInventory", "", "stack", "inventorySlots", "", "slotCount", "slotMap", "Lcom/google/common/collect/Multimap;", "Lhiiragi283/ragium/api/inventory/HTContainerItemSlot$Type;", "hotBarSlots", "", "addSlot", "Lnet/minecraft/world/inventory/Slot;", "slot", "addPlayerInv", "", "yOffset", "addSlots", "handler", "Lhiiragi283/ragium/api/storage/item/HTItemHandler;", "moveItemStackTo", "slots", "reverseDirection", "ragium_api"})
@SourceDebugExtension(value={"SMAP\nHTContainerMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTContainerMenu.kt\nhiiragi283/ragium/api/inventory/container/HTContainerMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1617#2,9:176\n1869#2:185\n1870#2:187\n1626#2:188\n1869#2,2:189\n1#3:186\n*S KotlinDebug\n*F\n+ 1 HTContainerMenu.kt\nhiiragi283/ragium/api/inventory/container/HTContainerMenu\n*L\n111#1:176,9\n111#1:185\n111#1:187\n111#1:188\n112#1:189,2\n111#1:186\n*E\n"})
public abstract class HTContainerMenu
extends AbstractContainerMenu {
    private int slotCount;
    @NotNull
    private final Multimap<HTContainerItemSlot.Type, Integer> slotMap;
    @NotNull
    private final List<Integer> hotBarSlots;
    @NotNull
    private final List<Integer> inventorySlots;

    public HTContainerMenu(@NotNull HTDeferredMenuType<?, ?> menuType, int containerId, @NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter(menuType, (String)"menuType");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        super((MenuType)menuType.get(), containerId);
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        this.slotMap = (Multimap)hashMultimap;
        this.hotBarSlots = new ArrayList();
        this.inventorySlots = new ArrayList();
    }

    @NotNull
    public final ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        ItemStack result = itemStack;
        NonNullList nonNullList = this.slots;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"slots");
        Slot slot = (Slot)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index);
        if (slot == null) {
            return result;
        }
        Slot slotIn = slot;
        if (slotIn.hasItem()) {
            ItemStack itemStack2 = slotIn.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItem(...)");
            ItemStack stackIn = itemStack2;
            ItemStack itemStack3 = stackIn.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"copy(...)");
            result = itemStack3;
            int n = index;
            if (this.slotMap.values().contains(n)) {
                if (!this.moveItemStackTo(stackIn, ((Number)((Object)CollectionsKt.minOrThrow((Iterable)this.hotBarSlots))).intValue(), ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)this.inventorySlots))).intValue() + 1, false)) {
                    ItemStack itemStack4 = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"EMPTY");
                    return itemStack4;
                }
            } else if (this.inventorySlots.contains(n)) {
                if (!this.moveToInventory(stackIn, (Iterable<Integer>)this.hotBarSlots)) {
                    ItemStack itemStack5 = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"EMPTY");
                    return itemStack5;
                }
            } else if (this.hotBarSlots.contains(n) && !this.moveToInventory(stackIn, (Iterable<Integer>)this.inventorySlots)) {
                ItemStack itemStack6 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"EMPTY");
                return itemStack6;
            }
            if (stackIn.isEmpty()) {
                slotIn.setByPlayer(ItemStack.EMPTY);
            } else {
                slotIn.setChanged();
            }
            if (stackIn.getCount() == result.getCount()) {
                ItemStack itemStack7 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack7, (String)"EMPTY");
                return itemStack7;
            }
            slotIn.onTake(player, stackIn);
            if (index == 0) {
                player.drop(stackIn, false);
            }
        }
        return result;
    }

    private final boolean moveToInventory(ItemStack stack, Iterable<Integer> inventorySlots) {
        Collection collection = this.slotMap.get((Object)HTContainerItemSlot.Type.INPUT);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection inputSlots = collection;
        Collection collection2 = this.slotMap.get((Object)HTContainerItemSlot.Type.BOTH);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
        Collection bothSlots = collection2;
        return this.moveItemStackTo(stack, inputSlots, false) || this.moveItemStackTo(stack, bothSlots, false) || this.moveItemStackTo(stack, inventorySlots, false);
    }

    @NotNull
    protected Slot addSlot(@NotNull Slot slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        if (slot instanceof HTContainerItemSlot) {
            this.slotMap.put((Object)((HTContainerItemSlot)slot).getSlotType(), (Object)this.slotCount);
            RagiumAPI.LOGGER.info(((HTContainerItemSlot)slot).getSlotType() + " slot: " + this.slotCount);
        }
        int n = this.slotCount;
        this.slotCount = n + 1;
        Slot slot2 = super.addSlot(slot);
        Intrinsics.checkNotNullExpressionValue((Object)slot2, (String)"addSlot(...)");
        return slot2;
    }

    protected final void addPlayerInv(@NotNull Inventory inventory, int yOffset) {
        int index;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        for (index = 0; index < 9; ++index) {
            this.hotBarSlots.add(this.slotCount);
            RagiumAPI.LOGGER.debug("Hotbar slot: " + this.slotCount);
            this.addSlot(new Slot((Container)inventory, index, HTSlotHelper.getSlotPosX(index), HTSlotHelper.getSlotPosY(7) - 2 + yOffset));
        }
        for (index = 0; index < 27; ++index) {
            this.inventorySlots.add(this.slotCount);
            RagiumAPI.LOGGER.debug("Inventory slot: " + this.slotCount);
            this.addSlot(new Slot((Container)inventory, index + 9, HTSlotHelper.getSlotPosX(index % 9), HTSlotHelper.getSlotPosY(3 + index / 9) + 12 + yOffset));
        }
    }

    public static /* synthetic */ void addPlayerInv$default(HTContainerMenu hTContainerMenu, Inventory inventory, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addPlayerInv");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        hTContainerMenu.addPlayerInv(inventory, n);
    }

    /*
     * WARNING - void declaration
     */
    protected final void addSlots(@NotNull HTItemHandler handler) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Iterable $this$mapNotNull$iv = handler.getItemSlots(handler.getItemSideFor());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Slot it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            HTItemSlot p0 = (HTItemSlot)element$iv$iv;
            boolean bl2 = false;
            if (p0.createContainerSlot() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Slot p0 = (Slot)element$iv;
            boolean bl = false;
            this.addSlot(p0);
        }
    }

    protected final boolean moveItemStackTo(@NotNull ItemStack stack, @NotNull Iterable<Integer> slots2, boolean reverseDirection) {
        ItemStack stackIn;
        Slot slot;
        int i2;
        Iterable<Integer> iterable;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(slots2, (String)"slots");
        boolean flag = false;
        boolean bl = reverseDirection;
        if (bl) {
            iterable = CollectionsKt.reversed(slots2);
        } else if (!bl) {
            iterable = slots2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Iterable<Integer> fixedRange = iterable;
        if (stack.isStackable()) {
            Iterator<Integer> iterator = fixedRange.iterator();
            while (iterator.hasNext()) {
                i2 = ((Number)iterator.next()).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)this.getSlot(i2), (String)"getSlot(...)");
                Intrinsics.checkNotNullExpressionValue((Object)slot.getItem(), (String)"getItem(...)");
                if (!stackIn.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackIn)) {
                    int maxCount;
                    int sumCount = stackIn.getCount() + stack.getCount();
                    if (sumCount <= (maxCount = slot.getMaxStackSize(stackIn))) {
                        stack.setCount(0);
                        stackIn.setCount(sumCount);
                        slot.setChanged();
                        flag = true;
                    } else if (stackIn.getCount() < maxCount) {
                        stack.shrink(maxCount - stackIn.getCount());
                        stackIn.setCount(maxCount);
                        slot.setChanged();
                        flag = true;
                    }
                }
                if (!stack.isEmpty()) continue;
            }
        }
        if (!stack.isEmpty()) {
            Iterator<Integer> iterator = fixedRange.iterator();
            while (iterator.hasNext()) {
                i2 = ((Number)iterator.next()).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)this.getSlot(i2), (String)"getSlot(...)");
                Intrinsics.checkNotNullExpressionValue((Object)slot.getItem(), (String)"getItem(...)");
                if (!stackIn.isEmpty() || !slot.mayPlace(stack)) continue;
                int maxCount = slot.getMaxStackSize(stack);
                slot.setByPlayer(stack.split(Math.min(stack.getCount(), maxCount)));
                slot.setChanged();
                flag = true;
                break;
            }
        }
        return flag;
    }
}

