/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block;

import hiiragi283.ragium.common.util.HTItemDropHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH$J \u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fH\u0014J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J@\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014\u00a8\u0006'"}, d2={"Lhiiragi283/ragium/common/block/HTCropBlock;", "Lnet/minecraft/world/level/block/CropBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getAgeProperty", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getMaxAge", "", "getBaseSeedId", "Lnet/minecraft/world/level/ItemLike;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "Companion", "ragium"})
public abstract class HTCropBlock
extends CropBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final IntegerProperty AGE;
    @JvmField
    @NotNull
    public static final VoxelShape[] SHAPE_BY_AGE;

    public HTCropBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    @NotNull
    protected abstract ItemLike getBaseSeedId();

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder2) {
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        Property[] propertyArray = new Property[]{AGE};
        builder2.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!this.isMaxAge(state)) {
            ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
            return itemInteractionResult;
        }
        if (!level.isClientSide) {
            List list = CropBlock.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Entity)((Entity)player), (ItemStack)stack);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(...)");
            List drops = list;
            boolean droppedSeed = false;
            for (ItemStack drop : drops) {
                if (drop.isEmpty()) continue;
                if (Intrinsics.areEqual((Object)drop.getItem(), (Object)this.getBaseSeedId()) && !droppedSeed) {
                    drop.shrink(1);
                    droppedSeed = true;
                }
                if (drop.isEmpty()) continue;
                HTItemDropHelper.INSTANCE.giveStackTo(player, drop);
            }
            level.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        }
        ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
        return itemInteractionResult;
    }

    static {
        IntegerProperty integerProperty = BeetrootBlock.AGE;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"AGE");
        AGE = integerProperty;
        VoxelShape[] voxelShapeArray = new VoxelShape[4];
        Intrinsics.checkNotNullExpressionValue((Object)CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (String)"box(...)");
        SHAPE_BY_AGE = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lhiiragi283/ragium/common/block/HTCropBlock$Companion;", "", "<init>", "()V", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "SHAPE_BY_AGE", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

