/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.util;

import com.google.common.primitives.Ints;
import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.stack.ImmutableItemStack;
import hiiragi283.ragium.api.storage.HTStackSetter;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.HTStorageAction;
import hiiragi283.ragium.api.storage.capability.HTExperienceCapabilities;
import hiiragi283.ragium.api.storage.experience.HTExperienceTank;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import hiiragi283.ragium.common.storage.experience.tank.HTExperienceHandlerItemWrapper;
import it.unimi.dsi.fastutil.longs.Long2LongArrayMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0003J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0003J7\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fJ&\u0010\u0019\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001c\u001a\u00020\u001bH\u0007J.\u0010\u0019\u001a\u00020 2\u0006\u0010%\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001a\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001bH\u0007R\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00148\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0003\u00a8\u0006'"}, d2={"Lhiiragi283/ragium/common/util/HTExperienceHelper;", "", "<init>", "()V", "getPlayerExp", "", "player", "Lnet/minecraft/world/entity/player/Player;", "setPlayerExp", "", "amount", "getExpForLevel", "", "level", "sum", "n", "a", "d", "getExpBarCapacity", "levelCache", "", "getLevelCache$annotations", "getLevelForExp", "exp", "findLevelForExp", "moveExperience", "from", "Lhiiragi283/ragium/api/storage/experience/HTExperienceTank;", "to", "access", "Lhiiragi283/ragium/api/storage/HTStorageAccess;", "(Lhiiragi283/ragium/api/storage/experience/HTExperienceTank;Lhiiragi283/ragium/api/storage/experience/HTExperienceTank;JLhiiragi283/ragium/api/storage/HTStorageAccess;)Ljava/lang/Long;", "", "Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "containerSetter", "Lhiiragi283/ragium/api/storage/HTStackSetter;", "Lhiiragi283/ragium/api/stack/ImmutableItemStack;", "slot", "Lhiiragi283/ragium/common/storage/experience/tank/HTExperienceHandlerItemWrapper;", "ragium"})
public final class HTExperienceHelper {
    @NotNull
    public static final HTExperienceHelper INSTANCE = new HTExperienceHelper();
    @NotNull
    private static final Map<Long, Long> levelCache = (Map)new Long2LongArrayMap();

    private HTExperienceHelper() {
    }

    @JvmStatic
    public static final long getPlayerExp(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (long)HTExperienceHelper.getExpForLevel(player.experienceLevel) + (long)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    @JvmStatic
    public static final void setPlayerExp(@NotNull Player player, long amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        long fixedAmount = Math.max(0L, amount);
        player.totalExperience = Ints.saturatedCast((long)fixedAmount);
        player.experienceLevel = Ints.saturatedCast((long)HTExperienceHelper.getLevelForExp(fixedAmount));
        int expForLevel = HTExperienceHelper.getExpForLevel(player.experienceLevel);
        player.experienceProgress = (float)(fixedAmount - (long)expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    @JvmStatic
    public static final int getExpForLevel(int level) {
        return level == 0 ? 0 : (level <= 15 ? HTExperienceHelper.sum(level, 7, 2) : (level <= 30 ? 315 + HTExperienceHelper.sum(level - 15, 37, 5) : 1395 + HTExperienceHelper.sum(level - 30, 112, 9)));
    }

    @JvmStatic
    private static final int sum(int n, int a, int d) {
        return n * (2 * a + (n - 1) * d) / 2;
    }

    @JvmStatic
    public static final long getExpBarCapacity(long level) {
        return level >= 30L ? (long)112 + (level - (long)30) * (long)9 : (level >= 15L ? (long)37 + (level - (long)15) * (long)5 : (long)7 + level * (long)2);
    }

    @JvmStatic
    private static /* synthetic */ void getLevelCache$annotations() {
    }

    @JvmStatic
    public static final long getLevelForExp(long exp) {
        Long l = levelCache.computeIfAbsent(exp, arg_0 -> HTExperienceHelper.getLevelForExp$lambda$0((Function1)new Function1<Long, Long>((Object)INSTANCE){

            public final Long invoke(long p0) {
                return HTExperienceHelper.access$findLevelForExp(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"computeIfAbsent(...)");
        return ((Number)l).longValue();
    }

    @JvmStatic
    private static final long findLevelForExp(long exp) {
        long exp1 = exp;
        long level = 0L;
        long nextLevel;
        while (exp1 >= (nextLevel = HTExperienceHelper.getExpBarCapacity(level))) {
            long l = level;
            level = l + 1L;
            exp1 -= nextLevel;
        }
        return level;
    }

    @JvmStatic
    @Nullable
    public static final Long moveExperience(@Nullable HTExperienceTank from, @Nullable HTExperienceTank to, long amount, @NotNull HTStorageAccess access) {
        long leftover;
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        if (from == null || to == null || amount <= 0L) {
            return null;
        }
        long simulatedExtracted = from.extract-dA061ig(amount, HTStorageAction.Companion.getSIMULATE-fhPPMAc(), access).longValue();
        long simulatedInserted = to.insert-dA061ig(simulatedExtracted, HTStorageAction.Companion.getSIMULATE-fhPPMAc(), access).longValue();
        long extracted = from.extract-dA061ig(simulatedInserted, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), access).longValue();
        long remainder = to.insert-dA061ig(extracted, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), access).longValue();
        if (remainder > 0L && (leftover = from.insert-dA061ig(remainder, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), access).longValue()) > 0L) {
            RagiumAPI.LOGGER.error("Experience storage " + from + " did not accept leftover amount from " + to + "! Voiding it.");
        }
        return remainder;
    }

    public static /* synthetic */ Long moveExperience$default(HTExperienceTank hTExperienceTank, HTExperienceTank hTExperienceTank2, long l, HTStorageAccess hTStorageAccess, int n, Object object) {
        if ((n & 4) != 0) {
            HTExperienceTank hTExperienceTank3 = hTExperienceTank;
            long l2 = l = hTExperienceTank3 != null ? ((Number)hTExperienceTank3.getAmount()).longValue() : 0L;
        }
        if ((n & 8) != 0) {
            hTStorageAccess = HTStorageAccess.INTERNAL;
        }
        return HTExperienceHelper.moveExperience(hTExperienceTank, hTExperienceTank2, l, hTStorageAccess);
    }

    @JvmStatic
    public static final boolean moveExperience(@NotNull HTItemSlot from, @NotNull HTStackSetter<ImmutableItemStack> containerSetter, @NotNull HTExperienceTank to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(containerSetter, (String)"containerSetter");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        ImmutableItemStack immutableItemStack = (ImmutableItemStack)from.getStack();
        Object object = immutableItemStack != null ? immutableItemStack.unbox-impl() : null;
        if (object == null) {
            return false;
        }
        ItemStack stack = object;
        if (!HTExperienceCapabilities.INSTANCE.hasCapability-z9sw8y4(stack)) {
            return false;
        }
        HTExperienceHandlerItemWrapper hTExperienceHandlerItemWrapper = HTExperienceHandlerItemWrapper.Companion.create-6PPjgQU(ImmutableItemStack.copyWithAmount-GuIG3FU(stack, 1));
        if (hTExperienceHandlerItemWrapper == null) {
            return false;
        }
        HTExperienceHandlerItemWrapper wrapper = hTExperienceHandlerItemWrapper;
        return HTExperienceHelper.moveExperience(from, containerSetter, wrapper, to);
    }

    @JvmStatic
    public static final boolean moveExperience(@NotNull HTItemSlot slot, @NotNull HTStackSetter<ImmutableItemStack> containerSetter, @NotNull HTExperienceHandlerItemWrapper from, @NotNull HTExperienceTank to) {
        ItemStack container;
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter(containerSetter, (String)"containerSetter");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Long result = HTExperienceHelper.moveExperience$default(from, to, 0L, null, 12, null);
        if (result != null && (container = from.getContainer-AiLEkRY()) != null) {
            if (ImmutableItemStack.amount-impl(container) == 1) {
                containerSetter.setStack(ImmutableItemStack.box-impl(container));
            } else {
                slot.extract-dA061ig(1, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), HTStorageAccess.MANUAL);
            }
        }
        return result != null;
    }

    private static final Long getLevelForExp$lambda$0(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ long access$findLevelForExp(long exp) {
        return HTExperienceHelper.findLevelForExp(exp);
    }
}

