/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.util;

import hiiragi283.ragium.api.RagiumPlatform;
import hiiragi283.ragium.config.RagiumConfig;
import hiiragi283.ragium.setup.RagiumEnchantmentComponents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\"\u0010\u001c\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\fH\u0007J\"\u0010\u001c\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\fH\u0007J\"\u0010\u001c\u001a\u00020\u001e2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\"\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010!\u001a\u00020 H\u0007J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\fH\u0007J \u0010\"\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\fH\u0007J \u0010\"\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\fH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lhiiragi283/ragium/common/util/HTItemHelper;", "", "<init>", "()V", "DEFAULT_RANDOM", "Lnet/minecraft/util/RandomSource;", "modifyStorageCapacity", "", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "random", "enchantmentLevel", "", "storageCapacity", "Lorg/apache/commons/lang3/mutable/MutableFloat;", "modifyCollectorRange", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "stack", "Lnet/minecraft/world/item/ItemStack;", "collectorRange", "hasStrike", "", "runIterationOnComponent", "enchantments", "Lnet/minecraft/world/item/enchantment/ItemEnchantments;", "visitor", "Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentVisitor;", "processStorageCapacity", "capacity", "", "processCollectorRange", "", "range", "getFixedUsage", "amount", "level", "Lnet/minecraft/world/level/Level;", "ragium"})
public final class HTItemHelper {
    @NotNull
    public static final HTItemHelper INSTANCE = new HTItemHelper();
    @JvmField
    @NotNull
    public static final RandomSource DEFAULT_RANDOM;

    private HTItemHelper() {
    }

    @JvmStatic
    public static final void modifyStorageCapacity(@NotNull Enchantment enchantment, @NotNull RandomSource random, int enchantmentLevel, @NotNull MutableFloat storageCapacity) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)storageCapacity, (String)"storageCapacity");
        enchantment.modifyUnfilteredValue(RagiumEnchantmentComponents.CAPACITY, random, enchantmentLevel, storageCapacity);
    }

    @JvmStatic
    public static final void modifyCollectorRange(@NotNull Enchantment enchantment, @NotNull ServerLevel serverLevel, int enchantmentLevel, @NotNull ItemStack stack, @NotNull MutableFloat collectorRange) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)collectorRange, (String)"collectorRange");
        enchantment.modifyItemFilteredCount(RagiumEnchantmentComponents.RANGE, serverLevel, enchantmentLevel, stack, collectorRange);
    }

    @JvmStatic
    public static final boolean hasStrike(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return EnchantmentHelper.has((ItemStack)stack, RagiumEnchantmentComponents.STRIKE);
    }

    @JvmStatic
    public static final void runIterationOnComponent(@NotNull ItemEnchantments enchantments, @NotNull EnchantmentHelper.EnchantmentVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)enchantments, (String)"enchantments");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            visitor.accept((Holder)entry.getKey(), entry.getIntValue());
        }
    }

    @JvmStatic
    public static final int processStorageCapacity(@Nullable RandomSource random, @NotNull ItemEnchantments enchantments, int capacity) {
        Intrinsics.checkNotNullParameter((Object)enchantments, (String)"enchantments");
        MutableFloat mutableFloat = new MutableFloat((Number)capacity);
        HTItemHelper.runIterationOnComponent(enchantments, (arg_0, arg_1) -> HTItemHelper.processStorageCapacity$lambda$0(random, mutableFloat, arg_0, arg_1));
        return Math.max(0, mutableFloat.intValue());
    }

    @JvmStatic
    public static final int processStorageCapacity(@Nullable RandomSource random, @NotNull ItemStack stack, int capacity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        MutableFloat mutableFloat = new MutableFloat((Number)capacity);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (arg_0, arg_1) -> HTItemHelper.processStorageCapacity$lambda$1(random, mutableFloat, arg_0, arg_1));
        return Math.max(0, mutableFloat.intValue());
    }

    @JvmStatic
    public static final long processStorageCapacity(@Nullable RandomSource random, @NotNull ItemStack stack, long capacity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        MutableFloat mutableFloat = new MutableFloat((Number)capacity);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (arg_0, arg_1) -> HTItemHelper.processStorageCapacity$lambda$2(random, mutableFloat, arg_0, arg_1));
        return Math.max(0L, mutableFloat.longValue());
    }

    @JvmStatic
    public static final double processCollectorRange(@NotNull ServerLevel serverLevel, @NotNull ItemStack stack, double range) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        MutableFloat mutableFloat = new MutableFloat((Number)range);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (arg_0, arg_1) -> HTItemHelper.processCollectorRange$lambda$0(serverLevel, stack, mutableFloat, arg_0, arg_1));
        return Math.max(0.0, mutableFloat.doubleValue());
    }

    public static /* synthetic */ double processCollectorRange$default(ServerLevel serverLevel, ItemStack itemStack, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = RagiumConfig.COMMON.deviceCollectorEntityRange.getAsDouble();
        }
        return HTItemHelper.processCollectorRange(serverLevel, itemStack, d);
    }

    @JvmStatic
    public static final int getFixedUsage(@NotNull ItemStack stack, int amount) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        MinecraftServer minecraftServer = RagiumPlatform.INSTANCE.getCurrentServer();
        if (minecraftServer == null || (minecraftServer = minecraftServer.overworld()) == null) {
            return amount;
        }
        MinecraftServer overworld = minecraftServer;
        return HTItemHelper.getFixedUsage((ServerLevel)overworld, stack, amount);
    }

    @JvmStatic
    public static final int getFixedUsage(@NotNull Level level, @NotNull ItemStack stack, int amount) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return level instanceof ServerLevel ? HTItemHelper.getFixedUsage((ServerLevel)level, stack, amount) : amount;
    }

    @JvmStatic
    public static final int getFixedUsage(@NotNull ServerLevel level, @NotNull ItemStack stack, int amount) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return EnchantmentHelper.processDurabilityChange((ServerLevel)level, (ItemStack)stack, (int)amount);
    }

    private static final void processStorageCapacity$lambda$0(RandomSource $random, MutableFloat $float, Holder holder, int level) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Object object = holder.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        Enchantment enchantment = (Enchantment)object;
        RandomSource randomSource = $random;
        if (randomSource == null) {
            randomSource = DEFAULT_RANDOM;
        }
        HTItemHelper.modifyStorageCapacity(enchantment, randomSource, level, $float);
    }

    private static final void processStorageCapacity$lambda$1(RandomSource $random, MutableFloat $float, Holder holder, int level) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Object object = holder.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        Enchantment enchantment = (Enchantment)object;
        RandomSource randomSource = $random;
        if (randomSource == null) {
            randomSource = DEFAULT_RANDOM;
        }
        HTItemHelper.modifyStorageCapacity(enchantment, randomSource, level, $float);
    }

    private static final void processStorageCapacity$lambda$2(RandomSource $random, MutableFloat $float, Holder holder, int level) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Object object = holder.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        Enchantment enchantment = (Enchantment)object;
        RandomSource randomSource = $random;
        if (randomSource == null) {
            randomSource = DEFAULT_RANDOM;
        }
        HTItemHelper.modifyStorageCapacity(enchantment, randomSource, level, $float);
    }

    private static final void processCollectorRange$lambda$0(ServerLevel $serverLevel, ItemStack $stack, MutableFloat $float, Holder holder, int level) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Object object = holder.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        HTItemHelper.modifyCollectorRange((Enchantment)object, $serverLevel, level, $stack, $float);
    }

    static {
        RandomSource randomSource = RandomSource.create();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"create(...)");
        DEFAULT_RANDOM = randomSource;
    }
}

