/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.inventory.slot;

import hiiragi283.ragium.api.inventory.slot.HTSlot;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u0012H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lhiiragi283/ragium/api/inventory/slot/HTContainerItemSlot;", "Lnet/minecraft/world/inventory/Slot;", "Lhiiragi283/ragium/api/inventory/slot/HTSlot;", "slot", "Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "x", "", "y", "uncheckedSetter", "Ljava/util/function/Consumer;", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Lhiiragi283/ragium/api/storage/item/HTItemSlot;IILjava/util/function/Consumer;)V", "getSlot", "()Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "insertItem", "stack", "simulate", "", "mayPlace", "getItem", "hasItem", "set", "", "setChanged", "getMaxStackSize", "mayPickup", "player", "Lnet/minecraft/world/entity/player/Player;", "remove", "amount", "tryRemove", "Ljava/util/Optional;", "count", "decrement", "allowPartialRemoval", "Companion", "ragium_api"})
public class HTContainerItemSlot
extends Slot
implements HTSlot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HTItemSlot slot;
    @NotNull
    private final Consumer<ItemStack> uncheckedSetter;
    @NotNull
    private static final SimpleContainer emptyContainer = new SimpleContainer(0);

    public HTContainerItemSlot(@NotNull HTItemSlot slot, int x, int y, @NotNull Consumer<ItemStack> uncheckedSetter) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter(uncheckedSetter, (String)"uncheckedSetter");
        super((Container)emptyContainer, 0, x, y);
        this.slot = slot;
        this.uncheckedSetter = uncheckedSetter;
    }

    @NotNull
    public final HTItemSlot getSlot() {
        return this.slot;
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack remainder = this.slot.insertItem(stack, simulate, HTStorageAccess.MANUAL);
        if (!simulate && stack.getCount() != remainder.getCount()) {
            this.setChanged();
        }
        return remainder;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            return false;
        }
        if (this.slot.isEmpty()) {
            return this.insertItem(stack, true).getCount() < stack.getCount();
        }
        if (this.slot.extractItem(1, true, HTStorageAccess.MANUAL).isEmpty()) {
            return false;
        }
        return this.slot.isItemValidForInsert(stack, HTStorageAccess.MANUAL);
    }

    @NotNull
    public ItemStack getItem() {
        return this.slot.getStack();
    }

    public boolean hasItem() {
        return !this.slot.isEmpty();
    }

    public void set(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.uncheckedSetter.accept(stack);
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        this.slot.onContentsChanged();
    }

    public int getMaxStackSize() {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return this.slot.getLimit(itemStack);
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.slot.getLimit(stack);
    }

    public boolean mayPickup(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return !this.slot.extractItem(1, true, HTStorageAccess.MANUAL).isEmpty();
    }

    @NotNull
    public ItemStack remove(int amount) {
        return this.slot.extractItem(amount, false, HTStorageAccess.MANUAL);
    }

    @NotNull
    public Optional<ItemStack> tryRemove(int count, int decrement, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.allowPartialRemoval()) {
            if (!this.mayPickup(player)) {
                Optional<ItemStack> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            int count2 = Math.min(count, decrement);
            ItemStack stack = this.remove(count2);
            if (stack.isEmpty()) {
                Optional<ItemStack> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            if (this.getItem().isEmpty()) {
                this.setByPlayer(ItemStack.EMPTY, stack);
            }
            Optional<ItemStack> optional = Optional.of(stack);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return optional;
        }
        Optional optional = super.tryRemove(count, decrement, player);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"tryRemove(...)");
        return optional;
    }

    protected boolean allowPartialRemoval() {
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lhiiragi283/ragium/api/inventory/slot/HTContainerItemSlot$Companion;", "", "<init>", "()V", "emptyContainer", "Lnet/minecraft/world/SimpleContainer;", "getEmptyContainer$annotations", "ragium_api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getEmptyContainer$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

