/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.storage.fluid;

import hiiragi283.ragium.api.codec.BiCodecs;
import hiiragi283.ragium.api.storage.HTContentListener;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.fluid.HTFluidTankWrapper;
import hiiragi283.ragium.api.storage.predicate.HTFluidPredicates;
import hiiragi283.ragium.api.storage.value.HTValueOutput;
import hiiragi283.ragium.api.storage.value.HTValueSerializable;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H&J \u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0016\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0017J\b\u0010#\u001a\u00020\u0010H\u0016J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0017J\u0018\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0017J\u0018\u0010(\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0017R\u0014\u0010\u0018\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006*\u00c0\u0006\u0001"}, d2={"Lhiiragi283/ragium/api/storage/fluid/HTFluidTank;", "Lnet/neoforged/neoforge/fluids/IFluidTank;", "Lhiiragi283/ragium/api/storage/value/HTValueSerializable;", "Lhiiragi283/ragium/api/storage/HTContentListener;", "getStack", "Lnet/neoforged/neoforge/fluids/FluidStack;", "setStack", "", "stack", "insert", "simulate", "", "access", "Lhiiragi283/ragium/api/storage/HTStorageAccess;", "extract", "amount", "", "isFluidValidForInsert", "canFluidExtract", "toSingleHandler", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "setStackSize", "growStack", "shrinkStack", "isEmpty", "()Z", "setEmpty", "getNeeded", "matchFluid", "filter", "Ljava/util/function/Predicate;", "serialize", "output", "Lhiiragi283/ragium/api/storage/value/HTValueOutput;", "getFluid", "getFluidAmount", "fill", "resource", "action", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;", "drain", "maxDrain", "ragium_api"})
public interface HTFluidTank
extends IFluidTank,
HTValueSerializable,
HTContentListener {
    @NotNull
    public FluidStack getStack();

    public void setStack(@NotNull FluidStack var1);

    @NotNull
    default public FluidStack insert(@NotNull FluidStack stack, boolean simulate, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        if (stack.isEmpty() || !this.isFluidValidForInsert(stack, access)) {
            return stack;
        }
        int needed = this.getNeeded();
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = FluidStack.isSameFluidSameComponents((FluidStack)this.getStack(), (FluidStack)stack);
        if (this.isEmpty() || sameType) {
            int toAdd = Math.min(stack.getAmount(), needed);
            if (!simulate) {
                if (sameType) {
                    this.growStack(toAdd, false);
                    this.onContentsChanged();
                } else {
                    FluidStack fluidStack = stack.copyWithAmount(toAdd);
                    Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
                    this.setStack(fluidStack);
                }
            }
            FluidStack fluidStack = stack.copyWithAmount(stack.getAmount() - toAdd);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
            return fluidStack;
        }
        return stack;
    }

    @NotNull
    default public FluidStack extract(int amount, boolean simulate, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        FluidStack stack = this.getStack();
        if (this.isEmpty() || amount < 1 || !this.canFluidExtract(this.getStack(), access)) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
            return fluidStack;
        }
        FluidStack fluidStack = stack.copyWithAmount(Math.min(this.getFluidAmount(), amount));
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
        FluidStack result = fluidStack;
        if (!simulate) {
            this.shrinkStack(result.getAmount(), false);
            this.onContentsChanged();
        }
        return result;
    }

    default public boolean isFluidValidForInsert(@NotNull FluidStack stack, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        return this.isFluidValid(stack);
    }

    default public boolean canFluidExtract(@NotNull FluidStack stack, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        return true;
    }

    @NotNull
    default public IFluidHandler toSingleHandler() {
        return new HTFluidTankWrapper(this);
    }

    default public int setStackSize(int amount, boolean simulate) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (!simulate) {
                this.setEmpty();
            }
            return 0;
        }
        FluidStack stack = this.getStack();
        int fixedAmount = Math.min(amount, this.getCapacity());
        if (stack.getAmount() == fixedAmount || simulate) {
            return fixedAmount;
        }
        FluidStack fluidStack = stack.copyWithAmount(fixedAmount);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"copyWithAmount(...)");
        this.setStack(fluidStack);
        this.onContentsChanged();
        return fixedAmount;
    }

    default public int growStack(int amount, boolean simulate) {
        int current = this.getFluidAmount();
        if (current == 0) {
            return 0;
        }
        int fixedAmount = amount > 0 ? Math.min(amount, this.getNeeded()) : amount;
        int newSize = this.setStackSize(current + fixedAmount, simulate);
        return newSize - current;
    }

    default public int shrinkStack(int amount, boolean simulate) {
        return -this.growStack(-amount, simulate);
    }

    default public boolean isEmpty() {
        return this.getStack().isEmpty();
    }

    default public void setEmpty() {
        FluidStack fluidStack = FluidStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
        this.setStack(fluidStack);
    }

    default public int getNeeded() {
        return Math.max(0, this.getCapacity() - this.getFluidAmount());
    }

    default public boolean matchFluid(@NotNull Predicate<FluidStack> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return filter.test(this.getStack());
    }

    @Override
    default public void serialize(@NotNull HTValueOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.store("fluid", BiCodecs.fluidStack(true), this.getStack());
    }

    @Deprecated(message="Use `getStack()` instead", replaceWith=@ReplaceWith(expression="this.getStack()", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    default public FluidStack getFluid() {
        return this.getStack();
    }

    default public int getFluidAmount() {
        return this.getStack().getAmount();
    }

    @Deprecated(message="Use `insert(FluidStack, Boolean, HTStorageAccess) `instead")
    default public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return resource.getAmount() - this.insert(resource, action.simulate(), HTStorageAccess.EXTERNAL).getAmount();
    }

    @Deprecated(message="Use `extract(FluidStack, Boolean, HTStorageAccess)` instead")
    @NotNull
    default public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.extract(maxDrain, action.simulate(), HTStorageAccess.EXTERNAL);
    }

    @Deprecated(message="Use `extract(FluidStack, Boolean, HTStorageAccess)` instead")
    @NotNull
    default public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!this.matchFluid(HTFluidPredicates.byFluidAndComponent(resource))) {
            FluidStack fluidStack = FluidStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"EMPTY");
            return fluidStack;
        }
        return this.extract(resource.getAmount(), action.simulate(), HTStorageAccess.EXTERNAL);
    }
}

