/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.storage.item;

import hiiragi283.ragium.api.storage.HTMultiCapability;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.fluid.HTFluidTank;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0016J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002R\u0018\u0010\u0004\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\u0006\"\u0004\b\n\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001c\u00c0\u0006\u0001"}, d2={"Lhiiragi283/ragium/api/storage/item/HTFluidItemSlot;", "Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "getFluidTank", "Lhiiragi283/ragium/api/storage/fluid/HTFluidTank;", "isDraining", "", "()Z", "setDraining", "(Z)V", "isFilling", "setFilling", "handleTank", "", "slot", "mode", "fillTank", "drainTank", "drainItemAndMove", "fluidStack", "Lnet/neoforged/neoforge/fluids/FluidStack;", "moveItem", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "fillHandlerFromOther", "toFill", "toDrain", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "stack", "ragium_api"})
public interface HTFluidItemSlot
extends HTItemSlot {
    @NotNull
    public HTFluidTank getFluidTank();

    public boolean isDraining();

    public void setDraining(boolean var1);

    public boolean isFilling();

    public void setFilling(boolean var1);

    default public void handleTank(@NotNull HTItemSlot slot, boolean mode) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        if (!this.isEmpty()) {
            boolean bl = mode;
            if (bl) {
                this.fillTank(slot);
            } else if (!bl) {
                this.drainTank(slot);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    default public void fillTank(@NotNull HTItemSlot slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        IFluidHandlerItem iFluidHandlerItem = HTMultiCapability.FLUID.getCapability(this.getStack());
        if (iFluidHandlerItem == null) {
            return;
        }
        IFluidHandlerItem handler = iFluidHandlerItem;
        int tanks = handler.getTanks();
        if (tanks == 1) {
            FluidStack fluidStack = handler.getFluidInTank(0);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluidInTank(...)");
            FluidStack stackIn = fluidStack;
            if (!stackIn.isEmpty() && this.getFluidTank().isFluidValid(stackIn)) {
                this.drainItemAndMove(slot, stackIn);
            }
        } else {
            return;
        }
    }

    default public void drainTank(@NotNull HTItemSlot slot) {
        FluidStack simulatedDrain;
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        if (!HTMultiCapability.FLUID.hasCapability(this.getStack())) {
            return;
        }
        FluidStack stackIn = this.getFluidTank().getStack();
        if (!stackIn.isEmpty() && (simulatedDrain = this.getFluidTank().extract(stackIn.getAmount(), true, HTStorageAccess.INTERNAl)).isEmpty()) {
            return;
        }
        ItemStack itemStack = this.getStack().copyWithCount(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        ItemStack itemCopied = itemStack;
        IFluidHandlerItem iFluidHandlerItem = HTMultiCapability.FLUID.getCapability(itemCopied);
        if (iFluidHandlerItem == null) {
            return;
        }
        IFluidHandlerItem handler = iFluidHandlerItem;
        int toDrain = handler.fill(stackIn.copy(), IFluidHandler.FluidAction.EXECUTE);
        if (toDrain == 0) {
            return;
        }
        if (this.getCount() == 1) {
            ItemStack itemStack2 = handler.getContainer();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getContainer(...)");
            IFluidHandlerItem iFluidHandlerItem2 = HTMultiCapability.FLUID.getCapability(itemStack2);
            if (iFluidHandlerItem2 == null) {
                return;
            }
            IFluidHandlerItem handler1 = iFluidHandlerItem2;
            if (handler1.fill(stackIn.copy(), IFluidHandler.FluidAction.SIMULATE) > 0) {
                ItemStack itemStack3 = handler.getContainer();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getContainer(...)");
                this.setStack(itemStack3);
                this.setDraining(true);
                this.getFluidTank().shrinkStack(toDrain, false);
                return;
            }
        }
    }

    private boolean drainItemAndMove(HTItemSlot slot, FluidStack fluidStack) {
        int toTransfer;
        FluidStack remainder = this.getFluidTank().insert(fluidStack, true, HTStorageAccess.INTERNAl);
        int remainderAmount = remainder.getAmount();
        if (remainderAmount == (toTransfer = fluidStack.getAmount())) {
            return false;
        }
        ItemStack stack = this.getStack();
        if (!HTMultiCapability.FLUID.hasCapability(stack)) {
            return false;
        }
        ItemStack itemStack = stack.copyWithCount(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        ItemStack input = itemStack;
        IFluidHandlerItem iFluidHandlerItem = HTMultiCapability.FLUID.getCapability(input);
        if (iFluidHandlerItem == null) {
            return false;
        }
        IFluidHandlerItem handler = iFluidHandlerItem;
        FluidStack fluidStack2 = handler.drain(fluidStack.copyWithAmount(toTransfer - remainderAmount), IFluidHandler.FluidAction.EXECUTE);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack2, (String)"drain(...)");
        FluidStack drained = fluidStack2;
        if (drained.isEmpty()) {
            return false;
        }
        if (this.getCount() == 1) {
            ItemStack itemStack2 = handler.getContainer();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getContainer(...)");
            IFluidHandlerItem iFluidHandlerItem2 = HTMultiCapability.FLUID.getCapability(itemStack2);
            if (iFluidHandlerItem2 != null) {
                IFluidHandlerItem handler1 = iFluidHandlerItem2;
                boolean bl = false;
                if (!handler1.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    ItemStack itemStack3 = handler1.getContainer();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getContainer(...)");
                    this.setStack(itemStack3);
                    this.getFluidTank().insert(drained, false, HTStorageAccess.INTERNAl);
                    this.setFilling(true);
                    return true;
                }
            }
        }
        ItemStack itemStack4 = handler.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"getContainer(...)");
        if (this.moveItem(slot, itemStack4)) {
            this.getFluidTank().insert(drained, false, HTStorageAccess.INTERNAl);
            return true;
        }
        return false;
    }

    private boolean moveItem(HTItemSlot slot, ItemStack itemStack) {
        if (slot.isEmpty()) {
            slot.setStack(itemStack);
        } else {
            ItemStack stackIn = slot.getStack();
            if (!ItemStack.isSameItemSameComponents((ItemStack)stackIn, (ItemStack)itemStack)) {
                return false;
            }
            if (stackIn.getCount() >= slot.getLimit(stackIn)) {
                return false;
            }
            slot.growStack(1, false);
        }
        this.shrinkStack(1, false);
        return true;
    }

    default public boolean fillTank() {
        if (this.getCount() != 1) {
            return false;
        }
        IFluidHandlerItem iFluidHandlerItem = HTMultiCapability.FLUID.getCapability(this.getStack());
        if (iFluidHandlerItem == null) {
            return false;
        }
        IFluidHandlerItem handler = iFluidHandlerItem;
        if (handler.getTanks() != 1) {
            return false;
        }
        FluidStack fluidStack = handler.getFluidInTank(0);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluidInTank(...)");
        FluidStack stackIn = fluidStack;
        if (!stackIn.isEmpty() && this.getFluidTank().isFluidValid(stackIn) && this.fillHandlerFromOther(this.getFluidTank(), (IFluidHandler)handler, stackIn)) {
            ItemStack itemStack = handler.getContainer();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getContainer(...)");
            this.setStack(itemStack);
            return true;
        }
        return false;
    }

    private boolean fillHandlerFromOther(HTFluidTank toFill, IFluidHandler toDrain, FluidStack stack) {
        int drained;
        FluidStack fluidStack = toDrain.drain(stack.copy(), IFluidHandler.FluidAction.SIMULATE);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"drain(...)");
        FluidStack simulatedDrain = fluidStack;
        if (simulatedDrain.isEmpty()) {
            return false;
        }
        FluidStack remainder = this.getFluidTank().insert(simulatedDrain, true, HTStorageAccess.INTERNAl);
        int remainderAmount = remainder.getAmount();
        if (remainderAmount < (drained = simulatedDrain.getAmount())) {
            FluidStack fluidStack2 = toDrain.drain(stack.copyWithAmount(drained - remainderAmount), IFluidHandler.FluidAction.EXECUTE);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack2, (String)"drain(...)");
            toFill.insert(fluidStack2, false, HTStorageAccess.INTERNAl);
            return true;
        }
        return false;
    }
}

