/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.storage.item;

import hiiragi283.ragium.api.codec.BiCodecs;
import hiiragi283.ragium.api.storage.HTContentListener;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.value.HTValueOutput;
import hiiragi283.ragium.api.storage.value.HTValueSerializable;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H&J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0004H&J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004H&J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H&J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016J\u0016\u0010\u001f\u001a\u00020\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0019\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006%\u00c0\u0006\u0001"}, d2={"Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "Lhiiragi283/ragium/api/storage/value/HTValueSerializable;", "Lhiiragi283/ragium/api/storage/HTContentListener;", "getStack", "Lnet/minecraft/world/item/ItemStack;", "setStack", "", "stack", "insertItem", "simulate", "", "access", "Lhiiragi283/ragium/api/storage/HTStorageAccess;", "extractItem", "amount", "", "getLimit", "isItemValid", "isItemValidForInsert", "canItemExtract", "createContainerSlot", "Lnet/minecraft/world/inventory/Slot;", "setStackSize", "growStack", "shrinkStack", "isEmpty", "()Z", "setEmpty", "count", "getCount", "()I", "matchItem", "filter", "Ljava/util/function/Predicate;", "serialize", "output", "Lhiiragi283/ragium/api/storage/value/HTValueOutput;", "ragium_api"})
public interface HTItemSlot
extends HTValueSerializable,
HTContentListener {
    @NotNull
    public ItemStack getStack();

    public void setStack(@NotNull ItemStack var1);

    @NotNull
    default public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        if (stack.isEmpty()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        int needed = this.getLimit(stack) - this.getCount();
        if (needed <= 0 || !this.isItemValidForInsert(stack, access)) {
            return stack;
        }
        boolean sameType = ItemStack.isSameItemSameComponents((ItemStack)this.getStack(), (ItemStack)stack);
        if (this.isEmpty() || sameType) {
            int toAdd = Math.min(stack.getCount(), needed);
            if (!simulate) {
                if (sameType) {
                    this.growStack(toAdd, false);
                    this.onContentsChanged();
                } else {
                    ItemStack itemStack = stack.copyWithCount(toAdd);
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
                    this.setStack(itemStack);
                }
            }
            ItemStack itemStack = stack.copyWithCount(stack.getCount() - toAdd);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
            return itemStack;
        }
        return stack;
    }

    @NotNull
    default public ItemStack extractItem(int amount, boolean simulate, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        ItemStack stack = this.getStack();
        if (this.isEmpty() || amount < 1 || !this.canItemExtract(this.getStack(), access)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        int current = Math.min(stack.getCount(), stack.getMaxStackSize());
        int fixedAmount = Math.min(amount, current);
        ItemStack itemStack = stack.copyWithCount(fixedAmount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        ItemStack result = itemStack;
        if (!simulate) {
            this.shrinkStack(fixedAmount, false);
            this.onContentsChanged();
        }
        return result;
    }

    public int getLimit(@NotNull ItemStack var1);

    public boolean isItemValid(@NotNull ItemStack var1);

    default public boolean isItemValidForInsert(@NotNull ItemStack stack, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        return this.isItemValid(stack);
    }

    default public boolean canItemExtract(@NotNull ItemStack stack, @NotNull HTStorageAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        return true;
    }

    @Nullable
    public Slot createContainerSlot();

    default public int setStackSize(int amount, boolean simulate) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (!simulate) {
                this.setEmpty();
            }
            return 0;
        }
        ItemStack stack = this.getStack();
        int maxStackSize = this.getLimit(stack);
        int fixedAmount = Math.min(amount, maxStackSize);
        if (stack.getCount() == fixedAmount || simulate) {
            return fixedAmount;
        }
        ItemStack itemStack = stack.copyWithCount(fixedAmount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        this.setStack(itemStack);
        this.onContentsChanged();
        return fixedAmount;
    }

    default public int growStack(int amount, boolean simulate) {
        int current = this.getCount();
        if (current == 0) {
            return 0;
        }
        int fixedAmount = amount > 0 ? Math.min(amount, this.getLimit(this.getStack())) : amount;
        int newSize = this.setStackSize(current + fixedAmount, simulate);
        return newSize - current;
    }

    default public int shrinkStack(int amount, boolean simulate) {
        return -this.growStack(-amount, simulate);
    }

    default public boolean isEmpty() {
        return this.getStack().isEmpty();
    }

    default public void setEmpty() {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.setStack(itemStack);
    }

    default public int getCount() {
        return this.getStack().getCount();
    }

    default public boolean matchItem(@NotNull Predicate<ItemStack> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return filter.test(this.getStack());
    }

    @Override
    default public void serialize(@NotNull HTValueOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.store("item", BiCodecs.itemStack(true), this.getStack());
    }
}

