/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.client;

import com.mojang.logging.LogUtils;
import hiiragi283.ragium.api.extension.RegistryExtensionsKt;
import hiiragi283.ragium.api.registry.HTFluidContent;
import hiiragi283.ragium.api.registry.impl.HTDeferredBlock;
import hiiragi283.ragium.api.registry.impl.HTDeferredItem;
import hiiragi283.ragium.api.registry.impl.HTDeferredMenuType;
import hiiragi283.ragium.client.HTSimpleFluidExtensions;
import hiiragi283.ragium.client.RagiumClient;
import hiiragi283.ragium.client.RagiumKeyMappings;
import hiiragi283.ragium.client.gui.screen.HTAccessConfigurationScreen;
import hiiragi283.ragium.client.gui.screen.HTDrumScreen;
import hiiragi283.ragium.client.gui.screen.HTEnergyNetworkAccessScreen;
import hiiragi283.ragium.client.gui.screen.HTFluidCollectorScreen;
import hiiragi283.ragium.client.gui.screen.HTFuelGeneratorScreen;
import hiiragi283.ragium.client.gui.screen.HTGenericScreen;
import hiiragi283.ragium.client.gui.screen.HTItemBufferScreen;
import hiiragi283.ragium.client.gui.screen.HTItemToItemScreen;
import hiiragi283.ragium.client.gui.screen.HTMachineScreen;
import hiiragi283.ragium.client.gui.screen.HTMobCapturerScreen;
import hiiragi283.ragium.client.gui.screen.HTRefineryScreen;
import hiiragi283.ragium.client.gui.screen.HTSingleFluidMachineScreen;
import hiiragi283.ragium.client.gui.screen.HTTelepadScreen;
import hiiragi283.ragium.common.block.entity.HTMachineBlockEntity;
import hiiragi283.ragium.common.inventory.container.HTBlockEntityContainerMenu;
import hiiragi283.ragium.common.material.HTColorMaterial;
import hiiragi283.ragium.common.material.HTMoltenCrystalData;
import hiiragi283.ragium.common.variant.HTDeviceVariant;
import hiiragi283.ragium.setup.RagiumBlocks;
import hiiragi283.ragium.setup.RagiumDataComponents;
import hiiragi283.ragium.setup.RagiumEntityTypes;
import hiiragi283.ragium.setup.RagiumFluidContents;
import hiiragi283.ragium.setup.RagiumItems;
import hiiragi283.ragium.setup.RagiumMenuTypes;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="ragium", dist={Dist.CLIENT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020 H\u0002\u00a8\u0006\""}, d2={"Lhiiragi283/ragium/client/RagiumClient;", "", "eventBus", "Lnet/neoforged/bus/api/IEventBus;", "container", "Lnet/neoforged/fml/ModContainer;", "<init>", "(Lnet/neoforged/bus/api/IEventBus;Lnet/neoforged/fml/ModContainer;)V", "clientSetup", "", "event", "Lnet/neoforged/fml/event/lifecycle/FMLClientSetupEvent;", "registerAccessories", "accessoryRenderer", "item", "Lnet/minecraft/world/level/ItemLike;", "supplier", "Lkotlin/Function0;", "Lio/wispforest/accessories/api/client/AccessoryRenderer;", "registerBlockColor", "Lnet/neoforged/neoforge/client/event/RegisterColorHandlersEvent$Block;", "registerItemColor", "Lnet/neoforged/neoforge/client/event/RegisterColorHandlersEvent$Item;", "registerClientExtensions", "Lnet/neoforged/neoforge/client/extensions/common/RegisterClientExtensionsEvent;", "registerScreens", "Lnet/neoforged/neoforge/client/event/RegisterMenuScreensEvent;", "registerEntityRenderer", "Lnet/neoforged/neoforge/client/event/EntityRenderersEvent$RegisterRenderers;", "registerTooltipRenderer", "Lnet/neoforged/neoforge/client/event/RegisterClientTooltipComponentFactoriesEvent;", "registerKeyMappings", "Lnet/neoforged/neoforge/client/event/RegisterKeyMappingsEvent;", "Companion", "ragium"})
@SourceDebugExtension(value={"SMAP\nRagiumClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagiumClient.kt\nhiiragi283/ragium/client/RagiumClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n1869#2,2:277\n*S KotlinDebug\n*F\n+ 1 RagiumClient.kt\nhiiragi283/ragium/client/RagiumClient\n*L\n271#1:277,2\n*E\n"})
public final class RagiumClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    public RagiumClient(@NotNull IEventBus eventBus, @NotNull ModContainer container) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::registerBlockColor);
        eventBus.addListener(this::registerItemColor);
        eventBus.addListener(this::registerClientExtensions);
        eventBus.addListener(this::registerScreens);
        eventBus.addListener(this::registerEntityRenderer);
        eventBus.addListener(this::registerTooltipRenderer);
        eventBus.addListener(this::registerKeyMappings);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private final void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerAccessories);
        LOGGER.info("Loaded Client Setup!");
    }

    private final void registerAccessories() {
        this.accessoryRenderer(RagiumItems.ECHO_STAR, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.1.INSTANCE));
        this.accessoryRenderer(RagiumItems.NIGHT_VISION_GOGGLES, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.2.INSTANCE));
        this.accessoryRenderer(RagiumItems.POTION_BUNDLE, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.3.INSTANCE));
        this.accessoryRenderer(RagiumItems.UNIVERSAL_BUNDLE, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.4.INSTANCE));
        LOGGER.info("Registered Accessory Renderer!");
    }

    private final void accessoryRenderer(ItemLike item, Function0<? extends AccessoryRenderer> supplier) {
        AccessoriesRendererRegistry.registerRenderer((Item)item.asItem(), () -> RagiumClient.accessoryRenderer$lambda$0(supplier));
    }

    private final void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        Block[] blockArray = new Block[]{HTDeviceVariant.WATER_COLLECTOR.getBlockHolder().get()};
        event.register(RagiumClient::registerBlockColor$lambda$1, blockArray);
        for (Map.Entry entry : RagiumBlocks.LED_BLOCKS.entrySet()) {
            HTColorMaterial color = (HTColorMaterial)entry.getKey();
            HTDeferredBlock block = (HTDeferredBlock)entry.getValue();
            Block[] blockArray2 = new Block[]{block.get()};
            event.register((arg_0, arg_1, arg_2, arg_3) -> RagiumClient.registerBlockColor$lambda$2(color, arg_0, arg_1, arg_2, arg_3), blockArray2);
        }
        LOGGER.info("Registered BlockColor!");
    }

    private final void registerItemColor(RegisterColorHandlersEvent.Item event) {
        Object object = new ItemLike[]{HTDeviceVariant.WATER_COLLECTOR};
        event.register(RagiumClient::registerItemColor$lambda$3, (ItemLike[])object);
        for (Map.Entry entry : RagiumBlocks.LED_BLOCKS.entrySet()) {
            HTColorMaterial variant = (HTColorMaterial)entry.getKey();
            HTDeferredBlock block = (HTDeferredBlock)entry.getValue();
            ItemLike[] itemLikeArray = new ItemLike[]{block.get()};
            event.register((arg_0, arg_1) -> RagiumClient.registerItemColor$lambda$4(variant, arg_0, arg_1), itemLikeArray);
        }
        for (HTDeferredItem hTDeferredItem : RagiumFluidContents.REGISTER.getItemEntries()) {
            ItemLike[] itemLikeArray = new ItemLike[]{hTDeferredItem};
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), itemLikeArray);
        }
        object = new ItemLike[]{RagiumItems.UNIVERSAL_BUNDLE};
        event.register(RagiumClient::registerItemColor$lambda$5, (ItemLike[])object);
        LOGGER.info("Registered ItemColor!");
    }

    private final void registerClientExtensions(RegisterClientExtensionsEvent event) {
        FluidType[] fluidTypeArray = new FluidType[]{RagiumFluidContents.HONEY.getType()};
        event.registerFluidType((IClientFluidTypeExtensions)new HTSimpleFluidExtensions(RegistryExtensionsKt.vanillaId("block/honey_block_top"), null, null, 6, null), fluidTypeArray);
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.EXPERIENCE, new Color(0x66FF33));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.MUSHROOM_STEW, new Color(0xCC9966));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.ORGANIC_MUTAGEN, new Color(0x336600));
        RagiumClient.registerClientExtensions$molten(event, RagiumFluidContents.CRUDE_OIL, new Color(0x333333));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.NATURAL_GAS, new Color(0xCCCCCC));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.NAPHTHA, new Color(0xFF9966));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.FUEL, new Color(0xCC3300));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.CRIMSON_FUEL, new Color(0x663333));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.LUBRICANT, new Color(0xFF9900));
        RagiumClient.registerClientExtensions$liquid(event, RagiumFluidContents.SAP, new Color(0x996633));
        RagiumClient.registerClientExtensions$molten(event, RagiumFluidContents.GILDED_LAVA, new Color(0xFFCC00));
        for (HTMoltenCrystalData data : HTMoltenCrystalData.getEntries()) {
            HTFluidContent<?, ?, ?> sap;
            Color color = new Color(data.getColor());
            RagiumClient.registerClientExtensions$molten(event, data.getMolten(), color);
            if (data.getSap() == null) continue;
            RagiumClient.registerClientExtensions$liquid(event, sap, color);
        }
        LOGGER.info("Registered client extensions!");
    }

    private final void registerScreens(RegisterMenuScreensEvent event) {
        RagiumClient.registerScreens$registerMachine(event, RagiumMenuTypes.ALLOY_SMELTER);
        RagiumClient.registerScreens$registerMachine(event, RagiumMenuTypes.CRUSHER);
        RagiumClient.registerScreens$registerMachine(event, RagiumMenuTypes.CUTTING_MACHINE);
        RagiumClient.registerScreens$registerMachine(event, RagiumMenuTypes.SIMULATOR);
        RagiumClient.registerScreens$registerMachine(event, RagiumMenuTypes.SINGLE_ITEM);
        RagiumClient.registerScreens$registerMachine(event, RagiumMenuTypes.SMELTER);
        event.register((MenuType)RagiumMenuTypes.POTION_BUNDLE.get(), HTGenericScreen::new);
        event.register((MenuType)RagiumMenuTypes.UNIVERSAL_BUNDLE.get(), HTGenericScreen::new);
        event.register((MenuType)RagiumMenuTypes.ACCESS_CONFIG.get(), HTAccessConfigurationScreen::new);
        event.register((MenuType)RagiumMenuTypes.COMPRESSOR.get(), HTItemToItemScreen.Companion::compressor);
        event.register((MenuType)RagiumMenuTypes.DRUM.get(), HTDrumScreen::new);
        event.register((MenuType)RagiumMenuTypes.ENERGY_NETWORK_ACCESS.get(), HTEnergyNetworkAccessScreen::new);
        event.register((MenuType)RagiumMenuTypes.EXTRACTOR.get(), HTItemToItemScreen.Companion::extractor);
        event.register((MenuType)RagiumMenuTypes.FLUID_COLLECTOR.get(), HTFluidCollectorScreen::new);
        event.register((MenuType)RagiumMenuTypes.FUEL_GENERATOR.get(), HTFuelGeneratorScreen::new);
        event.register((MenuType)RagiumMenuTypes.ITEM_BUFFER.get(), HTItemBufferScreen::new);
        event.register((MenuType)RagiumMenuTypes.MELTER.get(), HTSingleFluidMachineScreen.Companion::melter);
        event.register((MenuType)RagiumMenuTypes.MOB_CAPTURER.get(), HTMobCapturerScreen::new);
        event.register((MenuType)RagiumMenuTypes.PULVERIZER.get(), HTItemToItemScreen.Companion::pulverizer);
        event.register((MenuType)RagiumMenuTypes.REFINERY.get(), HTRefineryScreen::new);
        event.register((MenuType)RagiumMenuTypes.TELEPAD.get(), HTTelepadScreen::new);
        event.register((MenuType)RagiumMenuTypes.WASHER.get(), HTSingleFluidMachineScreen.Companion::washer);
        LOGGER.info("Registered Screens!");
    }

    private final void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(RagiumEntityTypes.BLAST_CHARGE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(RagiumEntityTypes.ELDRITCH_EGG.get(), ThrownItemRenderer::new);
        LOGGER.info("Registered BlockEntityRenderers!");
    }

    private final void registerTooltipRenderer(RegisterClientTooltipComponentFactoriesEvent event) {
        LOGGER.info("Registered ClientTooltipComponents!");
    }

    private final void registerKeyMappings(RegisterKeyMappingsEvent event) {
        Iterable $this$forEach$iv = RagiumKeyMappings.KEYS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyMapping p0 = (KeyMapping)element$iv;
            boolean bl = false;
            event.register(p0);
        }
        LOGGER.info("Registered Key Mappings!");
    }

    private static final AccessoryRenderer accessoryRenderer$lambda$0(Function0 $tmp0) {
        return (AccessoryRenderer)$tmp0.invoke();
    }

    private static final int registerBlockColor$lambda$1(BlockState blockState, BlockAndTintGetter getter2, BlockPos pos, int tint) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<unused var>");
        return tint != 0 ? -1 : (getter2 != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)getter2, (BlockPos)pos) : -1);
    }

    private static final int registerBlockColor$lambda$2(HTColorMaterial $color, BlockState blockState, BlockAndTintGetter blockAndTintGetter, BlockPos blockPos, int tint) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<unused var>");
        if (tint != 0) {
            return -1;
        }
        return $color.getColor().getTextureDiffuseColor();
    }

    private static final int registerItemColor$lambda$3(ItemStack itemStack, int tint) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<unused var>");
        return tint == 0 ? 4159204 : -1;
    }

    private static final int registerItemColor$lambda$4(HTColorMaterial $variant, ItemStack itemStack, int tint) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<unused var>");
        return tint != 0 ? -1 : $variant.getColor().getTextureDiffuseColor();
    }

    private static final int registerItemColor$lambda$5(ItemStack stack, int tint) {
        int n;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (tint != 0) {
            n = -1;
        } else {
            DyeColor dyeColor = (DyeColor)stack.get(RagiumDataComponents.COLOR);
            n = dyeColor != null ? dyeColor.getTextureDiffuseColor() : -1;
        }
        return n;
    }

    private static final void registerClientExtensions$liquid(RegisterClientExtensionsEvent $event, HTFluidContent<?, ?, ?> content, Color color) {
        FluidType[] fluidTypeArray = new FluidType[]{content.getType()};
        $event.registerFluidType((IClientFluidTypeExtensions)HTSimpleFluidExtensions.Companion.liquid(color), fluidTypeArray);
    }

    private static final void registerClientExtensions$molten(RegisterClientExtensionsEvent $event, HTFluidContent<?, ?, ?> content, Color color) {
        FluidType[] fluidTypeArray = new FluidType[]{content.getType()};
        $event.registerFluidType((IClientFluidTypeExtensions)HTSimpleFluidExtensions.Companion.molten(color), fluidTypeArray);
    }

    private static final String registerScreens$registerMachine$lambda$6(String it) {
        return "textures/gui/container/" + it + ".png";
    }

    private static final <BE extends HTMachineBlockEntity> void registerScreens$registerMachine(RegisterMenuScreensEvent $event, HTDeferredMenuType<? extends HTBlockEntityContainerMenu<BE>> menuType) {
        MenuType menuType2 = (MenuType)menuType.get();
        ResourceLocation resourceLocation = menuType.getId().withPath(RagiumClient::registerScreens$registerMachine$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withPath(...)");
        $event.register(menuType2, HTMachineScreen.Companion.create(resourceLocation));
    }

    static {
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lhiiragi283/ragium/client/RagiumClient$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$annotations", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOGGER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

