/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.block.entity.generator;

import hiiragi283.ragium.api.data.map.RagiumDataMaps;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.energy.HTEnergyBattery;
import hiiragi283.ragium.common.block.entity.generator.HTGeneratorBlockEntity;
import hiiragi283.ragium.common.variant.HTGeneratorVariant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0016"}, d2={"Lhiiragi283/ragium/common/block/entity/generator/HTSolarGeneratorBlockEntity;", "Lhiiragi283/ragium/common/block/entity/generator/HTGeneratorBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "openGui", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "title", "Lnet/minecraft/network/chat/Component;", "onUpdateServer", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "network", "Lhiiragi283/ragium/api/storage/energy/HTEnergyBattery;", "getGenerationMultiplier", "", "ragium"})
public final class HTSolarGeneratorBlockEntity
extends HTGeneratorBlockEntity {
    public HTSolarGeneratorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(HTGeneratorVariant.SOLAR, pos, state);
    }

    @Override
    @NotNull
    protected InteractionResult openGui(@NotNull Player player, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return InteractionResult.PASS;
    }

    @Override
    protected boolean onUpdateServer(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull HTEnergyBattery network) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        float multiplier = this.getGenerationMultiplier(level, pos);
        if (multiplier < 0.0f) {
            return false;
        }
        return network.insertEnergy(MathKt.roundToInt((float)((float)this.getEnergyUsage() * multiplier)), false, HTStorageAccess.INTERNAl) > 0;
    }

    private final float getGenerationMultiplier(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.above());
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState state = blockState;
        RegistryAccess registryAccess = level.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder holder = state.getBlockHolder();
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"getBlockHolder(...)");
        Float power = RagiumDataMaps.INSTANCE.getSolarPower(registryAccess, (Holder<Block>)holder);
        if (power != null) {
            return power.floatValue();
        }
        return !level.dimensionType().hasSkyLight() ? 0.0f : (!level.isDay() ? 0.0f : (level.canSeeSky(pos.above()) ? 1.0f : 0.0f));
    }
}

