/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.entity;

import hiiragi283.ragium.api.extension.LevelExtensionsKt;
import hiiragi283.ragium.api.tag.RagiumModTags;
import hiiragi283.ragium.setup.RagiumEntityTypes;
import hiiragi283.ragium.setup.RagiumItems;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B!\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0019"}, d2={"Lhiiragi283/ragium/common/entity/HTThrownCaptureEgg;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "x", "", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "onHitEntity", "", "result", "Lnet/minecraft/world/phys/EntityHitResult;", "onHitBlock", "Lnet/minecraft/world/phys/BlockHitResult;", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "Companion", "ragium"})
public final class HTThrownCaptureEgg
extends ThrowableItemProjectile {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public HTThrownCaptureEgg(@NotNull EntityType<? extends HTThrownCaptureEgg> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public HTThrownCaptureEgg(@NotNull Level level, @NotNull LivingEntity shooter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        super(RagiumEntityTypes.ELDRITCH_EGG.get(), shooter, level);
    }

    public HTThrownCaptureEgg(@NotNull Level level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(RagiumEntityTypes.ELDRITCH_EGG.get(), x, y, z, level);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            Entity entity = result.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
            Entity target = entity;
            ItemStack itemStack = Companion.getCapturedStack(target);
            if (itemStack == null) {
                return;
            }
            ItemStack spawnEgg = itemStack;
            this.playSound(SoundEvents.FIREWORK_ROCKET_BLAST);
            if (this.level().isClientSide) {
                Minecraft.getInstance().particleEngine.createTrackingEmitter(target, (ParticleOptions)ParticleTypes.FIREWORK);
            }
            target.discard();
            Entity entity2 = this.getOwner();
            if (entity2 == null) {
                entity2 = (Entity)this;
            }
            LevelExtensionsKt.dropStackAt(entity2, spawnEgg);
            this.discard();
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            Entity entity = this.getOwner();
            if (entity == null) {
                entity = (Entity)this;
            }
            ItemStack itemStack = this.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            LevelExtensionsKt.dropStackAt(entity, itemStack);
            this.discard();
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        Object object = RagiumItems.ELDRITCH_EGG.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    @JvmStatic
    @Nullable
    public static final ItemStack getCapturedStack(@NotNull Entity target) {
        return Companion.getCapturedStack(target);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lhiiragi283/ragium/common/entity/HTThrownCaptureEgg$Companion;", "", "<init>", "()V", "getCapturedStack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/entity/Entity;", "ragium"})
    @SourceDebugExtension(value={"SMAP\nHTThrownCaptureEgg.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTThrownCaptureEgg.kt\nhiiragi283/ragium/common/entity/HTThrownCaptureEgg$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ItemStack getCapturedStack(@NotNull Entity target) {
            ItemStack itemStack;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            EntityType entityType = target.getType();
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getType(...)");
            EntityType targetType = entityType;
            if (targetType.is(RagiumModTags.EntityTypes.CAPTURE_BLACKLIST)) {
                return null;
            }
            SpawnEggItem spawnEggItem = SpawnEggItem.byId((EntityType)targetType);
            if (spawnEggItem != null) {
                ItemLike p0 = (ItemLike)spawnEggItem;
                boolean bl = false;
                itemStack = new ItemStack(p0);
            } else {
                itemStack = null;
            }
            return itemStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

