/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.recipe;

import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.extension.RangeExtensionsKt;
import hiiragi283.ragium.api.tag.RagiumCommonTags;
import hiiragi283.ragium.setup.RagiumItems;
import hiiragi283.ragium.setup.RagiumRecipeSerializers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lhiiragi283/ragium/common/recipe/HTIceCreamSodaRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "category", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "matches", "", "input", "Lnet/minecraft/world/item/crafting/CraftingInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "", "height", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "ragium"})
public final class HTIceCreamSodaRecipe
extends CustomRecipe {
    public HTIceCreamSodaRecipe(@NotNull CraftingBookCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        super(category);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        boolean isIceCream = false;
        boolean isCherry = false;
        boolean isPotion = false;
        boolean isDye = false;
        IntRange intRange = RangeExtensionsKt.getIndices((RecipeInput)input);
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                ItemStack stackIn;
                Intrinsics.checkNotNullExpressionValue((Object)input.getItem(index), (String)"getItem(...)");
                if (!stackIn.isEmpty()) {
                    if (stackIn.is((Holder)RagiumItems.ICE_CREAM) && !isIceCream) {
                        isIceCream = true;
                    } else if (stackIn.is(RagiumCommonTags.Items.FOODS_CHERRY) && !isCherry) {
                        isCherry = true;
                    } else if (stackIn.has(DataComponents.POTION_CONTENTS) && !isPotion) {
                        isPotion = true;
                    } else if (stackIn.is(Tags.Items.DYES_GREEN) && !isDye) {
                        isDye = true;
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
        return isIceCream && isCherry && isPotion && isDye;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        PotionContents potionContents = PotionContents.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)potionContents, (String)"EMPTY");
        PotionContents potion = potionContents;
        IntRange intRange = RangeExtensionsKt.getIndices((RecipeInput)input);
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                ItemStack stackIn;
                Intrinsics.checkNotNullExpressionValue((Object)input.getItem(index), (String)"getItem(...)");
                if (!stackIn.isEmpty() && stackIn.has(DataComponents.POTION_CONTENTS)) {
                    Object object = stackIn.get(DataComponents.POTION_CONTENTS);
                    Intrinsics.checkNotNull((Object)object);
                    potion = (PotionContents)object;
                }
                if (index == n) break;
                ++index;
            }
        }
        return RagiumAPI.createSoda$default(RagiumAPI.Companion.getINSTANCE(), potion, 0, 2, null);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RagiumRecipeSerializers.ICE_CREAM_SODA;
    }
}

