/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.storage;

import com.mojang.logging.LogUtils;
import hiiragi283.ragium.api.storage.HTMultiCapability;
import hiiragi283.ragium.api.storage.fluid.HTFluidTank;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import hiiragi283.ragium.api.storage.value.HTValueInput;
import hiiragi283.ragium.api.storage.value.HTValueOutput;
import hiiragi283.ragium.api.storage.value.HTValueSerializable;
import hiiragi283.ragium.common.block.entity.HTBlockEntity;
import hiiragi283.ragium.common.storage.HTCapabilityCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001 BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tJ\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0002J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\tJ\u001c\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u001e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lhiiragi283/ragium/common/storage/HTCapabilityCodec;", "CONTAINER", "Lhiiragi283/ragium/api/storage/value/HTValueSerializable;", "", "containerTag", "", "containerKey", "blockEntityGetter", "Lkotlin/Function2;", "Lhiiragi283/ragium/common/block/entity/HTBlockEntity;", "Lnet/minecraft/core/Direction;", "", "canHandle", "Lkotlin/Function1;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "saveTo", "", "output", "Lhiiragi283/ragium/api/storage/value/HTValueOutput;", "blockEntity", "containers", "save", "list", "Lhiiragi283/ragium/api/storage/value/HTValueOutput$ValueOutputList;", "loadFrom", "input", "Lhiiragi283/ragium/api/storage/value/HTValueInput;", "load", "Lhiiragi283/ragium/api/storage/value/HTValueInput$ValueInputList;", "getContainers", "Companion", "ragium"})
@SourceDebugExtension(value={"SMAP\nHTCapabilityCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTCapabilityCodec.kt\nhiiragi283/ragium/common/storage/HTCapabilityCodec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1878#2,3:122\n*S KotlinDebug\n*F\n+ 1 HTCapabilityCodec.kt\nhiiragi283/ragium/common/storage/HTCapabilityCodec\n*L\n92#1:122,3\n*E\n"})
public final class HTCapabilityCodec<CONTAINER extends HTValueSerializable> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String containerTag;
    @NotNull
    private final String containerKey;
    @NotNull
    private final Function2<HTBlockEntity, Direction, List<CONTAINER>> blockEntityGetter;
    @NotNull
    private final Function1<HTBlockEntity, Boolean> canHandle;
    @JvmField
    @NotNull
    public static final Logger LOGGER;
    @JvmField
    @NotNull
    public static final HTCapabilityCodec<HTItemSlot> ITEM;
    @JvmField
    @NotNull
    public static final HTCapabilityCodec<HTFluidTank> FLUID;
    @JvmField
    @NotNull
    public static final List<HTCapabilityCodec<?>> TYPES;

    public HTCapabilityCodec(@NotNull String containerTag, @NotNull String containerKey, @NotNull Function2<? super HTBlockEntity, ? super Direction, ? extends List<? extends CONTAINER>> blockEntityGetter, @NotNull Function1<? super HTBlockEntity, Boolean> canHandle) {
        Intrinsics.checkNotNullParameter((Object)containerTag, (String)"containerTag");
        Intrinsics.checkNotNullParameter((Object)containerKey, (String)"containerKey");
        Intrinsics.checkNotNullParameter(blockEntityGetter, (String)"blockEntityGetter");
        Intrinsics.checkNotNullParameter(canHandle, (String)"canHandle");
        this.containerTag = containerTag;
        this.containerKey = containerKey;
        this.blockEntityGetter = blockEntityGetter;
        this.canHandle = canHandle;
    }

    public final void saveTo(@NotNull HTValueOutput output, @NotNull HTBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        this.saveTo(output, this.getContainers(blockEntity));
    }

    public final void saveTo(@NotNull HTValueOutput output, @NotNull List<? extends CONTAINER> containers) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        this.save(output.childrenList(this.containerTag), containers);
    }

    /*
     * WARNING - void declaration
     */
    private final void save(HTValueOutput.ValueOutputList list, List<? extends CONTAINER> containers) {
        Iterable $this$forEachIndexed$iv = containers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void container;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            HTValueSerializable hTValueSerializable = (HTValueSerializable)item$iv;
            int slot = n;
            boolean bl = false;
            HTValueOutput output = list.addChild();
            container.serialize(output);
            output.putInt(this.containerKey, slot);
        }
    }

    public final void loadFrom(@NotNull HTValueInput input, @NotNull HTBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        this.loadFrom(input, this.getContainers(blockEntity));
    }

    public final void loadFrom(@NotNull HTValueInput input, @NotNull List<? extends CONTAINER> containers) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        this.load(input.childrenListOrEmpty(this.containerTag), containers);
    }

    private final void load(HTValueInput.ValueInputList list, List<? extends CONTAINER> containers) {
        if (list.isEmpty()) {
            return;
        }
        for (HTValueInput input : list) {
            Integer n = input.getInt(this.containerKey);
            if (n == null) {
                continue;
            }
            int slot = n;
            boolean bl = 0 <= slot ? slot < ((Collection)containers).size() : false;
            if (!bl) continue;
            ((HTValueSerializable)containers.get(slot)).deserialize(input);
        }
    }

    @NotNull
    public final List<CONTAINER> getContainers(@NotNull HTBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        return (List)this.blockEntityGetter.invoke((Object)blockEntity, null);
    }

    public final boolean canHandle(@NotNull HTBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        return (Boolean)this.canHandle.invoke((Object)blockEntity);
    }

    @JvmStatic
    public static final void registerItem(@NotNull RegisterCapabilitiesEvent event, @NotNull Function1<? super ItemStack, ? extends IItemHandler> getter2, ItemLike ... items) {
        Companion.registerItem(event, getter2, items);
    }

    @JvmStatic
    public static final void registerFluid(@NotNull RegisterCapabilitiesEvent event, @NotNull Function1<? super ItemStack, ? extends IFluidHandlerItem> getter2, ItemLike ... items) {
        Companion.registerFluid(event, getter2, items);
    }

    @JvmStatic
    public static final void registerEnergy(@NotNull RegisterCapabilitiesEvent event, @NotNull Function1<? super ItemStack, ? extends IEnergyStorage> getter2, ItemLike ... items) {
        Companion.registerEnergy(event, getter2, items);
    }

    static {
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        ITEM = new HTCapabilityCodec("items", "slot", Companion.ITEM.1.INSTANCE, (Function1<? super HTBlockEntity, Boolean>)((Function1)Companion.ITEM.2.INSTANCE));
        FLUID = new HTCapabilityCodec("fluids", "tank", Companion.FLUID.1.INSTANCE, (Function1<? super HTBlockEntity, Boolean>)((Function1)Companion.FLUID.2.INSTANCE));
        Object[] objectArray = new HTCapabilityCodec[]{ITEM, FLUID};
        TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00122\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J?\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00122\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J?\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u00122\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lhiiragi283/ragium/common/storage/HTCapabilityCodec$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "ITEM", "Lhiiragi283/ragium/common/storage/HTCapabilityCodec;", "Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "FLUID", "Lhiiragi283/ragium/api/storage/fluid/HTFluidTank;", "TYPES", "", "registerItem", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "getter", "Lkotlin/Function1;", "Lnet/minecraft/world/item/ItemStack;", "Lnet/neoforged/neoforge/items/IItemHandler;", "items", "", "Lnet/minecraft/world/level/ItemLike;", "(Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;Lkotlin/jvm/functions/Function1;[Lnet/minecraft/world/level/ItemLike;)V", "registerFluid", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandlerItem;", "registerEnergy", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "ragium"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void registerItem(@NotNull RegisterCapabilitiesEvent event, @NotNull Function1<? super ItemStack, ? extends IItemHandler> getter2, ItemLike ... items) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(getter2, (String)"getter");
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            event.registerItem(HTMultiCapability.ITEM.getItemCapability(), (arg_0, arg_1) -> Companion.registerItem$lambda$0(getter2, arg_0, arg_1), Arrays.copyOf(items, items.length));
        }

        @JvmStatic
        public final void registerFluid(@NotNull RegisterCapabilitiesEvent event, @NotNull Function1<? super ItemStack, ? extends IFluidHandlerItem> getter2, ItemLike ... items) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(getter2, (String)"getter");
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            event.registerItem(HTMultiCapability.FLUID.getItemCapability(), (arg_0, arg_1) -> Companion.registerFluid$lambda$1(getter2, arg_0, arg_1), Arrays.copyOf(items, items.length));
        }

        @JvmStatic
        public final void registerEnergy(@NotNull RegisterCapabilitiesEvent event, @NotNull Function1<? super ItemStack, ? extends IEnergyStorage> getter2, ItemLike ... items) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(getter2, (String)"getter");
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            event.registerItem(HTMultiCapability.ENERGY.getItemCapability(), (arg_0, arg_1) -> Companion.registerEnergy$lambda$2(getter2, arg_0, arg_1), Arrays.copyOf(items, items.length));
        }

        private static final IItemHandler registerItem$lambda$0(Function1 $getter, ItemStack stack, Void void_) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return (IItemHandler)$getter.invoke((Object)stack);
        }

        private static final IFluidHandlerItem registerFluid$lambda$1(Function1 $getter, ItemStack stack, Void void_) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return (IFluidHandlerItem)$getter.invoke((Object)stack);
        }

        private static final IEnergyStorage registerEnergy$lambda$2(Function1 $getter, ItemStack stack, Void void_) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return (IEnergyStorage)$getter.invoke((Object)stack);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

