package hiiragi283.ragium.client.network

import hiiragi283.ragium.api.RagiumAPI
import hiiragi283.ragium.api.network.HTCustomPayload
import hiiragi283.ragium.api.util.HTContentListener
import hiiragi283.ragium.api.util.access.HTAccessConfig
import hiiragi283.ragium.api.util.access.HTAccessConfigSetter
import net.minecraft.core.BlockPos
import net.minecraft.core.Direction
import net.minecraft.network.RegistryFriendlyByteBuf
import net.minecraft.network.codec.StreamCodec
import net.minecraft.network.protocol.common.custom.CustomPacketPayload
import net.minecraft.server.MinecraftServer
import net.minecraft.server.level.ServerPlayer

@JvmRecord
data class HTUpdateAccessConfigPayload(val pos: BlockPos, val direction: Direction, val transferIO: HTAccessConfig) :
    HTCustomPayload.C2S {
    companion object {
        @JvmField
        val TYPE = CustomPacketPayload.Type<HTUpdateAccessConfigPayload>(RagiumAPI.id("update_access_config"))

        @JvmField
        val STREAM_CODEC: StreamCodec<RegistryFriendlyByteBuf, HTUpdateAccessConfigPayload> = StreamCodec.composite(
            BlockPos.STREAM_CODEC,
            HTUpdateAccessConfigPayload::pos,
            Direction.STREAM_CODEC,
            HTUpdateAccessConfigPayload::direction,
            HTAccessConfig.CODEC.streamCodec,
            HTUpdateAccessConfigPayload::transferIO,
            ::HTUpdateAccessConfigPayload,
        )
    }

    override fun handle(player: ServerPlayer, server: MinecraftServer) {
        val setter: HTAccessConfigSetter = player.serverLevel().getBlockEntity(pos) as? HTAccessConfigSetter ?: return
        setter.setAccessConfig(direction, transferIO)
        if (setter is HTContentListener) {
            setter.onContentsChanged()
        }
    }

    override fun type(): CustomPacketPayload.Type<HTUpdateAccessConfigPayload> = TYPE
}
