package hiiragi283.ragium.impl.recipe.ingredient

import com.mojang.datafixers.util.Either
import hiiragi283.ragium.api.recipe.ingredient.HTFluidIngredient
import hiiragi283.ragium.api.serialization.codec.BiCodec
import hiiragi283.ragium.api.serialization.codec.BiCodecs
import hiiragi283.ragium.api.serialization.codec.VanillaBiCodecs
import hiiragi283.ragium.api.serialization.codec.downCast
import hiiragi283.ragium.api.stack.ImmutableFluidStack
import net.minecraft.core.Holder
import net.minecraft.core.HolderSet
import net.minecraft.core.registries.Registries
import net.minecraft.network.RegistryFriendlyByteBuf
import net.minecraft.tags.TagKey
import net.minecraft.world.level.material.Fluid

internal class HTFluidIngredientImpl(holderSet: HolderSet<Fluid>, amount: Int) :
    HTIngredientBase<Fluid, ImmutableFluidStack>(holderSet, amount),
    HTFluidIngredient {
    companion object {
        @JvmField
        val CODEC: BiCodec<RegistryFriendlyByteBuf, HTFluidIngredient> = BiCodec
            .composite(
                VanillaBiCodecs.holderSet(Registries.FLUID).fieldOf("fluids"),
                HTFluidIngredientImpl::holderSet,
                BiCodecs.POSITIVE_INT.fieldOf("amount"),
                HTFluidIngredientImpl::amount,
                ::HTFluidIngredientImpl,
            ).downCast()

            /*fun of(ingredient: FluidIngredient, amount: Int = 1): HTFluidIngredientImpl {
                check(amount >= 1)
                return HTFluidIngredientImpl(Either.right(ingredient), amount)
            }*/
    }

    override fun unwrap(): Either<Pair<TagKey<Fluid>, Int>, List<ImmutableFluidStack>> = holderSet.unwrap().map(
        { Either.left(it to amount) },
        { holders: List<Holder<Fluid>> ->
            Either.right(holders.map { holder: Holder<Fluid> -> ImmutableFluidStack.of(holder.value(), amount) })
        },
    )

    override fun test(stack: ImmutableFluidStack): Boolean = testOnlyType(stack) && stack.amount() >= this.amount

    override fun testOnlyType(stack: ImmutableFluidStack): Boolean = stack.isOf(holderSet)
}
