/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.api.inventory;

import hiiragi283.ragium.api.stack.ImmutableItemStack;
import hiiragi283.ragium.api.stack.ImmutableItemStacksKt;
import hiiragi283.ragium.api.storage.HTStackSetter;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.HTStorageAction;
import hiiragi283.ragium.api.storage.item.HTItemSlot;
import hiiragi283.ragium.api.storage.item.HTItemSlotsKt;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 )2\u00020\u0001:\u0002)*BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0005H\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010(\u001a\u00020\rH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lhiiragi283/ragium/api/inventory/HTContainerItemSlot;", "Lnet/minecraft/world/inventory/Slot;", "slot", "Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "x", "", "y", "stackSetter", "Lhiiragi283/ragium/api/storage/HTStackSetter;", "Lhiiragi283/ragium/api/stack/ImmutableItemStack;", "manualFilter", "Lkotlin/Function2;", "Lhiiragi283/ragium/api/storage/HTStorageAccess;", "", "slotType", "Lhiiragi283/ragium/api/inventory/HTContainerItemSlot$Type;", "<init>", "(Lhiiragi283/ragium/api/storage/item/HTItemSlot;IILhiiragi283/ragium/api/storage/HTStackSetter;Lkotlin/jvm/functions/Function2;Lhiiragi283/ragium/api/inventory/HTContainerItemSlot$Type;)V", "getSlot", "()Lhiiragi283/ragium/api/storage/item/HTItemSlot;", "getSlotType", "()Lhiiragi283/ragium/api/inventory/HTContainerItemSlot$Type;", "mayPlace", "stack", "Lnet/minecraft/world/item/ItemStack;", "getItem", "hasItem", "set", "", "setChanged", "getMaxStackSize", "mayPickup", "player", "Lnet/minecraft/world/entity/player/Player;", "remove", "amount", "tryRemove", "Ljava/util/Optional;", "count", "decrement", "allowPartialRemoval", "Companion", "Type", "ragium_api"})
public class HTContainerItemSlot
extends Slot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HTItemSlot slot;
    @NotNull
    private final HTStackSetter<ImmutableItemStack> stackSetter;
    @NotNull
    private final Function2<ImmutableItemStack, HTStorageAccess, Boolean> manualFilter;
    @NotNull
    private final Type slotType;
    @NotNull
    private static final SimpleContainer emptyContainer = new SimpleContainer(0);

    public HTContainerItemSlot(@NotNull HTItemSlot slot, int x, int y, @NotNull HTStackSetter<ImmutableItemStack> stackSetter, @NotNull Function2<? super ImmutableItemStack, ? super HTStorageAccess, Boolean> manualFilter, @NotNull Type slotType) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter(stackSetter, (String)"stackSetter");
        Intrinsics.checkNotNullParameter(manualFilter, (String)"manualFilter");
        Intrinsics.checkNotNullParameter((Object)((Object)slotType), (String)"slotType");
        super((Container)emptyContainer, 0, x, y);
        this.slot = slot;
        this.stackSetter = stackSetter;
        this.manualFilter = manualFilter;
        this.slotType = slotType;
    }

    @NotNull
    public final HTItemSlot getSlot() {
        return this.slot;
    }

    @NotNull
    public final Type getSlotType() {
        return this.slotType;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack itemStack = ImmutableItemStacksKt.toImmutable(stack);
        if (itemStack == null) {
            return false;
        }
        ItemStack immutable = itemStack;
        if (this.slot.getStack() == null) {
            ImmutableItemStack immutableItemStack = this.slot.insert-dA061ig(ImmutableItemStack.box-impl(immutable), HTStorageAction.Companion.getSIMULATE-fhPPMAc(), HTStorageAccess.MANUAL);
            Object object = immutableItemStack != null ? immutableItemStack.unbox-impl() : null;
            int remainder = object != null ? ImmutableItemStack.amount-impl(object) : 0;
            return remainder < stack.getCount();
        }
        if (this.slot.extract-dA061ig(1, HTStorageAction.Companion.getSIMULATE-fhPPMAc(), HTStorageAccess.MANUAL) == null) {
            return false;
        }
        return (Boolean)this.manualFilter.invoke((Object)ImmutableItemStack.box-impl(immutable), (Object)HTStorageAccess.MANUAL);
    }

    @NotNull
    public ItemStack getItem() {
        return HTItemSlotsKt.getItemStack(this.slot);
    }

    public boolean hasItem() {
        return this.slot.getStack() != null;
    }

    public void set(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack itemStack = ImmutableItemStacksKt.toImmutable(stack);
        this.stackSetter.setStack(itemStack != null ? ImmutableItemStack.box-impl(itemStack) : null);
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        this.slot.onContentsChanged();
    }

    public int getMaxStackSize() {
        return this.slot.getCapacity();
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack itemStack = ImmutableItemStacksKt.toImmutable(stack);
        return this.slot.getNeeded(itemStack != null ? ImmutableItemStack.box-impl(itemStack) : null);
    }

    public boolean mayPickup(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.slot.extract-dA061ig(1, HTStorageAction.Companion.getSIMULATE-fhPPMAc(), HTStorageAccess.MANUAL) != null;
    }

    @NotNull
    public ItemStack remove(int amount) {
        ImmutableItemStack immutableItemStack = (ImmutableItemStack)this.slot.extract-dA061ig(amount, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), HTStorageAccess.MANUAL);
        Object object = immutableItemStack != null ? immutableItemStack.unbox-impl() : null;
        if (object == null || (object = ImmutableItemStack.unwrap-impl(object)) == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            object = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        }
        return object;
    }

    @NotNull
    public Optional<ItemStack> tryRemove(int count, int decrement, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.allowPartialRemoval()) {
            if (!this.mayPickup(player)) {
                Optional<ItemStack> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            int count2 = Math.min(count, decrement);
            ItemStack stack = this.remove(count2);
            if (stack.isEmpty()) {
                Optional<ItemStack> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            if (this.getItem().isEmpty()) {
                this.setByPlayer(ItemStack.EMPTY, stack);
            }
            Optional<ItemStack> optional = Optional.of(stack);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return optional;
        }
        Optional optional = super.tryRemove(count, decrement, player);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"tryRemove(...)");
        return optional;
    }

    protected boolean allowPartialRemoval() {
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lhiiragi283/ragium/api/inventory/HTContainerItemSlot$Companion;", "", "<init>", "()V", "emptyContainer", "Lnet/minecraft/world/SimpleContainer;", "getEmptyContainer$annotations", "ragium_api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getEmptyContainer$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lhiiragi283/ragium/api/inventory/HTContainerItemSlot$Type;", "", "<init>", "(Ljava/lang/String;I)V", "INPUT", "OUTPUT", "BOTH", "ragium_api"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type INPUT = new Type();
        public static final /* enum */ Type OUTPUT = new Type();
        public static final /* enum */ Type BOTH = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.INPUT, Type.OUTPUT, Type.BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

