/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.client;

import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.registry.HTFluidContent;
import hiiragi283.ragium.api.registry.ResourceLocationsKt;
import hiiragi283.ragium.api.registry.impl.HTDeferredBlock;
import hiiragi283.ragium.api.registry.impl.HTDeferredItem;
import hiiragi283.ragium.api.registry.impl.HTDeferredMenuType;
import hiiragi283.ragium.client.HTSimpleFluidExtensions;
import hiiragi283.ragium.client.RagiumClient;
import hiiragi283.ragium.client.RagiumKeyMappings;
import hiiragi283.ragium.client.event.HTItemTooltipContent;
import hiiragi283.ragium.client.gui.screen.HTAccessConfigurationScreen;
import hiiragi283.ragium.client.gui.screen.HTBlockEntityContainerScreen;
import hiiragi283.ragium.client.gui.screen.HTConsumerScreen;
import hiiragi283.ragium.client.gui.screen.HTDrumScreen;
import hiiragi283.ragium.client.gui.screen.HTEnergyNetworkAccessScreen;
import hiiragi283.ragium.client.gui.screen.HTExpCollectorScreen;
import hiiragi283.ragium.client.gui.screen.HTFluidCollectorScreen;
import hiiragi283.ragium.client.gui.screen.HTFuelGeneratorScreen;
import hiiragi283.ragium.client.gui.screen.HTGenericScreen;
import hiiragi283.ragium.client.gui.screen.HTItemToItemScreen;
import hiiragi283.ragium.client.gui.screen.HTRefineryScreen;
import hiiragi283.ragium.client.gui.screen.HTSingleFluidConsumerScreen;
import hiiragi283.ragium.client.gui.screen.HTTelepadScreen;
import hiiragi283.ragium.client.model.HTFuelGeneratorModel;
import hiiragi283.ragium.client.renderer.RagiumModelLayers;
import hiiragi283.ragium.client.renderer.block.HTCrateRenderer;
import hiiragi283.ragium.client.renderer.block.HTFuelGeneratorRenderer;
import hiiragi283.ragium.client.renderer.block.HTRefineryRenderer;
import hiiragi283.ragium.client.renderer.block.HTSingleFluidMachineRenderer;
import hiiragi283.ragium.client.renderer.item.HTFuelGeneratorItemRenderer;
import hiiragi283.ragium.common.block.entity.consumer.HTConsumerBlockEntity;
import hiiragi283.ragium.common.inventory.container.HTBlockEntityContainerMenu;
import hiiragi283.ragium.common.material.HTColorMaterial;
import hiiragi283.ragium.common.material.RagiumMoltenCrystalData;
import hiiragi283.ragium.common.tier.HTCrateTier;
import hiiragi283.ragium.common.tier.HTDrumTier;
import hiiragi283.ragium.setup.RagiumBlockEntityTypes;
import hiiragi283.ragium.setup.RagiumBlocks;
import hiiragi283.ragium.setup.RagiumDataComponents;
import hiiragi283.ragium.setup.RagiumEntityTypes;
import hiiragi283.ragium.setup.RagiumFluidContents;
import hiiragi283.ragium.setup.RagiumItems;
import hiiragi283.ragium.setup.RagiumMenuTypes;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="ragium", dist={Dist.CLIENT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J(\u0010%\u001a\u00020\t*\u00020\u00122\u0012\u0010&\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020)H\u0002J(\u0010*\u001a\u00020\t*\u00020\u00122\u0012\u0010&\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020)H\u0002J2\u0010+\u001a\u00020\t\"\b\b\u0000\u0010,*\u00020-*\u00020\u00142\u001a\u0010.\u001a\u0016\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H,00\u0012\u0004\u0012\u0002H,0/H\u0002\u00a8\u00061"}, d2={"Lhiiragi283/ragium/client/RagiumClient;", "", "eventBus", "Lnet/neoforged/bus/api/IEventBus;", "container", "Lnet/neoforged/fml/ModContainer;", "<init>", "(Lnet/neoforged/bus/api/IEventBus;Lnet/neoforged/fml/ModContainer;)V", "clientSetup", "", "event", "Lnet/neoforged/fml/event/lifecycle/FMLClientSetupEvent;", "registerAccessories", "registerBlockColor", "Lnet/neoforged/neoforge/client/event/RegisterColorHandlersEvent$Block;", "registerItemColor", "Lnet/neoforged/neoforge/client/event/RegisterColorHandlersEvent$Item;", "registerClientExtensions", "Lnet/neoforged/neoforge/client/extensions/common/RegisterClientExtensionsEvent;", "registerScreens", "Lnet/neoforged/neoforge/client/event/RegisterMenuScreensEvent;", "registerLayerDefinitions", "Lnet/neoforged/neoforge/client/event/EntityRenderersEvent$RegisterLayerDefinitions;", "registerClientReloadListeners", "Lnet/neoforged/neoforge/client/event/RegisterClientReloadListenersEvent;", "registerEntityRenderer", "Lnet/neoforged/neoforge/client/event/EntityRenderersEvent$RegisterRenderers;", "registerTooltipRenderer", "Lnet/neoforged/neoforge/client/event/RegisterClientTooltipComponentFactoriesEvent;", "registerKeyMappings", "Lnet/neoforged/neoforge/client/event/RegisterKeyMappingsEvent;", "accessoryRenderer", "item", "Lnet/minecraft/world/level/ItemLike;", "supplier", "Lkotlin/Function0;", "Lio/wispforest/accessories/api/client/AccessoryRenderer;", "liquid", "content", "Lhiiragi283/ragium/api/registry/HTFluidContent;", "color", "Ljava/awt/Color;", "molten", "registerConsumer", "BE", "Lhiiragi283/ragium/common/block/entity/consumer/HTConsumerBlockEntity;", "menuType", "Lhiiragi283/ragium/api/registry/impl/HTDeferredMenuType$WithContext;", "Lhiiragi283/ragium/common/inventory/container/HTBlockEntityContainerMenu;", "ragium"})
@SourceDebugExtension(value={"SMAP\nRagiumClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagiumClient.kt\nhiiragi283/ragium/client/RagiumClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n1869#2,2:343\n*S KotlinDebug\n*F\n+ 1 RagiumClient.kt\nhiiragi283/ragium/client/RagiumClient\n*L\n314#1:343,2\n*E\n"})
public final class RagiumClient {
    public RagiumClient(@NotNull IEventBus eventBus, @NotNull ModContainer container) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::registerBlockColor);
        eventBus.addListener(this::registerItemColor);
        eventBus.addListener(this::registerClientExtensions);
        eventBus.addListener(this::registerScreens);
        eventBus.addListener(this::registerEntityRenderer);
        eventBus.addListener(this::registerLayerDefinitions);
        eventBus.addListener(this::registerClientReloadListeners);
        eventBus.addListener(this::registerTooltipRenderer);
        eventBus.addListener(this::registerKeyMappings);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private final void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerAccessories);
        RagiumAPI.LOGGER.info("Loaded Client Setup!");
    }

    private final void registerAccessories() {
        this.accessoryRenderer(RagiumItems.ECHO_STAR, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.1.INSTANCE));
        this.accessoryRenderer(RagiumItems.NIGHT_VISION_GOGGLES, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.2.INSTANCE));
        this.accessoryRenderer(RagiumItems.POTION_BUNDLE, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.3.INSTANCE));
        this.accessoryRenderer(RagiumItems.UNIVERSAL_BUNDLE, (Function0<? extends AccessoryRenderer>)((Function0)registerAccessories.4.INSTANCE));
        RagiumAPI.LOGGER.info("Registered Accessory Renderer!");
    }

    private final void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        Block[] blockArray = new Block[]{RagiumBlocks.WATER_COLLECTOR.get()};
        event.register(RagiumClient::registerBlockColor$lambda$0, blockArray);
        for (Map.Entry entry : RagiumBlocks.LED_BLOCKS.entrySet()) {
            HTColorMaterial color = (HTColorMaterial)entry.getKey();
            HTDeferredBlock block = (HTDeferredBlock)entry.getValue();
            Block[] blockArray2 = new Block[]{block.get()};
            event.register((arg_0, arg_1, arg_2, arg_3) -> RagiumClient.registerBlockColor$lambda$1(color, arg_0, arg_1, arg_2, arg_3), blockArray2);
        }
        RagiumAPI.LOGGER.info("Registered BlockColor!");
    }

    private final void registerItemColor(RegisterColorHandlersEvent.Item event) {
        Object object = new ItemLike[]{RagiumBlocks.WATER_COLLECTOR};
        event.register(RagiumClient::registerItemColor$lambda$2, (ItemLike[])object);
        for (Map.Entry entry : RagiumBlocks.LED_BLOCKS.entrySet()) {
            HTColorMaterial variant = (HTColorMaterial)entry.getKey();
            HTDeferredBlock block = (HTDeferredBlock)entry.getValue();
            ItemLike[] itemLikeArray = new ItemLike[]{block.get()};
            event.register((arg_0, arg_1) -> RagiumClient.registerItemColor$lambda$3(variant, arg_0, arg_1), itemLikeArray);
        }
        for (HTDeferredItem hTDeferredItem : RagiumFluidContents.REGISTER.getItemEntries()) {
            ItemLike[] itemLikeArray = new ItemLike[]{hTDeferredItem};
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), itemLikeArray);
        }
        object = new ItemLike[]{RagiumItems.UNIVERSAL_BUNDLE};
        event.register(RagiumClient::registerItemColor$lambda$4, (ItemLike[])object);
        RagiumAPI.LOGGER.info("Registered ItemColor!");
    }

    private final void registerClientExtensions(RegisterClientExtensionsEvent event) {
        Object object = new FluidType[]{RagiumFluidContents.HONEY.getType()};
        event.registerFluidType((IClientFluidTypeExtensions)new HTSimpleFluidExtensions(ResourceLocationsKt.vanillaId("block", "honey_block_top"), null, null, 6, null), (FluidType[])object);
        this.liquid(event, RagiumFluidContents.EXPERIENCE, new Color(0x66FF33));
        this.liquid(event, RagiumFluidContents.MUSHROOM_STEW, new Color(0xCC9966));
        this.liquid(event, RagiumFluidContents.ORGANIC_MUTAGEN, new Color(0x336600));
        this.molten(event, RagiumFluidContents.CRUDE_OIL, new Color(0x333333));
        this.liquid(event, RagiumFluidContents.NATURAL_GAS, new Color(0xCCCCCC));
        this.liquid(event, RagiumFluidContents.NAPHTHA, new Color(0xFF9966));
        this.liquid(event, RagiumFluidContents.LUBRICANT, new Color(0xFF9900));
        this.liquid(event, RagiumFluidContents.FUEL, new Color(0xCC3300));
        this.liquid(event, RagiumFluidContents.CRIMSON_FUEL, new Color(0x663333));
        this.liquid(event, RagiumFluidContents.GREEN_FUEL, new Color(0x99CC33));
        this.liquid(event, RagiumFluidContents.SAP, new Color(0x996633));
        this.molten(event, RagiumFluidContents.GILDED_LAVA, new Color(0xFFCC00));
        for (RagiumMoltenCrystalData data : RagiumMoltenCrystalData.getEntries()) {
            HTFluidContent<?, ?, ?> sap;
            Color color = new Color(data.getColor());
            this.molten(event, data.getMolten(), color);
            if (data.getSap() == null) continue;
            this.liquid(event, sap, color);
        }
        object = new Item[]{RagiumBlocks.THERMAL_GENERATOR.asItem(), RagiumBlocks.COMBUSTION_GENERATOR.asItem(), RagiumBlocks.ENCHANTMENT_GENERATOR.asItem()};
        event.registerItem(new IClientItemExtensions(){

            public HTFuelGeneratorItemRenderer getCustomRenderer() {
                return HTFuelGeneratorItemRenderer.INSTANCE;
            }
        }, (Item[])object);
        RagiumAPI.LOGGER.info("Registered client extensions!");
    }

    private final void registerScreens(RegisterMenuScreensEvent event) {
        this.registerConsumer(event, RagiumMenuTypes.ALLOY_SMELTER);
        this.registerConsumer(event, RagiumMenuTypes.CUTTING_MACHINE);
        this.registerConsumer(event, RagiumMenuTypes.SIMULATOR);
        this.registerConsumer(event, RagiumMenuTypes.SINGLE_ITEM);
        this.registerConsumer(event, RagiumMenuTypes.SMELTER);
        event.register((MenuType)RagiumMenuTypes.POTION_BUNDLE.get(), HTGenericScreen::new);
        event.register((MenuType)RagiumMenuTypes.UNIVERSAL_BUNDLE.get(), HTGenericScreen::new);
        event.register((MenuType)RagiumMenuTypes.ACCESS_CONFIG.get(), HTAccessConfigurationScreen::new);
        event.register((MenuType)RagiumMenuTypes.CHANCED_ITEM_OUTPUT.get(), HTSingleFluidConsumerScreen.Companion::chancedItemOutput);
        event.register((MenuType)RagiumMenuTypes.COMPRESSOR.get(), HTItemToItemScreen.Companion::compressor);
        event.register((MenuType)RagiumMenuTypes.DRUM.get(), HTDrumScreen::new);
        event.register((MenuType)RagiumMenuTypes.ENERGY_NETWORK_ACCESS.get(), HTEnergyNetworkAccessScreen::new);
        event.register((MenuType)RagiumMenuTypes.EXTRACTOR.get(), HTItemToItemScreen.Companion::extractor);
        event.register((MenuType)RagiumMenuTypes.EXP_COLLECTOR.get(), HTExpCollectorScreen::new);
        event.register((MenuType)RagiumMenuTypes.FLUID_COLLECTOR.get(), HTFluidCollectorScreen::new);
        event.register((MenuType)RagiumMenuTypes.FUEL_GENERATOR.get(), HTFuelGeneratorScreen::new);
        event.register((MenuType)RagiumMenuTypes.ITEM_BUFFER.get(), HTBlockEntityContainerScreen.Companion.createSimple("item_buffer"));
        event.register((MenuType)RagiumMenuTypes.MELTER.get(), HTSingleFluidConsumerScreen.Companion::melter);
        event.register((MenuType)RagiumMenuTypes.MOB_CAPTURER.get(), HTBlockEntityContainerScreen.Companion.createSimple("item_collector"));
        event.register((MenuType)RagiumMenuTypes.PULVERIZER.get(), HTItemToItemScreen.Companion::pulverizer);
        event.register((MenuType)RagiumMenuTypes.REFINERY.get(), HTRefineryScreen::new);
        event.register((MenuType)RagiumMenuTypes.TELEPAD.get(), HTTelepadScreen::new);
        RagiumAPI.LOGGER.info("Registered Screens!");
    }

    private final void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RagiumModelLayers.FUEL_GENERATOR, HTFuelGeneratorModel.Companion::createLayer);
        for (ModelLayerLocation location : RagiumModelLayers.DRUM_MINECARTS.values()) {
            event.registerLayerDefinition(location, MinecartModel::createBodyLayer);
        }
        RagiumAPI.LOGGER.info("Registered Layer Definitions!");
    }

    private final void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)HTFuelGeneratorItemRenderer.INSTANCE);
        RagiumAPI.LOGGER.info("Registered Client Reload Listeners!");
    }

    private final void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)RagiumBlockEntityTypes.MELTER.get(), HTSingleFluidMachineRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RagiumBlockEntityTypes.REFINERY.get(), HTRefineryRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RagiumBlockEntityTypes.WASHER.get(), HTSingleFluidMachineRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RagiumBlockEntityTypes.THERMAL_GENERATOR.get(), HTFuelGeneratorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RagiumBlockEntityTypes.COMBUSTION_GENERATOR.get(), HTFuelGeneratorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)RagiumBlockEntityTypes.ENCHANTMENT_GENERATOR.get(), HTFuelGeneratorRenderer::new);
        for (Enum tier : HTCrateTier.getEntries()) {
            event.registerBlockEntityRenderer((BlockEntityType)((HTCrateTier)tier).getBlockEntityType().get(), HTCrateRenderer::new);
        }
        event.registerEntityRenderer((EntityType)RagiumEntityTypes.BLAST_CHARGE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)RagiumEntityTypes.ELDRITCH_EGG.get(), ThrownItemRenderer::new);
        for (Enum tier : HTDrumTier.getEntries()) {
            ModelLayerLocation layerDefinition;
            if (RagiumModelLayers.DRUM_MINECARTS.get(tier) == null) continue;
            event.registerEntityRenderer((EntityType)((HTDrumTier)tier).getEntityType().get(), arg_0 -> RagiumClient.registerEntityRenderer$lambda$5(layerDefinition, arg_0));
        }
        RagiumAPI.LOGGER.info("Registered Entity Renderers!");
    }

    private final void registerTooltipRenderer(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(HTItemTooltipContent.class, arg_0 -> RagiumClient.registerTooltipRenderer$lambda$6(registerTooltipRenderer.1.INSTANCE, arg_0));
        RagiumAPI.LOGGER.info("Registered ClientTooltipComponents!");
    }

    private final void registerKeyMappings(RegisterKeyMappingsEvent event) {
        Iterable $this$forEach$iv = RagiumKeyMappings.KEYS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyMapping p0 = (KeyMapping)element$iv;
            boolean bl = false;
            event.register(p0);
        }
        RagiumAPI.LOGGER.info("Registered Key Mappings!");
    }

    private final void accessoryRenderer(ItemLike item, Function0<? extends AccessoryRenderer> supplier) {
        AccessoriesRendererRegistry.registerRenderer((Item)item.asItem(), () -> RagiumClient.accessoryRenderer$lambda$7(supplier));
    }

    private final void liquid(RegisterClientExtensionsEvent $this$liquid, HTFluidContent<?, ?, ?> content, Color color) {
        FluidType[] fluidTypeArray = new FluidType[]{content.getType()};
        $this$liquid.registerFluidType((IClientFluidTypeExtensions)HTSimpleFluidExtensions.Companion.liquid(color), fluidTypeArray);
    }

    private final void molten(RegisterClientExtensionsEvent $this$molten, HTFluidContent<?, ?, ?> content, Color color) {
        FluidType[] fluidTypeArray = new FluidType[]{content.getType()};
        $this$molten.registerFluidType((IClientFluidTypeExtensions)HTSimpleFluidExtensions.Companion.molten(color), fluidTypeArray);
    }

    private final <BE extends HTConsumerBlockEntity> void registerConsumer(RegisterMenuScreensEvent $this$registerConsumer, HTDeferredMenuType.WithContext<? extends HTBlockEntityContainerMenu<BE>, BE> menuType) {
        MenuType menuType2 = (MenuType)menuType.get();
        ResourceLocation resourceLocation = menuType.getId().withPath(RagiumClient::registerConsumer$lambda$8);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withPath(...)");
        $this$registerConsumer.register(menuType2, HTConsumerScreen.Companion.create(resourceLocation));
    }

    private static final int registerBlockColor$lambda$0(BlockState blockState, BlockAndTintGetter getter, BlockPos pos, int tint) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<unused var>");
        return tint != 0 ? -1 : (getter != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)getter, (BlockPos)pos) : -1);
    }

    private static final int registerBlockColor$lambda$1(HTColorMaterial $color, BlockState blockState, BlockAndTintGetter blockAndTintGetter, BlockPos blockPos, int tint) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<unused var>");
        if (tint != 0) {
            return -1;
        }
        return $color.getDyeColor().getTextureDiffuseColor();
    }

    private static final int registerItemColor$lambda$2(ItemStack itemStack, int tint) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<unused var>");
        return tint == 0 ? 4159204 : -1;
    }

    private static final int registerItemColor$lambda$3(HTColorMaterial $variant, ItemStack itemStack, int tint) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<unused var>");
        return tint != 0 ? -1 : $variant.getDyeColor().getTextureDiffuseColor();
    }

    private static final int registerItemColor$lambda$4(ItemStack stack, int tint) {
        int n;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (tint != 0) {
            n = -1;
        } else {
            DyeColor dyeColor = (DyeColor)stack.get(RagiumDataComponents.COLOR);
            n = dyeColor != null ? dyeColor.getTextureDiffuseColor() : -1;
        }
        return n;
    }

    private static final EntityRenderer registerEntityRenderer$lambda$5(ModelLayerLocation $layerDefinition, EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (EntityRenderer)new MinecartRenderer(context, $layerDefinition);
    }

    private static final ClientTooltipComponent registerTooltipRenderer$lambda$6(Function1 $tmp0, Object p0) {
        return (ClientTooltipComponent)$tmp0.invoke(p0);
    }

    private static final AccessoryRenderer accessoryRenderer$lambda$7(Function0 $tmp0) {
        return (AccessoryRenderer)$tmp0.invoke();
    }

    private static final String registerConsumer$lambda$8(String it) {
        return "textures/gui/container/" + it + ".png";
    }
}

