/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import hiiragi283.ragium.api.block.attribute.HTBlockAttributesKt;
import hiiragi283.ragium.api.extension.RenderExtensionsKt;
import hiiragi283.ragium.api.stack.ImmutableFluidStack;
import hiiragi283.ragium.api.stack.ImmutableFluidStacksKt;
import hiiragi283.ragium.api.storage.fluid.HTFluidTank;
import hiiragi283.ragium.client.renderer.block.HTBlockEntityRenderer;
import hiiragi283.ragium.client.util.HTSpriteRenderHelper;
import hiiragi283.ragium.common.block.entity.consumer.HTRefineryBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J0\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002\u00a8\u0006\u0018"}, d2={"Lhiiragi283/ragium/client/renderer/block/HTRefineryRenderer;", "Lhiiragi283/ragium/client/renderer/block/HTBlockEntityRenderer;", "Lhiiragi283/ragium/common/block/entity/consumer/HTRefineryBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "drawFluid", "tank", "Lhiiragi283/ragium/api/storage/fluid/HTFluidTank;", "light", "overlay", "ragium"})
public final class HTRefineryRenderer
extends HTBlockEntityRenderer<HTRefineryBlockEntity> {
    public HTRefineryRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public void render(@NotNull HTRefineryBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        BlockState blockState = blockEntity.getBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        Direction direction = HTBlockAttributesKt.getAttributeDir(blockState);
        if (direction == null) {
            return;
        }
        Direction front = direction;
        poseStack.pushPose();
        RenderExtensionsKt.translate(poseStack, 0.5f);
        HTBlockEntityRenderer.Companion.rotate(poseStack, front);
        poseStack.translate(0.01f, -0.5f, 0.01f);
        this.drawFluid(blockEntity.getInputTank(), poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.pushPose();
        RenderExtensionsKt.translate(poseStack, 0.5f);
        HTBlockEntityRenderer.Companion.rotate(poseStack, front);
        poseStack.translate(-0.49f, -0.5f, 0.01f);
        this.drawFluid(blockEntity.getOutputTank(), poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private final void drawFluid(HTFluidTank tank, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        ImmutableFluidStack immutableFluidStack = (ImmutableFluidStack)tank.getStack();
        Object object = immutableFluidStack != null ? immutableFluidStack.unbox-impl() : null;
        if (object == null) {
            return;
        }
        FluidStack stack = object;
        TextureAtlasSprite textureAtlasSprite = HTSpriteRenderHelper.getFluidSprite-9GUZ3Vo(stack);
        if (textureAtlasSprite == null) {
            return;
        }
        TextureAtlasSprite sprite = textureAtlasSprite;
        float level = tank.getStoredLevelAsFloat();
        if (ImmutableFluidStack.fluidType-impl(stack).isLighterThanAir()) {
            poseStack.translate(0.0f, 1.0f - level, 0.0f);
        }
        poseStack.scale(0.48f, level, 0.48f);
        HTSpriteRenderHelper.drawFluidBox$default(poseStack, bufferSource, sprite, ImmutableFluidStacksKt.getTintColor-9GUZ3Vo(stack), light, overlay, null, 64, null);
    }
}

