/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.item;

import hiiragi283.ragium.api.item.component.HTTeleportPos;
import hiiragi283.ragium.api.stack.ImmutableFluidStack;
import hiiragi283.ragium.api.storage.HTStackView;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.HTStorageAction;
import hiiragi283.ragium.api.storage.capability.HTFluidCapabilities;
import hiiragi283.ragium.api.storage.fluid.HTFluidTank;
import hiiragi283.ragium.common.item.base.HTFluidItem;
import hiiragi283.ragium.common.util.HTItemHelper;
import hiiragi283.ragium.config.RagiumConfig;
import hiiragi283.ragium.setup.RagiumDataComponents;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006 "}, d2={"Lhiiragi283/ragium/common/item/HTTeleportKeyItem;", "Lhiiragi283/ragium/common/item/base/HTFluidItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "finishUsingItem", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "teleportPlayer", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "getUseDuration", "", "entity", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "isFoil", "ragium"})
public final class HTTeleportKeyItem
extends HTFluidItem {
    public HTTeleportKeyItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Item.Properties properties2 = properties.rarity(Rarity.RARE);
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"rarity(...)");
        super(properties2);
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        InteractionResult interactionResult;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        Level level2 = level;
        if (level2.isClientSide) {
            return InteractionResult.PASS;
        }
        BlockPos blockPos = context.getClickedPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
        BlockPos pos = blockPos;
        if (stack.has(RagiumDataComponents.TELEPORT_POS)) {
            interactionResult = InteractionResult.PASS;
        } else {
            ResourceKey resourceKey = level2.dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            BlockPos blockPos2 = pos.above();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"above(...)");
            stack.set(RagiumDataComponents.TELEPORT_POS, (Object)HTTeleportPos.box-impl(HTTeleportPos.constructor-impl((ResourceKey<Level>)resourceKey, blockPos2)));
            InteractionResult interactionResult2 = InteractionResult.sidedSuccess((boolean)false);
            Intrinsics.checkNotNull((Object)interactionResult2);
            interactionResult = interactionResult2;
        }
        return interactionResult;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (level.isClientSide) {
            return stack;
        }
        if (livingEntity instanceof ServerPlayer) {
            SoundEvent soundEvent;
            ServerPlayer player = (ServerPlayer)livingEntity;
            boolean bl = this.teleportPlayer(stack, player);
            if (bl) {
                SoundEvent soundEvent2 = SoundEvents.PLAYER_TELEPORT;
                soundEvent = soundEvent2;
                Intrinsics.checkNotNullExpressionValue((Object)soundEvent2, (String)"PLAYER_TELEPORT");
            } else if (!bl) {
                SoundEvent soundEvent3 = SoundEvents.OMINOUS_BOTTLE_DISPOSE;
                soundEvent = soundEvent3;
                Intrinsics.checkNotNullExpressionValue((Object)soundEvent3, (String)"OMINOUS_BOTTLE_DISPOSE");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            SoundEvent sound = soundEvent;
            level.playSound(null, ((ServerPlayer)livingEntity).getX(), ((ServerPlayer)livingEntity).getY(), ((ServerPlayer)livingEntity).getZ(), sound, SoundSource.PLAYERS);
        }
        ItemStack itemStack = super.finishUsingItem(stack, level, livingEntity);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    private final boolean teleportPlayer(ItemStack stack, ServerPlayer player) {
        HTTeleportPos hTTeleportPos = (HTTeleportPos)stack.get(RagiumDataComponents.TELEPORT_POS);
        Object object = hTTeleportPos != null ? hTTeleportPos.unbox-impl() : null;
        if (object == null) {
            return false;
        }
        GlobalPos globalPos = object;
        ResourceKey<Level> dim = HTTeleportPos.component1-impl(globalPos);
        BlockPos pos = HTTeleportPos.component2-impl(globalPos);
        ServerLevel serverLevel = player.server.getLevel(dim);
        if (serverLevel == null) {
            return false;
        }
        ServerLevel level = serverLevel;
        HTStackView hTStackView = HTFluidCapabilities.INSTANCE.getCapabilityView((IItemStackExtension)stack, 0);
        HTFluidTank hTFluidTank = hTStackView instanceof HTFluidTank ? (HTFluidTank)hTStackView : null;
        if (hTFluidTank == null) {
            return false;
        }
        HTFluidTank tank = hTFluidTank;
        int usage = player.blockPosition().distManhattan((Vec3i)pos) * RagiumConfig.COMMON.teleportKeyCost.getAsInt();
        ServerLevel serverLevel2 = player.serverLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"serverLevel(...)");
        int toDrain = HTItemHelper.getFixedUsage(serverLevel2, stack, usage);
        ImmutableFluidStack immutableFluidStack = (ImmutableFluidStack)tank.extract-dA061ig(toDrain, HTStorageAction.Companion.getSIMULATE-fhPPMAc(), HTStorageAccess.INTERNAL);
        Object object2 = immutableFluidStack != null ? immutableFluidStack.unbox-impl() : null;
        if ((object2 != null ? ImmutableFluidStack.amount-impl(object2) : 0) < toDrain) {
            player.displayClientMessage((Component)Component.translatable((String)("Required fuel: " + toDrain + " mb")).withStyle(ChatFormatting.RED), true);
            return false;
        }
        if (player.connection.isAcceptingMessages()) {
            tank.extract-dA061ig(toDrain, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), HTStorageAccess.INTERNAL);
            DimensionTransition transition = new DimensionTransition(level, pos.getBottomCenter(), player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.DO_NOTHING);
            player.changeDimension(transition);
            player.resetFallDistance();
            player.resetCurrentImpulseContext();
            CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
            return true;
        }
        return false;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
        return interactionResultHolder;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return super.isFoil(stack) || stack.has(RagiumDataComponents.TELEPORT_POS);
    }
}

