/*
 * Decompiled with CFR 0.152.
 */
package hiiragi283.ragium.common.util;

import com.google.common.primitives.Ints;
import hiiragi283.ragium.api.RagiumAPI;
import hiiragi283.ragium.api.storage.HTStorageAccess;
import hiiragi283.ragium.api.storage.HTStorageAction;
import hiiragi283.ragium.api.storage.experience.HTExperienceStorage;
import it.unimi.dsi.fastutil.longs.Long2LongArrayMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0003J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0003J.\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001eR\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00148\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0003\u00a8\u0006\u001f"}, d2={"Lhiiragi283/ragium/common/util/HTExperienceHelper;", "", "<init>", "()V", "getPlayerExp", "", "player", "Lnet/minecraft/world/entity/player/Player;", "setPlayerExp", "", "amount", "getExpForLevel", "", "level", "sum", "n", "a", "d", "getExpBarCapacity", "levelCache", "", "getLevelCache$annotations", "getLevelForExp", "exp", "findLevelForExp", "moveExp", "from", "Lhiiragi283/ragium/api/storage/experience/HTExperienceStorage;", "to", "access", "Lhiiragi283/ragium/api/storage/HTStorageAccess;", "ragium"})
public final class HTExperienceHelper {
    @NotNull
    public static final HTExperienceHelper INSTANCE = new HTExperienceHelper();
    @NotNull
    private static final Map<Long, Long> levelCache = (Map)new Long2LongArrayMap();

    private HTExperienceHelper() {
    }

    @JvmStatic
    public static final long getPlayerExp(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (long)HTExperienceHelper.getExpForLevel(player.experienceLevel) + (long)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    @JvmStatic
    public static final void setPlayerExp(@NotNull Player player, long amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        long fixedAmount = Math.max(0L, amount);
        player.totalExperience = Ints.saturatedCast((long)fixedAmount);
        player.experienceLevel = Ints.saturatedCast((long)HTExperienceHelper.getLevelForExp(fixedAmount));
        int expForLevel = HTExperienceHelper.getExpForLevel(player.experienceLevel);
        player.experienceProgress = (float)(fixedAmount - (long)expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    @JvmStatic
    public static final int getExpForLevel(int level) {
        return level == 0 ? 0 : (level <= 15 ? HTExperienceHelper.sum(level, 7, 2) : (level <= 30 ? 315 + HTExperienceHelper.sum(level - 15, 37, 5) : 1395 + HTExperienceHelper.sum(level - 30, 112, 9)));
    }

    @JvmStatic
    private static final int sum(int n, int a, int d) {
        return n * (2 * a + (n - 1) * d) / 2;
    }

    @JvmStatic
    public static final long getExpBarCapacity(long level) {
        return level >= 30L ? (long)112 + (level - (long)30) * (long)9 : (level >= 15L ? (long)37 + (level - (long)15) * (long)5 : (long)7 + level * (long)2);
    }

    @JvmStatic
    private static /* synthetic */ void getLevelCache$annotations() {
    }

    @JvmStatic
    public static final long getLevelForExp(long exp) {
        Long l = levelCache.computeIfAbsent(exp, arg_0 -> HTExperienceHelper.getLevelForExp$lambda$0((Function1)new Function1<Long, Long>((Object)INSTANCE){

            public final Long invoke(long p0) {
                return HTExperienceHelper.access$findLevelForExp(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"computeIfAbsent(...)");
        return ((Number)l).longValue();
    }

    @JvmStatic
    private static final long findLevelForExp(long exp) {
        long exp1 = exp;
        long level = 0L;
        while (true) {
            long nextLevel = HTExperienceHelper.getExpBarCapacity(level);
            if (exp1 < nextLevel) {
                return level;
            }
            long l = level;
            level = l + 1L;
            exp1 -= nextLevel;
        }
    }

    public final long moveExp(@Nullable HTExperienceStorage from, @Nullable HTExperienceStorage to, long amount, @NotNull HTStorageAccess access) {
        long leftover;
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        if (from == null || to == null || amount <= 0L) {
            return 0L;
        }
        long simulatedExtracted = from.extractExp-dA061ig(amount, HTStorageAction.Companion.getSIMULATE-fhPPMAc(), access);
        long simulatedInserted = to.insertExp-dA061ig(simulatedExtracted, HTStorageAction.Companion.getSIMULATE-fhPPMAc(), access);
        long extracted = from.extractExp-dA061ig(simulatedInserted, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), access);
        long remainder = to.insertExp-dA061ig(extracted, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), access);
        if (remainder > 0L && (leftover = from.insertExp-dA061ig(remainder, HTStorageAction.Companion.getEXECUTE-fhPPMAc(), access)) > 0L) {
            RagiumAPI.LOGGER.error("Experience storage " + from + " did not accept leftover amount from " + to + "! Voiding it.");
        }
        return remainder;
    }

    public static /* synthetic */ long moveExp$default(HTExperienceHelper hTExperienceHelper, HTExperienceStorage hTExperienceStorage, HTExperienceStorage hTExperienceStorage2, long l, HTStorageAccess hTStorageAccess, int n, Object object) {
        if ((n & 4) != 0) {
            HTExperienceStorage hTExperienceStorage3 = hTExperienceStorage;
            long l2 = l = hTExperienceStorage3 != null ? ((Number)hTExperienceStorage3.getAmount()).longValue() : 0L;
        }
        if ((n & 8) != 0) {
            hTStorageAccess = HTStorageAccess.INTERNAL;
        }
        return hTExperienceHelper.moveExp(hTExperienceStorage, hTExperienceStorage2, l, hTStorageAccess);
    }

    private static final Long getLevelForExp$lambda$0(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ long access$findLevelForExp(long exp) {
        return HTExperienceHelper.findLevelForExp(exp);
    }
}

