/*
 * Decompiled with CFR 0.152.
 */
package me.GUSTRUY.TreeChop;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.GUSTRUY.TreeChop.G031;
import me.GUSTRUY.TreeChop.GetTree;
import me.GUSTRUY.TreeChop.intern.SimpleConfig;
import me.GUSTRUY.TreeChop.intern.Utils;

public class Conf
extends SimpleConfig {
    protected int configVersion;
    protected boolean treeChopEnabled;
    protected boolean permission;
    protected String[] permissions;
    protected boolean shiftDisableChop;
    protected boolean generateEffects;
    protected boolean useMultipleAxes;
    protected boolean chopAllLogs;
    protected byte percentageChop;
    protected boolean insufAxeDurability;
    protected boolean axeBreakStopFall;
    protected int saveToolDurability;
    protected int breakLogsMode;
    protected int breakLogsPerTick;
    protected int particlesQuantity;
    protected float soundVolume;
    protected float soundPitch;
    protected int treeHarvestMode;
    protected boolean othersView_damagedLogs;
    protected int damagedLogsRadius;

    public Conf(G031 plugin) {
        super(plugin, Conf.cloneValues(VName.values(), 1), "Config");
        this.load();
    }

    @Override
    protected void onSave() {
        this.set(VName.treeChopEnabled, (Object)this.treeChopEnabled);
        this.set(VName.permission, (Object)this.permission);
        this.set(VName.permissions, Conf.toList(this.permissions));
        this.set(VName.shiftDisableChop, (Object)this.shiftDisableChop);
        this.set(VName.generateEffects, (Object)this.generateEffects);
        this.set(VName.useMultipleAxes, (Object)this.useMultipleAxes);
        this.set(VName.chopAllLogs, (Object)this.chopAllLogs);
        this.set(VName.percentageChop, (Object)this.percentageChop);
        this.set(VName.insufAxeDurability, (Object)this.insufAxeDurability);
        this.set(VName.axeBreakStopFall, (Object)this.axeBreakStopFall);
        this.set(VName.saveToolDurability, (Object)this.saveToolDurability);
        this.set(VName.breakLogsMode, (Object)this.breakLogsMode);
        this.set(VName.breakLogsPerTick, (Object)this.breakLogsPerTick);
        this.set(VName.particlesQuantity, (Object)this.particlesQuantity);
        this.set(VName.soundVolume, (Object)Float.valueOf(this.soundVolume));
        this.set(VName.soundPitch, (Object)Float.valueOf(this.soundPitch));
        this.set(VName.treeHarvestMode, (Object)this.treeHarvestMode);
        this.set(VName.othersView_damagedLogs, (Object)this.othersView_damagedLogs);
        this.set(VName.damagedLogsRadius, (Object)this.damagedLogsRadius);
        this.setComments((SimpleConfig.SimpleConfigEnum)VName.configVersion, "Indicates the version of the configuration file. DO NOT TOUCH the parameter (risk of file reset).");
        this.setComments((SimpleConfig.SimpleConfigEnum)VName.treeChopEnabled, "Indicates whether the plugin is active (Listen to the BlockBreakEvent).");
        this.setComments("WhoCanChop", "Decide who can use treechop.", "If permissions are true, the players must have one of the permissions in the permissions list.", "Discaimer: the bigger the list of permissions, the more checks per player will be made!");
        this.setComments("OnChop", "During tree cutting.", "shiftDisableChop = disables while sneaking, the cutting action.", "generateEffects = it makes the cutting action of the tree visible and audible.", "useMultipleAxes = default set to false, to prevent damaging the wrong tool.", "chopAllLogs = if it is true, it will break all the tree logs.", "percentageChop = nessesary cuts as a percentage of total logs. (cannot be a negative number)", "insufficientAxeDurability = notify that the tool has a lower durability than the total logs.");
        this.setComments("OnFall", "During the fall of the tree.", "axeBreakStopFall = during the fall of the tree if the tool breaks, it interrupts the breaking of other logs.", "saveToolDurability = Choose the amount of the durability you want to save of the tool.", "breakLogsMode = (0 breaks the blocks without following an order) (1 breaks the blocks in an upward manner according to the Y-axis)", " (2 breaks the blocks in a downward manner according to the Y-axis).", "breakLogsPerTick = Value referring to how many logs to break per tick. If set to \u20180\u2019 it will be instantaneous but may impact performance.");
        this.setComments("Effects", "Particles and sounds generated in \u201cOnChop\u201d and \u201dOnFall\u201d, \u201cgenerateEffects\u201d must be enabled.", " Necessary to make the breaking of the block visible to all.", "particles.quantity = (defoult: 40)", "sound.volume = (defoult: 1.0) Distance of sound.", "sound.pitch = (defoult: 2.0)");
        this.setComments("Other", "treeHarvestMode = (0 only logs of the initial type), (1 only LOG and WOOD), (2 only LOG, WOOD, and STRIPPED), (3 any type of wood).", "othersView_damagedLogs = Whether other players can see the effect of the damaged block.", "damagedLogsRadius = Within what radius other players can see the effect.");
    }

    @Override
    protected void onLoad() {
        int currentCofgVer = this.getConfigV(VName.configVersion);
        switch (currentCofgVer) {
            case 1: {
                this.load1();
            }
            case 2: 
            case 3: {
                this.load2();
                this.deleteFile();
                this.loadFile();
                break;
            }
            case 4: 
            case 5: {
                this.load3();
                break;
            }
            default: {
                this.log(Utils.Level.WARNING, "The parameter 'ConfigVersion' = '" + currentCofgVer + "' does not correspond to an existing version. Changing this parameter manually may lead to a reset of the config file! ");
            }
            case 0: {
                this.load3();
                this.deleteFile();
                this.loadFile();
                this.save(true);
            }
        }
        this.setConfigV(VName.configVersion);
    }

    private void load3() {
        this.load2();
        this.generateEffects = this.config.getBoolean(VName.generateEffects.key);
        this.particlesQuantity = this.config.getInt(VName.particlesQuantity.key);
        this.soundVolume = this.getFloat(VName.soundVolume.key);
        this.soundPitch = this.getFloat(VName.soundPitch.key);
        int tempTHMode = this.treeHarvestMode;
        this.treeHarvestMode = this.config.getInt(VName.treeHarvestMode.key);
        if (this.treeHarvestMode != tempTHMode) {
            GetTree.initM(this.treeHarvestMode, 2048);
        }
        this.othersView_damagedLogs = this.config.getBoolean(VName.othersView_damagedLogs.key);
        this.damagedLogsRadius = this.config.getInt(VName.damagedLogsRadius.key);
    }

    private void load2() {
        this.configVersion = this.config.getInt(VName.configVersion.key);
        this.treeChopEnabled = this.config.getBoolean(VName.treeChopEnabled.key);
        this.permission = this.config.getBoolean(VName.permission.key);
        this.permissions = Conf.toArrey(this.config.getStringList(VName.permissions.key));
        this.shiftDisableChop = this.config.getBoolean(VName.shiftDisableChop.key);
        if (this.config.contains("OnChop.particles")) {
            this.generateEffects = this.config.getBoolean("OnChop.particles");
        }
        this.useMultipleAxes = this.config.getBoolean(VName.useMultipleAxes.key);
        this.chopAllLogs = this.config.getBoolean(VName.chopAllLogs.key);
        this.percentageChop = (byte)this.config.getInt(VName.percentageChop.key);
        this.insufAxeDurability = this.config.getBoolean(VName.insufAxeDurability.key);
        this.axeBreakStopFall = this.config.getBoolean(VName.axeBreakStopFall.key);
        this.saveToolDurability = this.config.getInt(VName.saveToolDurability.key);
        this.breakLogsMode = this.config.getInt(VName.breakLogsMode.key);
        this.breakLogsPerTick = this.config.getInt(VName.breakLogsPerTick.key);
    }

    private void load1() {
        this.configVersion = this.config.getInt(VName.configVersion.key);
        this.treeChopEnabled = this.config.getBoolean(VName.treeChopEnabled.key);
        this.permission = this.config.getBoolean(VName.permission.key);
        this.permissions = Conf.toArrey(this.config.getStringList(VName.permissions.key));
        this.shiftDisableChop = this.config.getBoolean(VName.shiftDisableChop.key);
        if (this.config.contains("OnChop.particles")) {
            this.generateEffects = this.config.getBoolean("OnChop.particles");
        }
        this.useMultipleAxes = this.config.getBoolean(VName.useMultipleAxes.key);
        this.percentageChop = (byte)this.config.getInt(VName.percentageChop.key);
        this.insufAxeDurability = this.config.getBoolean(VName.insufAxeDurability.key);
        if (this.config.contains("Onfall.axeBreakStopFall")) {
            this.axeBreakStopFall = this.config.getBoolean("Onfall.axeBreakStopFall");
        }
        if (this.config.contains("Onfall.breakLogsMode")) {
            this.breakLogsMode = this.config.getInt("Onfall.breakLogsMode");
        }
        this.config.set("Onfall", null);
    }

    @Override
    protected boolean onCorrect(boolean correct) {
        if (this.percentageChop < 0) {
            this.percentageChop = (byte)80;
            this.log(Utils.Level.WARNING, "The parameter 'OnChop.percentageChop' only accepts numbers >= 0! Default setting setted to " + this.percentageChop + "%");
            correct = false;
        }
        if (this.breakLogsMode != 0 && this.breakLogsMode != 1 && this.breakLogsMode != 2) {
            this.breakLogsMode = 1;
            this.log(Utils.Level.WARNING, "The parameter 'Onfall.breakLogsMode' only accepts numbers (0,1,2)! Default setting setted to " + this.breakLogsMode);
            correct = false;
        }
        if (this.breakLogsPerTick < 0) {
            this.breakLogsPerTick = 2;
            this.log(Utils.Level.WARNING, "The parameter 'Onfall.breakLogsPerTick' only accepts numbers > 0! Default setting setted to " + this.breakLogsPerTick);
            correct = false;
        }
        if (this.treeHarvestMode < 0 || 4 <= this.treeHarvestMode) {
            this.breakLogsPerTick = 1;
            this.log(Utils.Level.WARNING, "The parameter 'Other.treeHarvestMode' only accepts numbers > 0! Default setting setted to " + this.breakLogsPerTick);
            correct = false;
        }
        if (!correct) {
            this.save(true);
        }
        return correct;
    }

    public Object getValue(String key) {
        return this.getValue(VName.getFromString(key));
    }

    public Set<String> getEnumNamesSet() {
        return VName.valuesSet;
    }

    public List<String> setValue(String key, Object value) {
        return this.setValue(VName.getFromString(key), value);
    }

    private void log1(String m) {
        G031.getInstance().log(Utils.Level.INFO, "Config test: " + m);
    }

    private void log(Utils.Level l, String m) {
        G031.getInstance().log(l, "Config test: " + m);
    }

    static /* synthetic */ List access$0(String[] stringArray) {
        return Conf.stringList(stringArray);
    }

    public static enum VName implements SimpleConfig.SimpleConfigEnum
    {
        configVersion("ConfigVersion", 5),
        treeChopEnabled("TreeChopEnabled", true),
        permission("WhoCanChop.permission", true),
        permissions("WhoCanChop.permissions", Conf.access$0(new String[]{"g031.treechop.chop"})),
        shiftDisableChop("OnChop.shiftDisableChop", true),
        generateEffects("OnChop.generateEffects", true),
        useMultipleAxes("OnChop.useMultipleAxes", false),
        chopAllLogs("OnChop.chopAllLogs", false),
        percentageChop("OnChop.percentageChop", 80),
        insufAxeDurability("OnChop.insufficientAxeDurability", true),
        axeBreakStopFall("OnFall.axeBreakStopFall", true),
        saveToolDurability("OnFall.saveToolDurability", 0),
        breakLogsMode("OnFall.breakLogsMode", 1),
        breakLogsPerTick("OnFall.breakLogsPerTick", 2),
        replantSapling("Effects.replantSapling", false),
        particlesQuantity("Effects.particlesQuantity", 40),
        soundVolume("Effects.soundVolume", 1.0),
        soundPitch("Effects.soundPitch", 2.0),
        treeHarvestMode("Other.treeHarvestMode", 1),
        othersView_damagedLogs("Other.othersView_damagedLogs", true),
        damagedLogsRadius("Other.damagedLogsRadius", 32);

        final String key;
        final Object value;
        private static final Set<String> valuesSet;

        static {
            valuesSet = new HashSet<String>();
            int n = 0;
            VName[] vNameArray = VName.values();
            int n2 = vNameArray.length;
            int n3 = 0;
            while (n3 < n2) {
                VName v = vNameArray[n3];
                if (n++ >= 1) {
                    valuesSet.add(v.toString());
                }
                ++n3;
            }
        }

        private VName(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public static SimpleConfig.SimpleConfigEnum getFromString(String name) {
            if (valuesSet.contains(name)) {
                return VName.valueOf(name);
            }
            return null;
        }
    }
}

