/*
 * Decompiled with CFR 0.152.
 */
package me.GUSTRUY.TreeChop;

import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import me.GUSTRUY.TreeChop.G031;
import me.GUSTRUY.TreeChop.Tree;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class GetTree {
    private static int maxB;
    private static int getLogsMode;
    private static EnumMap<Material, EnumSet<Material>> materials;
    static EnumSet<Material> leaves;
    private static final String[] SUFFIXES;
    private static final BlockFace[] faces;

    static {
        getLogsMode = 3;
        SUFFIXES = new String[]{"_LOG", "_WOOD", "_STEM", "_HYPHAE"};
        faces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};
    }

    public static void initM(int getTreeLogsMode, int maxBlocks) {
        maxB = maxBlocks;
        if (getLogsMode == getTreeLogsMode) {
            return;
        }
        getLogsMode = getTreeLogsMode;
        materials = new EnumMap(Material.class);
        block5: for (Material mat : Tag.LOGS.getValues()) {
            if (materials.containsKey(mat)) continue;
            switch (getLogsMode) {
                case 1: {
                    String type = GetTree.getWoodType(mat);
                    HashSet<Object> tSet = new HashSet<Material>();
                    GetTree.tryAdd(tSet, type + "_LOG", type + "_STEM");
                    GetTree.tryAdd(tSet, type + "_WOOD", type + "_HYPHAE");
                    if (tSet.isEmpty()) continue block5;
                    EnumSet<Object> set = EnumSet.copyOf(tSet);
                    for (Material material : set) {
                        materials.put(material, set);
                    }
                    tSet = new HashSet();
                    GetTree.tryAdd(tSet, "STRIPPED_" + type + "_LOG", "STRIPPED_" + type + "_STEM");
                    GetTree.tryAdd(tSet, "STRIPPED_" + type + "_WOOD", "STRIPPED_" + type + "_HYPHAE");
                    if (tSet.isEmpty()) continue block5;
                    set = EnumSet.copyOf(tSet);
                    for (Material material : set) {
                        materials.put(material, set);
                    }
                    continue block5;
                }
                case 2: {
                    String type = GetTree.getWoodType(mat);
                    HashSet<Object> tSet = new HashSet();
                    GetTree.tryAdd(tSet, type + "_LOG", type + "_STEM");
                    GetTree.tryAdd(tSet, type + "_WOOD", type + "_HYPHAE");
                    GetTree.tryAdd(tSet, "STRIPPED_" + type + "_LOG", "STRIPPED_" + type + "_STEM");
                    GetTree.tryAdd(tSet, "STRIPPED_" + type + "_WOOD", "STRIPPED_" + type + "_HYPHAE");
                    if (tSet.isEmpty()) continue block5;
                    EnumSet<Object> set = EnumSet.copyOf(tSet);
                    for (Material material : set) {
                        materials.put(material, set);
                    }
                    continue block5;
                }
                case 3: {
                    HashSet<Object> tSet = Tag.LOGS.getValues();
                    if (tSet.isEmpty()) continue block5;
                    EnumSet<Object> set = EnumSet.copyOf(tSet);
                    for (Material material : tSet) {
                        materials.put(material, set);
                    }
                    continue block5;
                }
                default: {
                    EnumSet<Object> set = EnumSet.of(mat);
                    materials.put(mat, set);
                }
            }
        }
        GetTree.leaves();
    }

    private static String getWoodType(Material material) {
        String name = material.name();
        if (name.startsWith("STRIPPED_")) {
            name = name.substring("STRIPPED_".length());
        }
        String[] stringArray = SUFFIXES;
        int n = SUFFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String suf = stringArray[n2];
            if (name.endsWith(suf)) {
                return name.substring(0, name.length() - suf.length());
            }
            ++n2;
        }
        return name;
    }

    private static boolean tryAdd(Set<Material> set, String matName, String matName1) {
        Material m = null;
        m = Material.getMaterial((String)matName);
        if (m == null && (m = Material.getMaterial((String)matName1)) == null) {
            return false;
        }
        set.add(m);
        return true;
    }

    private static void leaves() {
        Set tLeaves = Tag.LEAVES.getValues();
        if (!tLeaves.isEmpty()) {
            leaves = EnumSet.copyOf(tLeaves);
            leaves.add(Material.NETHER_WART_BLOCK);
            leaves.add(Material.WARPED_WART_BLOCK);
        }
    }

    private static String zgetWoodType(Material material) {
        int i;
        String name = material.name();
        if (name.startsWith("STRIPPED_")) {
            name = name.substring(9);
        }
        if ((i = name.indexOf("_LOG")) == -1) {
            i = name.indexOf("_WOOD");
        }
        return i == -1 ? name : name.substring(0, i);
    }

    public static Tree getTree(Block startBlock) {
        EnumSet<Material> sBlock = materials.get(startBlock.getType());
        HashSet<Block> root = new HashSet<Block>();
        HashSet<Block> chop = new HashSet<Block>();
        HashSet<Block> logs = new HashSet<Block>();
        ArrayDeque<Block> stack = new ArrayDeque<Block>(64);
        stack.push(startBlock);
        logs.add(startBlock);
        chop.add(startBlock);
        while (!stack.isEmpty()) {
            Block current = (Block)stack.pop();
            BlockFace[] blockFaceArray = faces;
            int n = faces.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                Block relative = current.getRelative(face);
                if (!chop.contains(relative) && sBlock.contains(relative.getType())) {
                    chop.add(relative);
                    stack.push(relative);
                }
                ++n2;
            }
        }
        Block startUp = startBlock.getRelative(BlockFace.UP);
        stack.push(startUp);
        if (sBlock.contains(startUp.getType())) {
            logs.add(startUp);
        }
        while (!stack.isEmpty() && logs.size() < maxB) {
            Block current = (Block)stack.pop();
            Block relative = current.getRelative(BlockFace.UP);
            if (sBlock.contains(relative.getType())) {
                logs.add(relative);
                stack.offer(relative);
            } else if (sBlock.contains(current.getType())) {
                stack.offer(relative);
            }
            BlockFace[] blockFaceArray = faces;
            int n = faces.length;
            int n3 = 0;
            while (n3 < n) {
                BlockFace face = blockFaceArray[n3];
                relative = current.getRelative(face);
                if (!logs.contains(relative) && sBlock.contains(relative.getType())) {
                    logs.add(relative);
                    stack.offerFirst(relative);
                    relative = relative.getRelative(BlockFace.UP);
                    stack.offer(relative);
                    if (sBlock.contains(relative.getType())) {
                        logs.add(relative);
                    }
                }
                ++n3;
            }
        }
        Block startDown = startBlock.getRelative(BlockFace.DOWN);
        stack.push(startDown);
        if (sBlock.contains(startDown.getType())) {
            root.add(startDown);
        }
        while (!stack.isEmpty() && root.size() < maxB) {
            Block current = (Block)stack.pop();
            Block relative = current.getRelative(BlockFace.DOWN);
            if (sBlock.contains(relative.getType())) {
                root.add(relative);
                stack.offer(relative);
            } else if (sBlock.contains(current.getType())) {
                stack.offer(relative);
            }
            BlockFace[] blockFaceArray = faces;
            int n = faces.length;
            int n4 = 0;
            while (n4 < n) {
                BlockFace face = blockFaceArray[n4];
                relative = current.getRelative(face);
                if (!root.contains(relative) && sBlock.contains(relative.getType())) {
                    root.add(relative);
                    stack.offerFirst(relative);
                    relative = relative.getRelative(BlockFace.DOWN);
                    stack.offer(relative);
                    if (sBlock.contains(relative.getType())) {
                        root.add(relative);
                    }
                }
                ++n4;
            }
        }
        logs.addAll(chop);
        return new Tree(root, chop, logs);
    }

    public static Set<Block> getChop(Block startBlock) {
        EnumSet<Material> sBlock = materials.get(startBlock.getType());
        HashSet<Block> chop = new HashSet<Block>();
        ArrayDeque<Block> stack = new ArrayDeque<Block>();
        stack.push(startBlock);
        chop.add(startBlock);
        while (!stack.isEmpty()) {
            Block current = (Block)stack.pop();
            BlockFace[] blockFaceArray = faces;
            int n = faces.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                Block relative = current.getRelative(face);
                if (!chop.contains(relative) && sBlock.contains(relative.getType())) {
                    chop.add(relative);
                    stack.push(relative);
                }
                ++n2;
            }
        }
        return chop;
    }

    public static Set<Block> getRoot(Block startBlock) {
        EnumSet<Material> sBlock = materials.get(startBlock.getType());
        HashSet<Block> root = new HashSet<Block>();
        ArrayDeque<Block> stack = new ArrayDeque<Block>();
        Block startDown = startBlock.getRelative(BlockFace.DOWN);
        stack.push(startDown);
        if (sBlock.contains(startDown.getType())) {
            root.add(startDown);
        }
        while (!stack.isEmpty()) {
            Block current = (Block)stack.pop();
            Block relative = current.getRelative(BlockFace.DOWN);
            if (sBlock.contains(relative.getType())) {
                root.add(relative);
                stack.offerFirst(relative);
            } else if (sBlock.contains(current.getType())) {
                stack.offerFirst(relative);
            }
            BlockFace[] blockFaceArray = faces;
            int n = faces.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                relative = current.getRelative(face);
                if (!root.contains(relative) && sBlock.contains(relative.getType())) {
                    root.add(relative);
                    stack.offer(relative);
                    relative = relative.getRelative(BlockFace.DOWN);
                    stack.offer(relative);
                    if (sBlock.contains(relative.getType())) {
                        root.add(relative);
                    }
                }
                ++n2;
            }
        }
        return root;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTree(Block block) {
        block13: {
            sBlock = GetTree.materials.get(block.getType());
            logs = new HashSet<Block>();
            stack = new ArrayDeque<Block>();
            startUp = block.getRelative(BlockFace.UP);
            stack.push(startUp);
            if (!sBlock.contains(startUp.getType())) break block13;
            logs.add(startUp);
            ** GOTO lbl52
        }
        if (!GetTree.leaves.contains(startUp.getType())) ** GOTO lbl52
        return startUp.getBlockData().getAsString().contains("persistent=true") == false;
lbl-1000:
        // 1 sources

        {
            current = (Block)stack.pop();
            relative = current.getRelative(BlockFace.UP);
            if (sBlock.contains(relative.getType())) {
                logs.add(relative);
                stack.offerFirst(relative);
            } else {
                if (GetTree.leaves.contains(relative.getType())) {
                    return relative.getBlockData().getAsString().contains("persistent=true") == false;
                }
                if (sBlock.contains(current.getType())) {
                    stack.offerFirst(relative);
                }
            }
            var10_10 = GetTree.faces;
            var9_9 = GetTree.faces.length;
            var8_8 = 0;
            while (var8_8 < var9_9) {
                face = var10_10[var8_8];
                relative = current.getRelative(face);
                if (!logs.contains(relative)) {
                    logs.add(relative);
                    if (sBlock.contains(relative.getType())) {
                        stack.offer(relative);
                        relative = relative.getRelative(BlockFace.UP);
                        stack.offer(relative);
                        if (sBlock.contains(relative.getType())) {
                            logs.add(relative);
                        } else if (GetTree.leaves.contains(relative.getType())) {
                            return relative.getBlockData().getAsString().contains("persistent=true") == false;
                        }
                    } else if (GetTree.leaves.contains(relative.getType())) {
                        return relative.getBlockData().getAsString().contains("persistent=true") == false;
                    }
                }
                ++var8_8;
            }
lbl52:
            // 3 sources

            ** while (!stack.isEmpty())
        }
lbl53:
        // 1 sources

        return false;
    }

    public static boolean isTreeDebug(Block block) {
        EnumSet<Material> sBlock = materials.get(block.getType());
        GetTree.log(String.valueOf(sBlock));
        HashSet<Block> logs = new HashSet<Block>();
        ArrayDeque<Block> stack = new ArrayDeque<Block>();
        Block startUp = block.getRelative(BlockFace.UP);
        stack.push(startUp);
        if (leaves.contains(startUp.getType())) {
            if (startUp.getBlockData().getAsString().contains("persistent=true")) {
                return false;
            }
            startUp.setType(Material.GREEN_WOOL);
            return true;
        }
        if (sBlock.contains(startUp.getType())) {
            logs.add(startUp);
            startUp.setType(Material.BROWN_WOOL);
        }
        while (!stack.isEmpty()) {
            Block current = (Block)stack.pop();
            Block relative = current.getRelative(BlockFace.UP);
            if (sBlock.contains(relative.getType())) {
                logs.add(relative);
                stack.offerFirst(relative);
                relative.setType(Material.RED_WOOL);
            } else {
                if (leaves.contains(relative.getType())) {
                    if (relative.getBlockData().getAsString().contains("persistent=true")) {
                        return false;
                    }
                    relative.setType(Material.LIME_WOOL);
                    return true;
                }
                if (current.getType() == Material.RED_WOOL) {
                    stack.offerFirst(relative);
                    GetTree.log("titao");
                } else {
                    relative.setType(Material.BLACK_STAINED_GLASS);
                    GetTree.log("titao " + String.valueOf(current.getType()));
                }
            }
            BlockFace[] blockFaceArray = faces;
            int n = faces.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                relative = current.getRelative(face);
                if (!logs.contains(relative)) {
                    if (leaves.contains(relative.getType())) {
                        if (relative.getBlockData().getAsString().contains("persistent=true")) {
                            return false;
                        }
                        relative.setType(Material.GREEN_WOOL);
                        return true;
                    }
                    if (sBlock.contains(relative.getType())) {
                        logs.add(relative);
                        stack.offer(relative);
                        relative.setType(Material.BROWN_WOOL);
                        relative = relative.getRelative(BlockFace.UP);
                        stack.offer(relative);
                        if (sBlock.contains(relative.getType())) {
                            logs.add(relative);
                            relative.setType(Material.ORANGE_WOOL);
                        } else if (leaves.contains(relative.getType())) {
                            if (relative.getBlockData().getAsString().contains("persistent=true")) {
                                return false;
                            }
                            relative.setType(Material.LIME_WOOL);
                            return true;
                        }
                    } else {
                        relative.setType(Material.GRAY_STAINED_GLASS);
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isTreeOld(Block block, Material m) {
        boolean tronco;
        while ((block = block.getRelative(BlockFace.UP)).getType() == m) {
        }
        if (Tag.LEAVES.isTagged((Keyed)block.getType()) && block.getBlockData().getAsString().contains("persistent=false")) {
            return true;
        }
        block1: do {
            tronco = false;
            while (block.getType() == m) {
                block = block.getRelative(BlockFace.UP);
            }
            if (Tag.LEAVES.isTagged((Keyed)block.getType()) && block.getBlockData().getAsString().contains("persistent=false")) {
                return true;
            }
            int i = 0;
            while (i < faces.length) {
                Block blockt = block.getRelative(faces[i]);
                if (Tag.LEAVES.isTagged((Keyed)blockt.getType()) && blockt.getBlockData().getAsString().contains("persistent=false")) {
                    return true;
                }
                if (blockt.getType() == m) {
                    tronco = true;
                    block = blockt.getRelative(BlockFace.UP);
                    continue block1;
                }
                ++i;
            }
        } while (tronco);
        return false;
    }

    private static void log(String m) {
        G031.getInstance().log("treeChopEvent: " + m);
    }
}

