/*
 * Decompiled with CFR 0.152.
 */
package me.GUSTRUY.TreeChop;

import java.util.Set;
import javax.annotation.Nonnull;
import me.GUSTRUY.TreeChop.Conf;
import me.GUSTRUY.TreeChop.G031;
import me.GUSTRUY.TreeChop.intern.Sphere;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class Tree {
    private static Conf conf;
    protected Set<Block> root;
    protected Set<Block> chop;
    protected Set<Block> logs;
    protected int total;
    protected int made;
    protected ItemStack tool;
    protected Sphere dRadius;

    public static void confUpdated() {
        conf = G031.conf;
    }

    public Tree(Set<Block> root2, Set<Block> chop, Set<Block> logs) {
        this.root = root2;
        this.chop = chop;
        this.logs = logs;
    }

    private Tree(ItemStack tool) {
        this.made = 0;
        this.total = 0;
        this.tool = tool;
    }

    public void inizialize(ItemStack tool, boolean allLogs) {
        this.made = 0;
        this.total = 0;
        this.tool = tool;
        this.setChopAll(allLogs);
    }

    public void setLogs(Set<Block> root, Set<Block> chop, Set<Block> logs) {
        this.root = root;
        this.chop = chop;
        this.logs = logs;
    }

    public void setChopAll(boolean allLogs) {
        this.logs.addAll(this.chop);
        if (allLogs) {
            this.logs.addAll(this.root);
        } else {
            this.logs.removeAll(this.root);
        }
        this.total = (int)((double)this.logs.size() * ((double)G031.conf.percentageChop / 100.0));
    }

    public void setLogs(Set<Block> root, Set<Block> chop, boolean allLogs) {
        this.root = root;
        this.chop = chop;
        this.setChopAll(allLogs);
    }

    public void setDR(Sphere dRadius) {
        this.dRadius = dRadius;
    }

    public void setDR(Location loc, double radius) {
        this.dRadius = new Sphere(loc, radius);
    }

    public boolean getDR(Location loc) {
        return this.dRadius.contains(loc);
    }

    boolean chop0(Player p) {
        ++this.made;
        if (Tree.conf.insufAxeDurability && this.itemDurability(p) < this.logs.size() + 12) {
            p.sendMessage("\u00a77TreeChop>> \u00a77Your axe is going to break!");
        }
        if (this.total <= this.made) {
            this.blockDamage(p, 0.0f);
            return true;
        }
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a72" + this.made + "/" + this.total + " broken"));
        this.blockDamage(p);
        return false;
    }

    boolean chop(Player p) {
        ++this.made;
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a72" + this.made + "/" + this.total + " broken"));
        if (this.total <= this.made) {
            this.blockDamage(p, 0.0f);
            return true;
        }
        this.blockDamage(p);
        return false;
    }

    private void blockDamage(Player p) {
        this.blockDamage(p, (float)this.made / (float)this.total);
    }

    private void blockDamage(Player p, float damage) {
        int sourceId = p.getEntityId() * 50;
        if (this.dRadius == null) {
            for (Block b : this.chop) {
                p.sendBlockDamage(b.getLocation(), damage, sourceId++);
            }
        } else {
            for (Player ps : Bukkit.getOnlinePlayers()) {
                int tId = sourceId;
                for (Block b : this.chop) {
                    ++tId;
                    if (!this.dRadius.contains(p.getLocation())) continue;
                    ps.sendBlockDamage(b.getLocation(), damage, tId);
                }
            }
        }
    }

    private void zblockDamage(Player p, @Nonnull Tree a) {
        float damage = (float)a.made / (float)a.total;
        int viewDistance = 10;
        int sourceId = 10;
        block0: for (Player viewer : p.getWorld().getPlayers()) {
            for (Block b : a.root) {
                Location loc = b.getLocation();
                if (!(viewer.getLocation().distance(loc) <= (double)viewDistance)) continue block0;
                p.sendBlockDamage(loc, damage, sourceId++);
            }
        }
    }

    private int itemDurability(Player p) {
        ItemStack item = p.getInventory().getItemInMainHand();
        return item.getType().getMaxDurability() - ((Damageable)item.getItemMeta()).getDamage();
    }
}

