/*
 * Decompiled with CFR 0.152.
 */
package me.GUSTRUY.TreeChop;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.GUSTRUY.TreeChop.Conf;
import me.GUSTRUY.TreeChop.G031;
import me.GUSTRUY.TreeChop.GetTree;
import me.GUSTRUY.TreeChop.Tree;
import me.GUSTRUY.TreeChop.intern.Utils;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Trees {
    private static G031 plugin;
    private static Conf conf;
    private HashMap<UUID, Tree> trees;
    private Set<UUID> mod;
    private static Set<UUID> debugmode;

    public Trees() {
        plugin = G031.getInstance();
        this.trees = new HashMap();
        this.mod = new HashSet<UUID>();
        Trees.confUpdated();
    }

    public static void confUpdated() {
        conf = G031.conf;
        GetTree.initM(Trees.conf.treeHarvestMode, 2048);
        Tree.confUpdated();
        debugmode = new HashSet<UUID>();
    }

    public Set<UUID> getMod() {
        return this.mod;
    }

    public Tree get(UUID uuid) {
        return this.trees.get(uuid);
    }

    protected static boolean debugMode(Player p) {
        if (!debugmode.contains(p.getUniqueId())) {
            debugmode.add(p.getUniqueId());
            return true;
        }
        debugmode.remove(p.getUniqueId());
        return false;
    }

    protected static boolean getDebugMode(Player p) {
        return debugmode.contains(p.getUniqueId());
    }

    public Tree add(UUID uuid, Block b, ItemStack tool) {
        Tree t = GetTree.getTree(b);
        t.inizialize(tool, Trees.conf.chopAllLogs);
        if (Trees.conf.othersView_damagedLogs) {
            t.setDR(b.getLocation(), Trees.conf.damagedLogsRadius);
        }
        this.trees.put(uuid, t);
        return t;
    }

    public void set(Tree t, Block b) {
        t.setLogs(GetTree.getRoot(b), GetTree.getChop(b), Trees.conf.chopAllLogs);
    }

    public void remove(UUID uuid) {
        this.mod.remove(uuid);
        this.trees.remove(uuid);
    }

    public boolean chop(Player p, Block b, Material mat, ItemStack tool) {
        UUID uuid = p.getUniqueId();
        Tree a = this.trees.get(uuid);
        if (a != null) {
            if (!Trees.conf.useMultipleAxes && !a.tool.equals((Object)tool)) {
                a.made = 0;
                a.tool = tool;
            }
            if (a.chop.contains(b)) {
                if (a.chop(p)) {
                    this.falls(a, p);
                    return true;
                }
                return false;
            }
            if (a.logs.contains(b) || a.root.contains(b)) {
                this.set(a, b);
                if (a.chop(p)) {
                    this.falls(a, p);
                    return true;
                }
                return false;
            }
        }
        if (this.isTree(b, uuid)) {
            a = this.add(uuid, b, tool);
            if (a.chop0(p)) {
                this.falls(a, p);
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isTree(Block b, UUID puuid) {
        if (debugmode.contains(puuid)) {
            return GetTree.isTreeDebug(b);
        }
        return GetTree.isTree(b);
    }

    private Tree getTree(Block b) {
        return GetTree.getTree(b);
    }

    private Set<Block> getChop(Block b) {
        return GetTree.getChop(b);
    }

    private Set<Block> getRoot(Block b) {
        return GetTree.getRoot(b);
    }

    public void falls(Tree a, Player p) {
        UUID uuid = p.getUniqueId();
        this.mod.add(uuid);
        this.falls4(a, p, uuid);
    }

    private void falls0(Tree a, Player p) {
        for (Block b : a.logs) {
            p.breakBlock(b);
        }
    }

    private void falls4(Tree a, Player p, UUID uuid) {
        Block[] logs = this.breakLogsMode(a.logs);
        Sound sound = logs[0].getBlockData().getSoundGroup().getBreakSound();
        if (Trees.conf.axeBreakStopFall) {
            if (Trees.conf.breakLogsPerTick != 0) {
                this.breakBlocksGradually2(logs, p, uuid, Trees.conf.breakLogsPerTick, 1);
                return;
            }
            ItemStack item = p.getInventory().getItemInMainHand();
            int c = 0;
            short maxD = item.getType().getMaxDurability();
            int dd = maxD - ((Damageable)item.getItemMeta()).getDamage() - 1 - Trees.conf.saveToolDurability;
            Block[] blockArray = logs;
            int n = logs.length;
            int n2 = 0;
            while (n2 < n) {
                Block b = blockArray[n2];
                if (dd <= c++) {
                    dd = maxD - ((Damageable)item.getItemMeta()).getDamage() - Trees.conf.saveToolDurability;
                    if (dd <= 1) {
                        if (dd != 1) break;
                        p.playSound(b.getLocation(), sound, SoundCategory.BLOCKS, Trees.conf.soundVolume, Trees.conf.soundPitch);
                        p.breakBlock(b);
                        break;
                    }
                    c = 0;
                }
                p.playSound(b.getLocation(), sound, SoundCategory.BLOCKS, Trees.conf.soundVolume, Trees.conf.soundPitch);
                p.breakBlock(b);
                ++n2;
            }
            this.remove(uuid);
            return;
        }
        if (Trees.conf.breakLogsPerTick != 0) {
            this.breakBlocksGradually(logs, p, uuid, Trees.conf.breakLogsPerTick, 1);
            return;
        }
        Block[] blockArray = logs;
        int n = logs.length;
        int n3 = 0;
        while (n3 < n) {
            Block b = blockArray[n3];
            p.playSound(b.getLocation(), sound, SoundCategory.BLOCKS, Trees.conf.soundVolume, Trees.conf.soundPitch);
            p.breakBlock(b);
            ++n3;
        }
        this.remove(uuid);
    }

    private Block[] breakLogsMode(Set<Block> logs) {
        switch (Trees.conf.breakLogsMode) {
            case 0: {
                return Utils.toArrey(new Block[logs.size()], logs);
            }
            case 1: {
                return this.yAcrescente(logs);
            }
            case 2: {
                return this.yDecrescente(logs);
            }
        }
        return Utils.toArrey(new Block[logs.size()], logs);
    }

    public Block[] yAcrescente(Set<Block> logs) {
        Block[] b = Utils.toArrey(new Block[logs.size()], logs);
        Arrays.sort(b, Comparator.comparingInt(Block::getY));
        return b;
    }

    public Block[] yDecrescente(Set<Block> logs) {
        Block[] b = Utils.toArrey(new Block[logs.size()], logs);
        Arrays.sort(b, Comparator.comparingInt(Block::getY).reversed());
        return b;
    }

    public void breakBlocksGradually(final Block[] blocks, final Player p, final UUID uuid, final int blocksPerTick, int delay) {
        new BukkitRunnable(){
            Sound sound;
            int i;
            {
                this.sound = blockArray[0].getBlockData().getSoundGroup().getBreakSound();
                this.i = 0;
            }

            public void run() {
                int bpt = 0;
                while (bpt < blocksPerTick && blocks.length > this.i) {
                    p.playSound(blocks[this.i].getLocation(), this.sound, SoundCategory.BLOCKS, Trees.conf.soundVolume, Trees.conf.soundPitch);
                    p.breakBlock(blocks[this.i]);
                    ++bpt;
                    ++this.i;
                }
                if (blocks.length <= this.i) {
                    Trees.this.mod.remove(uuid);
                    Trees.this.trees.remove(uuid);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)plugin, 1L, (long)delay);
    }

    public void breakBlocksGradually2(final Block[] blocks, final Player p, final UUID uuid, final int blocksPerTick, int delay) {
        if (blocksPerTick == 0) {
            return;
        }
        new BukkitRunnable(){
            Sound sound;
            ItemStack item;
            int c;
            int maxD;
            int dd;
            int i;
            {
                this.sound = blockArray[0].getBlockData().getSoundGroup().getBreakSound();
                this.item = player.getInventory().getItemInMainHand();
                this.c = 0;
                this.maxD = this.item.getType().getMaxDurability();
                this.dd = this.maxD - ((Damageable)this.item.getItemMeta()).getDamage() - 1 - Trees.conf.saveToolDurability;
                this.i = 0;
            }

            public void run() {
                if (!p.getInventory().getItemInMainHand().getType().equals((Object)this.item.getType())) {
                    Trees.this.mod.remove(uuid);
                    Trees.this.trees.remove(uuid);
                    this.cancel();
                    return;
                }
                int bpt = 0;
                while (bpt < blocksPerTick && blocks.length > this.i) {
                    if (this.dd <= this.c++) {
                        this.dd = this.item == null ? 0 : this.maxD - ((Damageable)this.item.getItemMeta()).getDamage() - Trees.conf.saveToolDurability;
                        if (this.dd <= 1) {
                            if (this.dd == 1) {
                                p.playSound(blocks[this.i].getLocation(), this.sound, SoundCategory.BLOCKS, Trees.conf.soundVolume, Trees.conf.soundPitch);
                                p.breakBlock(blocks[this.i]);
                            }
                            Trees.this.mod.remove(uuid);
                            Trees.this.trees.remove(uuid);
                            this.cancel();
                            return;
                        }
                        this.c = 0;
                    }
                    p.playSound(blocks[this.i].getLocation(), this.sound, SoundCategory.BLOCKS, Trees.conf.soundVolume, Trees.conf.soundPitch);
                    p.breakBlock(blocks[this.i]);
                    ++bpt;
                    ++this.i;
                }
                if (blocks.length <= this.i) {
                    Trees.this.mod.remove(uuid);
                    Trees.this.trees.remove(uuid);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)plugin, 1L, (long)delay);
    }

    private void sapling(Tree a) {
        if (a.chop.size() <= 4) {
            for (Block b : a.chop) {
                b.setType(Material.JUNGLE_SAPLING);
            }
        }
    }

    public void cancel(UUID uuid) {
        this.mod.remove(uuid);
        this.trees.remove(uuid);
    }

    private static void log(String m) {
        plugin.log("trees: " + m);
    }
}

