/*
 * Decompiled with CFR 0.152.
 */
package me.GUSTRUY.TreeChop.intern;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.GUSTRUY.TreeChop.intern.YmlManageLib;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SimpleConfig {
    private final String logName;
    protected String fileName;
    protected YmlManageLib data;
    protected YamlConfiguration config;
    protected String valuesErrorMessage = "Some values are misspelled";
    private SimpleConfigEnum[] values;

    public SimpleConfig(@Nonnull JavaPlugin plugin, @Nonnull SimpleConfigEnum[] values, @Nonnull String fileName) {
        this.data = new YmlManageLib(String.valueOf(plugin.getDataFolder()), plugin.getName());
        this.logName = "[" + plugin.getName() + "-SimpleConfig]: ";
        this.fileName = fileName;
        this.values = values;
    }

    public SimpleConfig(@Nonnull JavaPlugin plugin, @Nonnull SimpleConfigEnum[] values, @Nonnull String fileName, String valuesErrorMessage) {
        this.data = new YmlManageLib(String.valueOf(plugin.getDataFolder()), plugin.getName());
        this.logName = "[" + plugin.getName() + "-SimpleConfig]: ";
        this.valuesErrorMessage = valuesErrorMessage;
        this.fileName = fileName;
        this.values = values;
    }

    protected void loadFile() {
        this.config = this.data.loadFile(this.fileName);
    }

    protected void saveFile() {
        this.data.saveFile(this.fileName, this.config);
    }

    protected void closeConfig() {
        this.config = null;
    }

    protected void deleteFile() {
        this.data.delete(this.fileName);
    }

    protected void set(SimpleConfigEnum ekey, Object value) {
        this.config.set(ekey.getKey(), value);
    }

    protected void set(String key, Object value) {
        this.config.set(key, value);
    }

    protected void setDefoultOn(SimpleConfigEnum ekey) {
        this.config.set(ekey.getKey(), ekey.getValue());
    }

    protected void setDefoultOnAll() {
        SimpleConfigEnum[] simpleConfigEnumArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConfigEnum v = simpleConfigEnumArray[n2];
            this.setDefoultOn(v);
            ++n2;
        }
    }

    protected void setComments(SimpleConfigEnum ekey, List<String> comments) {
        this.config.setComments(ekey.getKey(), comments);
    }

    protected void setComments(SimpleConfigEnum ekey, String ... comments) {
        this.config.setComments(ekey.getKey(), SimpleConfig.toList(comments));
    }

    protected void setComments(String key, List<String> comments) {
        this.config.setComments(key, comments);
    }

    protected void setComments(String key, String ... comments) {
        this.config.setComments(key, SimpleConfig.toList(comments));
    }

    @Deprecated
    public Object getDefoult(SimpleConfigEnum ekey) {
        return ekey.getValue();
    }

    protected Object get(String key) {
        return this.config.get(key);
    }

    protected Object get(SimpleConfigEnum ekey) {
        return this.config.get(ekey.getKey());
    }

    protected List<String> correctDefoult() {
        ArrayList<String> errors = new ArrayList<String>();
        String errorKeys = "keys:";
        boolean error = false;
        SimpleConfigEnum[] simpleConfigEnumArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConfigEnum defoult = simpleConfigEnumArray[n2];
            String key = defoult.getKey();
            Object valueD = defoult.getValue();
            Object value = this.config.get(key);
            if (!(valueD == null || valueD.getClass().isInstance(value) || value instanceof String && this.reflect(key, valueD, value))) {
                this.log("errorConfigKey: '" + key + " | " + String.valueOf(value) + "' ");
                this.config.set(key, valueD);
                errorKeys = errorKeys.concat(" " + key);
                error = true;
            }
            ++n2;
        }
        if (error) {
            errors.add(0, this.valuesErrorMessage);
            errors.add(errorKeys);
            return errors;
        }
        return null;
    }

    protected List<String> setIfCorrect(SimpleConfigEnum ekey, Object value) {
        ArrayList<String> errors = new ArrayList<String>();
        String errorKeys = "Value in conflict with this key:";
        boolean error = false;
        String key = ekey.getKey();
        Object valueD = ekey.getValue();
        if (valueD != null) {
            if (!valueD.getClass().isInstance(value)) {
                if (value instanceof String && this.reflect(key, valueD, value)) {
                    return null;
                }
                this.log("errorConfigKey: '" + key + " | " + String.valueOf(value) + "' ");
                errorKeys = errorKeys.concat(" " + key);
                error = true;
            } else {
                this.config.set(key, value);
            }
        }
        if (error) {
            errors.add(errorKeys);
            return errors;
        }
        return null;
    }

    private boolean reflect(String key, Object valueD, Object value) {
        if (valueD instanceof Boolean && !((String)value).equalsIgnoreCase("true") && !((String)value).equalsIgnoreCase("false")) {
            return false;
        }
        Method[] methodArray = valueD.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals("valueOf")) {
                try {
                    value = m.invoke((Object)((String)value), (String)value);
                    this.config.set(key, value);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            ++n2;
        }
        List<Object> list = null;
        if (valueD instanceof List && !((List)valueD).isEmpty()) {
            if (((List)valueD).get(0) instanceof String) {
                list = this.toStringList((String)value);
            } else if (((List)valueD).get(0) instanceof Integer) {
                list = this.toIntList((String)value);
            }
        }
        if (list != null) {
            this.config.set(key, list);
            return true;
        }
        return false;
    }

    public void resetFile() {
        this.deleteFile();
        this.saveDefault();
    }

    public final void saveDefault() {
        this.loadFile();
        this.setDefoultOnAll();
        this.onLoad();
        this.onCorrect();
        this.onSave();
        this.saveFile();
        this.closeConfig();
    }

    public final void save() {
        this.save(false);
    }

    protected final void save(boolean fileOpened) {
        if (!fileOpened) {
            this.loadFile();
        }
        this.onSave();
        this.saveFile();
        if (!fileOpened) {
            this.closeConfig();
        }
    }

    public final List<String> load() {
        if (!this.data.exists(this.fileName)) {
            this.saveDefault();
        }
        this.loadFile();
        List<String> errors = this.correctDefoult();
        this.onLoad();
        this.onCorrect();
        if (errors != null) {
            this.save(true);
        }
        this.closeConfig();
        return errors;
    }

    public final List<String> reload() {
        if (!this.data.exists(this.fileName)) {
            this.save();
        }
        this.loadFile();
        List<String> errors = this.correctDefoult();
        this.onLoad();
        this.onCorrect();
        if (errors != null) {
            this.save(true);
        }
        this.closeConfig();
        return errors;
    }

    protected abstract void onSave();

    protected abstract void onLoad();

    protected boolean onCorrect() {
        return this.onCorrect(true);
    }

    protected abstract boolean onCorrect(boolean var1);

    protected int getConfigV(SimpleConfigEnum ekey) {
        return this.config.getInt(ekey.getKey());
    }

    protected void setConfigV(SimpleConfigEnum ekey) {
        if (((Integer)ekey.getValue()).intValue() != this.config.getInt(ekey.getKey())) {
            this.setDefoultOn(ekey);
            this.save(true);
        }
    }

    @Deprecated
    protected List<String> getEnumNamesList(int startAt) {
        ArrayList<String> list = new ArrayList<String>(this.values.length - startAt);
        int i = startAt;
        while (i < this.values.length) {
            list.add(this.values[i].toString());
            ++i;
        }
        return list;
    }

    public Object getValue(SimpleConfigEnum ekey) {
        if (ekey == null) {
            return null;
        }
        this.loadFile();
        Object v = this.get(ekey);
        this.closeConfig();
        return v;
    }

    public List<Object> getValues(SimpleConfigEnum[] ekeys) {
        if (ekeys == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(ekeys.length);
        this.loadFile();
        SimpleConfigEnum[] simpleConfigEnumArray = ekeys;
        int n = ekeys.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleConfigEnum ekey = simpleConfigEnumArray[n2];
            list.add(this.get(ekey));
            ++n2;
        }
        this.closeConfig();
        return list;
    }

    public List<String> setValue(SimpleConfigEnum ekey, Object value) {
        if (ekey == null) {
            ArrayList<String> errors = new ArrayList<String>();
            errors.add("Invalid key");
            return errors;
        }
        this.loadFile();
        Object aValue = this.get(ekey);
        List<String> errors = this.setIfCorrect(ekey, value);
        if (errors == null) {
            this.onLoad();
            if (!this.onCorrect()) {
                this.set(ekey, aValue);
                this.onLoad();
                this.log("Value of parameter '" + ekey.getKey() + "' resetted to '" + String.valueOf(aValue) + "'");
                this.onCorrect();
                errors = new ArrayList<String>();
                errors.add("Value out of scope!");
            }
            this.saveFile();
        }
        this.closeConfig();
        return errors;
    }

    protected float getFloat(String path) {
        return Double.valueOf(this.config.getDouble(path)).floatValue();
    }

    protected static String[] stringArrey(String ... s) {
        return s;
    }

    protected static List<String> stringList(String ... s) {
        ArrayList<String> list = new ArrayList<String>(s.length);
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            list.add(s1.toLowerCase());
            ++n2;
        }
        return list;
    }

    protected static List<String> toList1(String[] s) {
        ArrayList<String> list = new ArrayList<String>(s.length);
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            list.add(s1.toLowerCase());
            ++n2;
        }
        return list;
    }

    public static <E> List<E> toList(E[] s) {
        ArrayList<E> list = new ArrayList<E>();
        E[] EArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            E s1 = EArray[n2];
            list.add(s1);
            ++n2;
        }
        return list;
    }

    protected static String[] toArrey(List<String> list) {
        String[] a = new String[list.size()];
        int n = 0;
        for (String s1 : list) {
            a[n++] = s1.toLowerCase();
        }
        return a;
    }

    public static <T> T[] toArrey(T[] a, Set<T> list) {
        int n = 0;
        for (T s1 : list) {
            a[n++] = s1;
        }
        return a;
    }

    protected List<String> toStringList(String s) {
        char a = '[';
        char a1 = ']';
        if (s.charAt(0) == a && s.charAt(s.length() - 1) == a1) {
            return SimpleConfig.toList(s.replace("[", "").replace("]", "").split(","));
        }
        return null;
    }

    protected List<Integer> toIntList(String s) {
        char a = '[';
        char a1 = ']';
        if (s.charAt(0) == a && s.charAt(s.length() - 1) == a1) {
            String[] listS = s.replace("[", "").replace("]", "").split(",");
            ArrayList<Integer> listI = new ArrayList<Integer>();
            try {
                String[] stringArray = listS;
                int n = listS.length;
                int n2 = 0;
                while (n2 < n) {
                    String s1 = stringArray[n2];
                    listI.add(Integer.parseInt(s1));
                    ++n2;
                }
            }
            catch (Exception e) {
                return null;
            }
            return listI;
        }
        return null;
    }

    protected static SimpleConfigEnum[] cloneValues(SimpleConfigEnum[] values, int remove) {
        SimpleConfigEnum[] clone = new SimpleConfigEnum[values.length - remove];
        int n = 0;
        int i = 0;
        SimpleConfigEnum[] simpleConfigEnumArray = values;
        int n2 = values.length;
        int n3 = 0;
        while (n3 < n2) {
            SimpleConfigEnum v = simpleConfigEnumArray[n3];
            if (n++ >= remove) {
                clone[i++] = v;
            }
            ++n3;
        }
        return clone;
    }

    protected void log(String m) {
        Bukkit.getLogger().log(Level.SEVERE, this.logName + m);
    }

    protected void log(@Nonnull Level l, String m) {
        Bukkit.getLogger().log(l, this.logName + m);
    }

    private static void logT(String m) {
        Bukkit.getLogger().log(Level.SEVERE, "debug: " + m);
    }

    public static interface SimpleConfigEnum {
        public String getKey();

        public Object getValue();
    }
}

