/*
 * Decompiled with CFR 0.152.
 */
package me.GUSTRUY.TreeChop.intern;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class YmlManageLib {
    private static final String yml = ".yml";
    private final String dir;
    private final String logName;

    public YmlManageLib(String dir, @Nonnull String logName) {
        this.dir = dir;
        this.logName = logName + ":";
    }

    public String getDir() {
        return this.dir;
    }

    public File getFile(String name) {
        return new File(this.dir, name + yml);
    }

    public YamlConfiguration loadFile(String name) {
        return YamlConfiguration.loadConfiguration((File)new File(this.dir, name + yml));
    }

    public void saveFile(String name, YamlConfiguration y) {
        File file = new File(this.dir, name + yml);
        try {
            y.save(file);
        }
        catch (Exception e) {
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!file.exists()) {
                try {
                    y.save(file);
                    return;
                }
                catch (Exception ee) {
                    this.log("error on saveFile_2 " + name + yml);
                    ee.printStackTrace();
                    return;
                }
            }
            this.log("error on saveFile " + name + yml);
            e.printStackTrace();
        }
    }

    public boolean delete(String name) {
        return this.getFile(name).delete();
    }

    public boolean exists(String name) {
        File file = this.getFile(name);
        return file.exists() && !file.isDirectory();
    }

    public boolean move(String name, String destination) {
        try {
            Files.move(Paths.get(this.dir + "/" + name + yml, new String[0]), Paths.get(this.dir + "/" + destination + yml, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (SecurityException e) {
            this.log("no permission to move the file ");
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            File file = new File(this.dir + "/" + destination);
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
                try {
                    Files.move(Paths.get(this.dir + "/" + name + yml, new String[0]), Paths.get(this.dir + "/" + destination + yml, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            return false;
        }
    }

    public YamlConfiguration create() {
        YamlConfiguration y = new YamlConfiguration();
        return y;
    }

    private void log(String m) {
        Bukkit.getLogger().log(Level.SEVERE, "YmlManagementLib: " + this.logName + " " + m);
    }
}

