/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.taxfreelevels.forge;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfig
implements IMixinConfigPlugin {
    private final Set<String> disabledMixins = new HashSet<String>();
    private String mixinPackage;

    @Nullable
    public static ModInfo getModInfo(String modId) {
        for (ModInfo mod : FMLLoader.getLoadingModList().getMods()) {
            if (!mod.getModId().equals(modId)) continue;
            return mod;
        }
        return null;
    }

    public static boolean isModInstalled(String modId) {
        return MixinConfig.getModInfo(modId) != null;
    }

    public static boolean isModInstalled(String modId, @NotNull Predicate<ArtifactVersion> predicate) {
        ModInfo modInfo = MixinConfig.getModInfo(modId);
        if (modInfo == null) {
            return false;
        }
        return predicate.test(modInfo.getVersion());
    }

    public void onLoad(String mixinPackage) {
        this.mixinPackage = mixinPackage;
        if (MixinConfig.isModInstalled("enchanting_overhauled")) {
            this.disabledMixins.add("CheapAnvilRenameMixin");
            this.disabledMixins.add("FlattenAnvilCostMixin");
        }
        if (!MixinConfig.isModInstalled("waystones", v -> 0 <= v.compareTo((Object)new DefaultArtifactVersion("15.1.3")) && v.compareTo((Object)new DefaultArtifactVersion("16.0.1")) < 0)) {
            this.disabledMixins.add("Waystones2Mixin");
        }
        if (!MixinConfig.isModInstalled("waystones", v -> v.compareTo((Object)new DefaultArtifactVersion("15.1.3")) < 0)) {
            this.disabledMixins.add("WaystonesMixin");
        }
        if (!MixinConfig.isModInstalled("enchantinginfuser")) {
            this.disabledMixins.add("EnchantingInfuserMixin");
        }
        if (MixinConfig.isModInstalled("apotheosis", v -> v.compareTo((Object)new DefaultArtifactVersion("6.5.0")) >= 0)) {
            this.disabledMixins.add("FlattenAnvilCostMixin");
        } else {
            this.disabledMixins.add("EnchantmentUtilsMixin");
        }
        if (!MixinConfig.isModInstalled("tetra")) {
            this.disabledMixins.add("TetraMixin");
        }
        if (!MixinConfig.isModInstalled("disenchanting")) {
            this.disabledMixins.add("DisenchantingForgeMixin");
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixinName = mixinClassName.substring(this.mixinPackage.length() + 1);
        return !this.disabledMixins.contains(mixinName);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

