/*
 * Decompiled with CFR 0.152.
 */
package org.dexflex.basicallycommandutils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7157;

public class EntitifyCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"entitify").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity_type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Arrays.asList("falling_block", "block_display"), (SuggestionsBuilder)builder)).executes(ctx -> EntitifyCommand.execute((CommandContext<class_2168>)ctx, "keep", null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"keep_remove", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Arrays.asList("keep", "remove"), (SuggestionsBuilder)builder)).executes(ctx -> EntitifyCommand.execute((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"keep_remove"), null))).then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> EntitifyCommand.execute((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"keep_remove"), StringArgumentType.getString((CommandContext)ctx, (String)"tag"))))))));
    }

    private static int execute(CommandContext<class_2168> context, String keepRemove, String tag) throws CommandSyntaxException {
        class_2338 pos;
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        class_2680 blockState = world.method_8320(pos = class_2262.method_48299(context, (String)"pos"));
        if (blockState.method_26215()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No block found."));
            return 0;
        }
        class_243 spawnPos = class_243.method_24953((class_2382)pos);
        String entityType = StringArgumentType.getString(context, (String)"entity_type");
        Object tagToUse = tag == null || tag.isEmpty() ? "BUC.entitified." + entityType : tag;
        class_2487 stateTag = class_2512.method_10686((class_2680)blockState);
        double x = spawnPos.field_1352;
        double y = spawnPos.field_1351;
        double z = spawnPos.field_1350;
        if (entityType.equals("falling_block")) {
            String nbt = String.format("{BlockState:%s,Time:1b,NoGravity:1b,DropItem:0b,Tags:[\"%s\"]}", stateTag, tagToUse);
            source.method_9211().method_3734().method_9235().execute(String.format("summon falling_block %f %f %f %s", x, y, z, nbt), (Object)source.method_9217());
        } else if (entityType.equals("block_display")) {
            String nbt = String.format("{block_state:%s,Tags:[\"%s\"]}", stateTag, tagToUse);
            source.method_9211().method_3734().method_9235().execute(String.format("summon block_display %f %f %f %s", x, y, z, nbt), (Object)source.method_9217());
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid type. Use falling_block or block_display."));
            return 0;
        }
        if ("remove".equalsIgnoreCase(keepRemove)) {
            world.method_8650(pos, false);
        }
        source.method_9226(() -> EntitifyCommand.lambda$execute$6(entityType, (String)tagToUse), true);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$execute$6(String entityType, String tagToUse) {
        return class_2561.method_43470((String)("Entitified as " + entityType + " with tag '" + tagToUse + "'."));
    }
}

