/*
 * Decompiled with CFR 0.152.
 */
package org.dexflex.basicallycommandutils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2183;
import net.minecraft.class_2284;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_6335;

public class RaycastCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"raycast").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"steps", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"step_length", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).then(class_2170.method_9244((String)"function", (ArgumentType)class_2284.method_9760()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3218 world = source.method_9225();
            int steps = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"steps");
            float stepLength = FloatArgumentType.getFloat((CommandContext)ctx, (String)"step_length");
            Collection functions = class_2284.method_9769((CommandContext)ctx, (String)"function");
            class_2183.class_2184 anchor = source.method_9219();
            class_243 startPos = anchor.method_9299(source);
            class_241 rot = source.method_9210();
            class_243 dir = class_243.method_1030((float)rot.field_1343, (float)rot.field_1342);
            class_6335 marker = new class_6335(class_1299.field_33456, (class_1937)world);
            marker.method_33574(startPos);
            marker.method_5780("basicallycommandutils.raycast_origin");
            world.method_8649((class_1297)marker);
            RaycastCommand.runRaycastStep(world, source, functions, startPos, dir, stepLength, steps, 0, marker.method_5667());
            return 1;
        })))));
    }

    private static void runRaycastStep(class_3218 world, class_2168 originalSource, Collection<class_2158<class_2168>> functions, class_243 startPos, class_243 dir, float stepLength, int maxSteps, int currentStep, UUID markerId) {
        if (currentStep >= maxSteps) {
            return;
        }
        class_6335 marker = (class_6335)world.method_14190(markerId);
        if (marker == null || !marker.method_5805()) {
            return;
        }
        class_243 stepPos = startPos.method_1019(dir.method_1021((double)((float)currentStep * stepLength)));
        class_2168 stepSource = originalSource.method_9208(stepPos);
        for (class_2158<class_2168> function : functions) {
            world.method_8503().method_3740().method_12904(function, stepSource.method_9217());
        }
        world.method_8503().method_20493(() -> RaycastCommand.runRaycastStep(world, originalSource, functions, startPos, dir, stepLength, maxSteps, currentStep + 1, markerId));
    }
}

