/*
 * Decompiled with CFR 0.152.
 */
package de.exlll.configlib;

import de.exlll.configlib.ConfigurationElement;
import de.exlll.configlib.ConfigurationException;
import de.exlll.configlib.ConfigurationProperties;
import de.exlll.configlib.Reflect;
import de.exlll.configlib.SerializeWith;
import de.exlll.configlib.Serializer;
import de.exlll.configlib.SerializerContext;
import de.exlll.configlib.SerializerContextImpl;
import de.exlll.configlib.Serializers;
import de.exlll.configlib.TypeSerializer;
import de.exlll.configlib.Validator;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;

final class SerializerSelector {
    private static final Map<Class<?>, Serializer<?, ?>> DEFAULT_SERIALIZERS = Map.ofEntries(Map.entry(Boolean.TYPE, new Serializers.BooleanSerializer()), Map.entry(Boolean.class, new Serializers.BooleanSerializer()), Map.entry(Byte.TYPE, new Serializers.NumberSerializer(Byte.TYPE)), Map.entry(Byte.class, new Serializers.NumberSerializer(Byte.class)), Map.entry(Short.TYPE, new Serializers.NumberSerializer(Short.TYPE)), Map.entry(Short.class, new Serializers.NumberSerializer(Short.class)), Map.entry(Integer.TYPE, new Serializers.NumberSerializer(Integer.TYPE)), Map.entry(Integer.class, new Serializers.NumberSerializer(Integer.class)), Map.entry(Long.TYPE, new Serializers.NumberSerializer(Long.TYPE)), Map.entry(Long.class, new Serializers.NumberSerializer(Long.class)), Map.entry(Float.TYPE, new Serializers.NumberSerializer(Float.TYPE)), Map.entry(Float.class, new Serializers.NumberSerializer(Float.class)), Map.entry(Double.TYPE, new Serializers.NumberSerializer(Double.TYPE)), Map.entry(Double.class, new Serializers.NumberSerializer(Double.class)), Map.entry(Character.TYPE, new Serializers.CharacterSerializer()), Map.entry(Character.class, new Serializers.CharacterSerializer()), Map.entry(String.class, new Serializers.StringSerializer()), Map.entry(BigInteger.class, new Serializers.BigIntegerSerializer()), Map.entry(BigDecimal.class, new Serializers.BigDecimalSerializer()), Map.entry(LocalDate.class, new Serializers.LocalDateSerializer()), Map.entry(LocalTime.class, new Serializers.LocalTimeSerializer()), Map.entry(LocalDateTime.class, new Serializers.LocalDateTimeSerializer()), Map.entry(Instant.class, new Serializers.InstantSerializer()), Map.entry(UUID.class, new Serializers.UuidSerializer()), Map.entry(File.class, new Serializers.FileSerializer()), Map.entry(Path.class, new Serializers.PathSerializer()), Map.entry(URL.class, new Serializers.UrlSerializer()), Map.entry(URI.class, new Serializers.UriSerializer()));
    private final ConfigurationProperties properties;
    private ConfigurationElement<?> element;
    private int currentNesting = -1;

    public SerializerSelector(ConfigurationProperties properties) {
        this.properties = Validator.requireNonNull(properties, "configuration properties");
    }

    public Serializer<?, ?> select(ConfigurationElement<?> element) {
        this.element = element;
        this.currentNesting = -1;
        return this.selectForType(element.annotatedType());
    }

    private Serializer<?, ?> selectForType(AnnotatedType annotatedType) {
        ++this.currentNesting;
        Serializer<?, ?> custom = this.selectCustomSerializer(annotatedType);
        if (custom != null) {
            return custom;
        }
        Type type = annotatedType.getType();
        if (type instanceof Class) {
            return this.selectForClass(annotatedType);
        }
        if (type instanceof ParameterizedType) {
            return this.selectForParameterizedType((AnnotatedParameterizedType)annotatedType);
        }
        if (type instanceof WildcardType) {
            String msg = this.baseExceptionMessage(type) + "Wildcard types cannot be serialized.";
            throw new ConfigurationException(msg);
        }
        if (type instanceof GenericArrayType) {
            String msg = this.baseExceptionMessage(type) + "Generic array types cannot be serialized.";
            throw new ConfigurationException(msg);
        }
        if (type instanceof TypeVariable) {
            String msg = this.baseExceptionMessage(type) + "Type variables cannot be serialized.";
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException(this.baseExceptionMessage(type));
    }

    private Serializer<?, ?> selectCustomSerializer(AnnotatedType annotatedType) {
        return this.findConfigurationElementSerializer(annotatedType).or(() -> this.findSerializerFactoryForType(annotatedType)).or(() -> this.findSerializerForType(annotatedType)).or(() -> this.findSerializerOnType(annotatedType)).or(() -> this.findMetaSerializerOnType(annotatedType)).or(() -> this.findSerializerByCondition(annotatedType)).orElse(null);
    }

    private Optional<Serializer<?, ?>> findConfigurationElementSerializer(AnnotatedType annotatedType) {
        SerializeWith annotation = this.element.annotation(SerializeWith.class);
        if (annotation != null && this.currentNesting == annotation.nesting()) {
            return Optional.of(this.newSerializerFromAnnotation(annotatedType, annotation));
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerFactoryForType(AnnotatedType annotatedType) {
        Type type = annotatedType.getType();
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (this.properties.getSerializerFactories().containsKey(cls)) {
                SerializerContextImpl context = new SerializerContextImpl(this.properties, this.element, annotatedType);
                Function<SerializerContext, Serializer<?, ?>> factory = this.properties.getSerializerFactories().get(cls);
                Serializer<?, ?> serializer = factory.apply(context);
                if (serializer == null) {
                    String msg = "Serializer factories must not return null.";
                    throw new ConfigurationException(msg);
                }
                return Optional.of(serializer);
            }
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerForType(AnnotatedType annotatedType) {
        Type type = annotatedType.getType();
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (this.properties.getSerializers().containsKey(cls)) {
                return Optional.of(this.properties.getSerializers().get(cls));
            }
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerOnType(AnnotatedType annotatedType) {
        Class cls;
        Type type = annotatedType.getType();
        if (type instanceof Class && (cls = (Class)type).getDeclaredAnnotation(SerializeWith.class) != null) {
            SerializeWith annotation = cls.getDeclaredAnnotation(SerializeWith.class);
            return Optional.of(this.newSerializerFromAnnotation(annotatedType, annotation));
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findMetaSerializerOnType(AnnotatedType annotatedType) {
        Annotation[] annotationArray = annotatedType.getType();
        if (annotationArray instanceof Class) {
            Class cls = (Class)annotationArray;
            for (Annotation meta : cls.getDeclaredAnnotations()) {
                Class<? extends Annotation> metaType = meta.annotationType();
                SerializeWith annotation = metaType.getDeclaredAnnotation(SerializeWith.class);
                if (annotation == null) continue;
                return Optional.of(this.newSerializerFromAnnotation(annotatedType, annotation));
            }
        }
        return Optional.empty();
    }

    private Optional<Serializer<?, ?>> findSerializerByCondition(AnnotatedType annotatedType) {
        for (Map.Entry<Predicate<Type>, Serializer<?, ?>> entry : this.properties.getSerializersByCondition().entrySet()) {
            if (!entry.getKey().test(annotatedType.getType())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private Serializer<?, ?> newSerializerFromAnnotation(AnnotatedType annotatedType, SerializeWith annotation) {
        SerializerContextImpl context = new SerializerContextImpl(this.properties, this.element, annotatedType);
        return Serializers.newCustomSerializer(annotation.serializer(), context);
    }

    private Serializer<?, ?> selectForClass(AnnotatedType annotatedType) {
        Class cls = (Class)annotatedType.getType();
        if (DEFAULT_SERIALIZERS.containsKey(cls)) {
            return DEFAULT_SERIALIZERS.get(cls);
        }
        if (Reflect.isEnumType(cls)) {
            Class enumType = cls;
            return new Serializers.EnumSerializer(enumType);
        }
        if (Reflect.isArrayType(cls)) {
            return this.selectForArray((AnnotatedArrayType)annotatedType);
        }
        if (Reflect.isConfigurationType(cls)) {
            return TypeSerializer.newSerializerFor(cls, this.properties);
        }
        String msg = "Missing serializer for type " + cls + ".\nEither annotate the type with @Configuration, make it a Java record, or provide a custom serializer for it.";
        throw new ConfigurationException(msg);
    }

    private Serializer<?, ?> selectForArray(AnnotatedArrayType annotatedType) {
        AnnotatedType annotatedElementType = annotatedType.getAnnotatedGenericComponentType();
        Class elementType = (Class)annotatedElementType.getType();
        if (elementType == Boolean.TYPE) {
            return new Serializers.PrimitiveBooleanArraySerializer();
        }
        if (elementType == Character.TYPE) {
            return new Serializers.PrimitiveCharacterArraySerializer();
        }
        if (elementType == Byte.TYPE) {
            return new Serializers.PrimitiveByteArraySerializer();
        }
        if (elementType == Short.TYPE) {
            return new Serializers.PrimitiveShortArraySerializer();
        }
        if (elementType == Integer.TYPE) {
            return new Serializers.PrimitiveIntegerArraySerializer();
        }
        if (elementType == Long.TYPE) {
            return new Serializers.PrimitiveLongArraySerializer();
        }
        if (elementType == Float.TYPE) {
            return new Serializers.PrimitiveFloatArraySerializer();
        }
        if (elementType == Double.TYPE) {
            return new Serializers.PrimitiveDoubleArraySerializer();
        }
        Serializer<?, ?> elementSerializer = this.selectForType(annotatedElementType);
        boolean inputNulls = this.properties.inputNulls();
        boolean outputNulls = this.properties.outputNulls();
        return new Serializers.ArraySerializer(elementType, elementSerializer, outputNulls, inputNulls);
    }

    private Serializer<?, ?> selectForParameterizedType(AnnotatedParameterizedType annotatedType) {
        ParameterizedType type = (ParameterizedType)annotatedType.getType();
        Class rawType = (Class)type.getRawType();
        AnnotatedType[] typeArgs = annotatedType.getAnnotatedActualTypeArguments();
        boolean inputNulls = this.properties.inputNulls();
        boolean outputNulls = this.properties.outputNulls();
        if (Reflect.isListType(rawType)) {
            Serializer<?, ?> elementSerializer = this.selectForType(typeArgs[0]);
            return new Serializers.ListSerializer(elementSerializer, outputNulls, inputNulls);
        }
        if (Reflect.isSetType(rawType)) {
            Serializer<?, ?> elementSerializer = this.selectForType(typeArgs[0]);
            return this.properties.serializeSetsAsLists() ? new Serializers.SetAsListSerializer(elementSerializer, outputNulls, inputNulls) : new Serializers.SetSerializer(elementSerializer, outputNulls, inputNulls);
        }
        if (Reflect.isMapType(rawType)) {
            Class cls;
            Type type2 = typeArgs[0].getType();
            if (type2 instanceof Class && (DEFAULT_SERIALIZERS.containsKey(cls = (Class)type2) || Reflect.isEnumType(cls))) {
                Serializer<?, ?> keySerializer = this.selectForClass(typeArgs[0]);
                Serializer<?, ?> valSerializer = this.selectForType(typeArgs[1]);
                return new Serializers.MapSerializer(keySerializer, valSerializer, outputNulls, inputNulls);
            }
            String msg = this.baseExceptionMessage(type) + "Map keys can only be of simple or enum type.";
            throw new ConfigurationException(msg);
        }
        String msg = this.baseExceptionMessage(type) + "Parameterized types other than lists, sets, and maps cannot be serialized.";
        throw new ConfigurationException(msg);
    }

    private String baseExceptionMessage(Type type) {
        return "Cannot select serializer for type '%s'.\n".formatted(type);
    }
}

