/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.trashcan.flavor;

import info.preva1l.trashcan.flavor.Flavor;
import info.preva1l.trashcan.flavor.FlavorOptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.QueryFunction;

public class PackageIndexer {
    private final Class<?> clazz;
    private final FlavorOptions options;
    public final Reflections reflections;

    public PackageIndexer(Class<?> clazz, FlavorOptions options) {
        this.clazz = clazz;
        this.options = options;
        ConfigurationBuilder config = new ConfigurationBuilder().forPackage(options.getMainPackage(), new ClassLoader[]{clazz.getClassLoader()}).setParallel(true).addScanners(new Scanner[]{Scanners.MethodsAnnotated, Scanners.TypesAnnotated, Scanners.SubTypes});
        this.reflections = new Reflections((Configuration)config);
    }

    public <T> List<Class<?>> getSubTypes(Class<T> type) {
        return this.reflections.get(this.subTypes(type)).stream().toList();
    }

    public void invokeMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        this.getMethodsAnnotatedWith(annotation).forEach(it -> {
            try {
                Object target = Modifier.isStatic(it.getModifiers()) ? null : Flavor.objectInstance(it.getDeclaringClass());
                it.setAccessible(true);
                it.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                this.options.getLogger().log(Level.WARNING, String.join((CharSequence)" ", "Failed to run container part", it.getClass().getSimpleName(), "on", annotation.getSimpleName(), ":", it.getName()), e);
            }
        });
    }

    public <T extends Annotation> List<Method> getMethodsAnnotatedWith(Class<T> annotation) {
        return this.reflections.get(this.annotated(annotation)).stream().toList();
    }

    public <T extends Annotation> List<Class<?>> getTypesAnnotatedWith(Class<T> annotation) {
        ArrayList result = new ArrayList();
        for (String className : this.reflections.get(Scanners.TypesAnnotated.with(new AnnotatedElement[]{annotation}))) {
            try {
                result.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return result;
    }

    public <T> QueryFunction<Store, Method> annotated(Class<T> annotation) {
        return Scanners.MethodsAnnotated.with(new AnnotatedElement[]{annotation}).as(Method.class, new ClassLoader[]{this.clazz.getClassLoader()});
    }

    public <T> QueryFunction<Store, Class<?>> subTypes(Class<T> annotation) {
        return Scanners.SubTypes.with(new AnnotatedElement[]{annotation}).as();
    }
}

