/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.trashcan.logging;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;

public class RawDogLogger
extends ConsoleHandler {
    private static final String ANSI_RESET = "\u001b[m";
    private static final String ANSI_ERROR = "\u001b[31;1m";
    private static final String ANSI_FATAL = "\u001b[91;1m";
    private static final String ANSI_WARN = "\u001b[33;1m";
    private static final String ANSI_DEBUG = "\u001b[36;1m";

    @Override
    public void publish(LogRecord record) {
        PrintStream rawOut = new PrintStream(new FileOutputStream(FileDescriptor.out));
        String ANSI_COLOR = switch (record.getLevel().getName()) {
            case "WARNING" -> ANSI_WARN;
            case "SEVERE" -> ANSI_ERROR;
            case "CONFIG" -> ANSI_DEBUG;
            case "FATAL" -> ANSI_FATAL;
            default -> "";
        };
        rawOut.println(ANSI_COLOR + this.getFormatter().format(record) + ANSI_RESET);
    }
}

