/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.trashcan.logging;

import info.preva1l.trashcan.logging.RawDogLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class ServiceLogFormatter
extends SimpleFormatter {
    private static final String FORMAT = "[%tT %s]: [%s] [Services] [%s] %s%s";
    private static final String ANONYMOUS_SERVICE = "Anonymous Service";
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private final String rootLoggerName;

    public ServiceLogFormatter(String rootLoggerName) {
        this.rootLoggerName = rootLoggerName;
    }

    public static ConsoleHandler asConsoleHandler(String rootLoggerName) {
        return ServiceLogFormatter.asConsoleHandler(false, rootLoggerName);
    }

    public static ConsoleHandler asConsoleHandler(boolean rawDog, String rootLoggerName) {
        ConsoleHandler handler = rawDog ? new RawDogLogger() : new ConsoleHandler();
        handler.setFormatter(new ServiceLogFormatter(rootLoggerName));
        return handler;
    }

    @Override
    public String format(LogRecord record) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(record.getInstant(), ZONE_ID);
        String sourceClass = record.getSourceClassName();
        String service = sourceClass != null ? sourceClass.substring(sourceClass.lastIndexOf(46) + 1) : ANONYMOUS_SERVICE;
        String message = this.formatMessage(record);
        String throwable = "";
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            thrown.printStackTrace(pw);
            pw.flush();
            throwable = sw.toString();
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = zdt;
        objectArray[1] = switch (record.getLevel().getName()) {
            case "SEVERE" -> "ERROR";
            case "WARNING" -> "WARN";
            case "INFO" -> "INFO";
            case "CONFIG" -> "DEBUG";
            default -> "TRACE";
        };
        objectArray[2] = this.rootLoggerName;
        objectArray[3] = service;
        objectArray[4] = message;
        objectArray[5] = throwable;
        return FORMAT.formatted(objectArray);
    }
}

