/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.common.config;

import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.YamlConfigurations;
import java.util.List;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;

@Configuration
public class Config {
    private static Config instance;
    private Logging logging = new Logging();
    @Comment(value={""})
    private Punishments punishments = new Punishments();
    @Comment(value={"\nWhether or not exploit detections should be sent to Discord as an Embed webhook.\nDon't know how to create a webhook? See https://support.discord.com/hc/en-us/articles/228383668-Intro-to-Webhooks"})
    private Discord discord = new Discord();

    public static Config i() {
        if (instance != null) {
            return instance;
        }
        instance = YamlConfigurations.update(AntiCrasherAPI.getInstance().getPlatform().getConfigDirectory().resolve("config.yml"), Config.class);
        return instance;
    }

    public static void reload() {
        instance = YamlConfigurations.update(AntiCrasherAPI.getInstance().getPlatform().getConfigDirectory().resolve("config.yml"), Config.class);
    }

    @Generated
    public Logging getLogging() {
        return this.logging;
    }

    @Generated
    public Punishments getPunishments() {
        return this.punishments;
    }

    @Generated
    public Discord getDiscord() {
        return this.discord;
    }

    @Generated
    private Config() {
    }

    @Configuration
    public static class Logging {
        @Comment(value={"Log exploit detections to console."})
        private boolean console = true;
        @Comment(value={"Log exploit detections to a file in the /logs directory."})
        private boolean file = true;
        private Chat chat = new Chat();

        @Generated
        public boolean isConsole() {
            return this.console;
        }

        @Generated
        public boolean isFile() {
            return this.file;
        }

        @Generated
        public Chat getChat() {
            return this.chat;
        }

        @Generated
        private Logging() {
        }

        @Configuration
        public static class Chat {
            @Comment(value={"Log exploit detections to users with the `anticrasher.alerts` permission"})
            private boolean chatAlerts = true;
            @Comment(value={"\nAlerts format for chat alerts. (MiniMessage only)\nAvailable placeholders:\n<player_name> - The name of the player who failed the exploit check.\n<player_uuid> - The UUID of the player who failed the exploit check.\n<player_ip> - The IP of the player who failed the exploit check. Useful for ban cmds without using PAPI (for whatever reason).\n<exploit_name> - The name of the exploit that was triggered (e.g. Book, PluginMessage, etc.)\n<exploit_type> - The type of the check that was triggered (e.g. A, B, C, D)\n<exploit_description> - The description of the exploit that was triggered"})
            private String alertsFormat = "<blue><bold>AntiCrasher<reset> <dark_grey>\u00bb <red><player_name> <grey>failed <red><exploit_name> <gray>[<red>Type <exploit_type></red>]";
            @Comment(value={"\nFormat for the hover text of the chat alert.\nSame placeholders as above."})
            private List<String> alertsHoverFormat = List.of("<gray>Exploit: <red><exploit_name>", "<gray>Exploit Description: <red><exploit_description>");

            @Generated
            public boolean isChatAlerts() {
                return this.chatAlerts;
            }

            @Generated
            public String getAlertsFormat() {
                return this.alertsFormat;
            }

            @Generated
            public List<String> getAlertsHoverFormat() {
                return this.alertsHoverFormat;
            }

            @Generated
            private Chat() {
            }
        }
    }

    @Configuration
    public static class Punishments {
        @Comment(value={"List of commands to run if someone attempts to abuse an exploit.\nSupports PlaceholderAPI placeholders, <player_name> is a built-in placeholder into AntiCrasher.\nDo not include the slash at thew beginning of the command."})
        private List<String> punishments = List.of("ban <player_name> \u00a74Banned for Exploiting.");
        @Comment(value={"Should the plugin immediately close the player's connection? This may result in the failure of punishment commands that depend the player to be online."})
        boolean closeConnectionImmediately = true;

        @Generated
        public List<String> getPunishments() {
            return this.punishments;
        }

        @Generated
        public boolean isCloseConnectionImmediately() {
            return this.closeConnectionImmediately;
        }

        @Generated
        private Punishments() {
        }
    }

    @Configuration
    public static class Discord {
        private boolean enabled = false;
        @Comment(value={"If enabled, this must not be empty."})
        private String webhookUrl = "";
        @Comment(value={"The avatar image URL for the webhook (Optional)"})
        private String avatarUrl = "";
        @Comment(value={"Thumbnail for the webhook embed. Supports the <player_name> placeholder."})
        private String thumbnailUrl = "http://cravatar.eu/avatar/<player_name>/64.png";
        @Comment(value={"HEX color of the embed."})
        private String color = "#F59314";
        @Comment(value={"Username of the embed (like a member's username, but for webhooks)"})
        String username = "AntiCrasher";
        @Comment(value={"The title of the webhook embed."})
        String title = "Exploit Detected";
        @Comment(value={"\nAlerts format for the embed description.\nAvailable placeholders:\n<player_name> - The name of the player who triggered the alert\n<exploit_name> - The name of the exploit that was triggered (e.g. Book, PluginMessage, etc.)\n<exploit_type> - The type of the check that was triggered (e.g. A, B, C, D)\n<exploit_description> - The description of the exploit that was triggered"})
        String description = "**<player_name>** failed <exploit_name> [*Type <exploit_type>*]";
        @Comment(value={"Show the description of the exploit check that the user failed."})
        private boolean descriptionField = true;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getWebhookUrl() {
            return this.webhookUrl;
        }

        @Generated
        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        @Generated
        public String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        @Generated
        public String getColor() {
            return this.color;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public boolean isDescriptionField() {
            return this.descriptionField;
        }

        @Generated
        private Discord() {
        }
    }
}

