/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.common.manager;

import info.preva1l.trashcan.flavor.annotations.Configure;
import info.preva1l.trashcan.flavor.annotations.Service;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;
import net.craftsupport.anticrasher.api.check.Check;
import net.craftsupport.anticrasher.api.user.User;
import net.craftsupport.anticrasher.common.check.impl.chat.ChatA;
import net.craftsupport.anticrasher.common.check.impl.item.ItemA;
import net.craftsupport.anticrasher.common.check.impl.item.ItemB;
import net.craftsupport.anticrasher.common.check.impl.window.WindowA;
import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.api.event.PacketListener;
import net.craftsupport.anticrasher.packetevents.api.event.PacketListenerPriority;
import net.craftsupport.anticrasher.packetevents.api.event.PacketReceiveEvent;

@Service
public class CheckManager
implements PacketListener {
    public static final CheckManager instance = new CheckManager();
    public List<Check> checks = new ArrayList<Check>();

    @Configure
    public void initialise() {
        this.checks = this.initializeChecks();
        PacketEvents.getAPI().getEventManager().registerListener(this, PacketListenerPriority.LOWEST);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        User user = AntiCrasherAPI.getInstance().getUserManager().get(event.getUser().getUUID());
        if (user != null && user.shouldBypass()) {
            return;
        }
        for (Check check : this.checks) {
            check.handle(event, user);
        }
    }

    private List<Check> initializeChecks() {
        return List.of(new ItemA(), new ItemB(), new ChatA(), new WindowA());
    }

    @Generated
    public static CheckManager getInstance() {
        return instance;
    }
}

