/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.chat.clickevent;

import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.protocol.chat.clickevent.ClickEvent;
import net.craftsupport.anticrasher.packetevents.api.protocol.chat.clickevent.ClickEventAction;
import net.craftsupport.anticrasher.packetevents.api.protocol.chat.clickevent.ClickEventActions;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTString;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SuggestCommandClickEvent
implements ClickEvent {
    private final String command;

    public SuggestCommandClickEvent(String command) {
        this.command = command;
    }

    public static SuggestCommandClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        String command = compound.getStringTagValueOrThrow(v1215 ? "command" : "value");
        return new SuggestCommandClickEvent(command);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, SuggestCommandClickEvent clickEvent) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        compound.setTag(v1215 ? "command" : "value", new NBTString(clickEvent.command));
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.SUGGEST_COMMAND;
    }

    @Override
    public net.kyori.adventure.text.event.ClickEvent asAdventure() {
        return net.kyori.adventure.text.event.ClickEvent.suggestCommand(this.command);
    }

    public String getCommand() {
        return this.command;
    }
}

