/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.entity.cow;

import net.craftsupport.anticrasher.packetevents.api.protocol.entity.cow.CowVariants;
import net.craftsupport.anticrasher.packetevents.api.protocol.entity.cow.StaticCowVariant;
import net.craftsupport.anticrasher.packetevents.api.protocol.mapper.CopyableEntity;
import net.craftsupport.anticrasher.packetevents.api.protocol.mapper.DeepComparableEntity;
import net.craftsupport.anticrasher.packetevents.api.protocol.mapper.MappedEntity;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBT;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTString;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.ClientVersion;
import net.craftsupport.anticrasher.packetevents.api.resources.ResourceLocation;
import net.craftsupport.anticrasher.packetevents.api.util.adventure.AdventureIndexUtil;
import net.craftsupport.anticrasher.packetevents.api.util.mappings.TypesBuilderData;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.Nullable;

public interface CowVariant
extends MappedEntity,
CopyableEntity<CowVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static CowVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CowVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CowVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CowVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCowVariant(data, modelType, assetId);
    }

    public static NBT encode(CowVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        COLD("cold"),
        WARM("warm");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

