/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.entity.frog;

import net.craftsupport.anticrasher.packetevents.api.protocol.entity.frog.FrogVariants;
import net.craftsupport.anticrasher.packetevents.api.protocol.entity.frog.StaticFrogVariant;
import net.craftsupport.anticrasher.packetevents.api.protocol.mapper.CopyableEntity;
import net.craftsupport.anticrasher.packetevents.api.protocol.mapper.DeepComparableEntity;
import net.craftsupport.anticrasher.packetevents.api.protocol.mapper.MappedEntity;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBT;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTString;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.ClientVersion;
import net.craftsupport.anticrasher.packetevents.api.resources.ResourceLocation;
import net.craftsupport.anticrasher.packetevents.api.util.mappings.TypesBuilderData;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface FrogVariant
extends MappedEntity,
CopyableEntity<FrogVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static FrogVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(FrogVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, FrogVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static FrogVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticFrogVariant(data, assetId);
    }

    public static NBT encode(FrogVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

