/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.particle.data;

import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTFloat;
import net.craftsupport.anticrasher.packetevents.api.protocol.particle.data.ParticleData;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.ClientVersion;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;

public class ParticleSculkChargeData
extends ParticleData {
    private float roll;

    public ParticleSculkChargeData(float roll) {
        this.roll = roll;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float roll) {
        this.roll = roll;
    }

    public static ParticleSculkChargeData read(PacketWrapper<?> wrapper) {
        return new ParticleSculkChargeData(wrapper.readFloat());
    }

    public static void write(PacketWrapper<?> wrapper, ParticleSculkChargeData data) {
        wrapper.writeFloat(data.getRoll());
    }

    public static ParticleSculkChargeData decode(NBTCompound compound, ClientVersion version) {
        float roll = compound.getNumberTagOrThrow("roll").getAsFloat();
        return new ParticleSculkChargeData(roll);
    }

    public static void encode(ParticleSculkChargeData data, ClientVersion version, NBTCompound compound) {
        compound.setTag("roll", new NBTFloat(data.roll));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

