/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.recipe;

import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.protocol.recipe.RecipeSerializer;
import net.craftsupport.anticrasher.packetevents.api.protocol.recipe.RecipeSerializers;
import net.craftsupport.anticrasher.packetevents.api.protocol.recipe.RecipeType;
import net.craftsupport.anticrasher.packetevents.api.protocol.recipe.data.RecipeData;
import net.craftsupport.anticrasher.packetevents.api.resources.ResourceLocation;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Obsolete
public class Recipe<T extends RecipeData> {
    private final ResourceLocation key;
    private final RecipeSerializer<T> serializer;
    private final T data;

    @Deprecated
    public Recipe(RecipeType serializer, String key, RecipeData data) {
        this(new ResourceLocation(key), serializer.getSerializer(), data);
    }

    public Recipe(ResourceLocation key, RecipeSerializer<T> serializer, T data) {
        this.key = key;
        this.serializer = serializer;
        this.data = data;
    }

    public static Recipe<?> read(PacketWrapper<?> wrapper) {
        RecipeSerializer serializer;
        ResourceLocation key;
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            key = wrapper.readIdentifier();
            serializer = wrapper.readMappedEntity(RecipeSerializers::getById);
        } else {
            serializer = RecipeSerializers.getByName(wrapper.readIdentifier().toString());
            key = wrapper.readIdentifier();
        }
        return Recipe.read(wrapper, key, serializer);
    }

    private static <T extends RecipeData> Recipe<T> read(PacketWrapper<?> wrapper, ResourceLocation key, RecipeSerializer<T> serializer) {
        T data = serializer.read(wrapper);
        return new Recipe<T>(key, serializer, data);
    }

    public static <T extends RecipeData> void write(PacketWrapper<?> wrapper, Recipe<T> recipe) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeIdentifier(recipe.key);
            wrapper.writeMappedEntity(recipe.serializer);
        } else {
            wrapper.writeIdentifier(recipe.serializer.getName());
            wrapper.writeIdentifier(recipe.key);
        }
        recipe.serializer.write(wrapper, recipe.data);
    }

    @Deprecated
    public RecipeType getType() {
        return this.serializer.getLegacyType();
    }

    public String getIdentifier() {
        return this.key.toString();
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public RecipeSerializer<T> getSerializer() {
        return this.serializer;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "Recipe{key=" + this.key + ", serializer=" + this.serializer + ", data=" + this.data + '}';
    }
}

