/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBT;
import net.craftsupport.anticrasher.packetevents.api.protocol.util.NbtCodecs;
import net.craftsupport.anticrasher.packetevents.api.protocol.util.NbtDecoder;
import net.craftsupport.anticrasher.packetevents.api.protocol.util.NbtEncoder;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface NbtCodec<T>
extends NbtEncoder<T>,
NbtDecoder<T> {
    default public <Z> NbtCodec<Z> apply(final Function<T, Z> forward, final Function<Z, T> back) {
        return new NbtCodec<Z>(){

            @Override
            public Z decode(NBT nbt, PacketWrapper<?> wrapper) {
                return forward.apply(NbtCodec.this.decode(nbt, wrapper));
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, Z value) {
                return NbtCodec.this.encode(wrapper, back.apply(value));
            }
        };
    }

    default public NbtCodec<List<T>> applyList() {
        return new NbtCodec<List<T>>(){

            @Override
            public List<T> decode(NBT nbt, PacketWrapper<?> wrapper) {
                List list = (List)NbtCodecs.GENERIC_LIST.decode(nbt, wrapper);
                ArrayList ret = new ArrayList(list.size());
                for (NBT tag : list) {
                    ret.add(NbtCodec.this.decode(tag, wrapper));
                }
                return ret;
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, List<T> value) {
                ArrayList<NBT> list = new ArrayList<NBT>(value.size());
                for (Object ele : value) {
                    list.add(NbtCodec.this.encode(wrapper, ele));
                }
                return NbtCodecs.GENERIC_LIST.encode(wrapper, list);
            }
        };
    }
}

