/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.wrapper.play.server;

import java.util.ArrayList;
import java.util.List;
import net.craftsupport.anticrasher.packetevents.api.event.PacketSendEvent;
import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.protocol.packettype.PacketType;
import net.craftsupport.anticrasher.packetevents.api.protocol.particle.Particle;
import net.craftsupport.anticrasher.packetevents.api.protocol.particle.data.ParticleData;
import net.craftsupport.anticrasher.packetevents.api.protocol.particle.type.ParticleTypes;
import net.craftsupport.anticrasher.packetevents.api.protocol.sound.Sound;
import net.craftsupport.anticrasher.packetevents.api.protocol.sound.Sounds;
import net.craftsupport.anticrasher.packetevents.api.protocol.sound.StaticSound;
import net.craftsupport.anticrasher.packetevents.api.protocol.util.WeightedList;
import net.craftsupport.anticrasher.packetevents.api.resources.ResourceLocation;
import net.craftsupport.anticrasher.packetevents.api.util.Vector3d;
import net.craftsupport.anticrasher.packetevents.api.util.Vector3f;
import net.craftsupport.anticrasher.packetevents.api.util.Vector3i;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WrapperPlayServerExplosion
extends PacketWrapper<WrapperPlayServerExplosion> {
    private Vector3d position;
    private float strength;
    private int blockCount;
    private List<Vector3i> records;
    @Nullable
    private Vector3d knockback;
    @ApiStatus.Obsolete
    private Particle<?> smallParticle;
    private Particle<?> particle;
    @ApiStatus.Obsolete
    private BlockInteraction blockInteraction;
    private Sound explosionSound;
    private WeightedList<ParticleInfo> blockParticles;

    public WrapperPlayServerExplosion(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion) {
        this(position, strength, records, playerMotion, new Particle<ParticleData>(ParticleTypes.EXPLOSION), new Particle<ParticleData>(ParticleTypes.EXPLOSION_EMITTER), BlockInteraction.DESTROY_BLOCKS, new ResourceLocation("minecraft:entity.generic.explode"), null);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion, Particle<?> smallExplosionParticles, Particle<?> largeExplosionParticles, BlockInteraction blockInteraction, ResourceLocation explosionSoundKey, @Nullable Float explosionSoundRange) {
        this(position, strength, records, playerMotion, smallExplosionParticles, largeExplosionParticles, blockInteraction, (Sound)new StaticSound(explosionSoundKey, explosionSoundRange));
    }

    @Deprecated
    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion, Particle<?> smallParticle, Particle<?> particle, BlockInteraction blockInteraction, Sound explosionSound) {
        this(position, strength, records, new Vector3d(playerMotion.x, playerMotion.y, playerMotion.z), smallParticle, particle, blockInteraction, explosionSound);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3d playerMotion, Particle<?> smallParticle, Particle<?> particle, BlockInteraction blockInteraction, Sound explosionSound) {
        this(position, strength, records, playerMotion, smallParticle, particle, blockInteraction, explosionSound, new WeightedList<ParticleInfo>());
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3d playerMotion, Particle<?> smallParticle, Particle<?> particle, BlockInteraction blockInteraction, Sound explosionSound, WeightedList<ParticleInfo> blockParticles) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.strength = strength;
        this.blockCount = records.size();
        this.records = records;
        this.knockback = playerMotion;
        this.smallParticle = smallParticle;
        this.particle = particle;
        this.blockInteraction = blockInteraction;
        this.explosionSound = explosionSound;
        this.blockParticles = blockParticles;
    }

    public WrapperPlayServerExplosion(Vector3d position, @Nullable Vector3d playerMotion) {
        this(position, playerMotion, new Particle<ParticleData>(ParticleTypes.EXPLOSION_EMITTER), Sounds.ENTITY_GENERIC_EXPLODE);
    }

    public WrapperPlayServerExplosion(Vector3d position, @Nullable Vector3d playerMotion, Particle<?> particle, Sound explosionSound) {
        this(position, 0.0f, 0, playerMotion, particle, explosionSound, new WeightedList<ParticleInfo>());
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, int blockCount, @Nullable Vector3d playerMotion, Particle<?> particle, Sound explosionSound, WeightedList<ParticleInfo> blockParticles) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.strength = strength;
        this.blockCount = blockCount;
        this.knockback = playerMotion;
        this.particle = particle;
        this.explosionSound = explosionSound;
        this.blockParticles = blockParticles;
    }

    @Override
    public void read() {
        this.position = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) ? Vector3d.read(this) : new Vector3d(this.readFloat(), this.readFloat(), this.readFloat());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
                this.strength = this.readFloat();
                this.blockCount = this.readInt();
            }
            this.knockback = (Vector3d)this.readOptional(Vector3d::read);
            this.particle = Particle.read(this);
            this.explosionSound = Sound.read(this);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
                this.blockParticles = WeightedList.read(this, ParticleInfo::read);
            }
            this.blockInteraction = BlockInteraction.DESTROY_BLOCKS;
        } else {
            this.strength = this.readFloat();
            int recordsLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
            this.records = new ArrayList<Vector3i>(recordsLength);
            Vector3i floor = this.toFloor(this.position);
            for (int i = 0; i < recordsLength; ++i) {
                int chunkPosX = this.readByte() + floor.getX();
                int chunkPosY = this.readByte() + floor.getY();
                int chunkPosZ = this.readByte() + floor.getZ();
                this.records.add(new Vector3i(chunkPosX, chunkPosY, chunkPosZ));
            }
            float motX = this.readFloat();
            float motY = this.readFloat();
            float motZ = this.readFloat();
            this.knockback = new Vector3d(motX, motY, motZ);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
                this.blockInteraction = BlockInteraction.values()[this.readVarInt()];
                this.smallParticle = Particle.read(this);
                this.particle = Particle.read(this);
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                    this.explosionSound = Sound.read(this);
                } else {
                    ResourceLocation explosionSoundKey = this.readIdentifier();
                    Float explosionSoundRange = (Float)this.readOptional(PacketWrapper::readFloat);
                    this.explosionSound = new StaticSound(explosionSoundKey, explosionSoundRange);
                }
            } else {
                this.blockInteraction = BlockInteraction.DESTROY_BLOCKS;
                this.explosionSound = Sounds.INTENTIONALLY_EMPTY;
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            Vector3d.write(this, this.position);
        } else {
            this.writeFloat((float)this.position.getX());
            this.writeFloat((float)this.position.getY());
            this.writeFloat((float)this.position.getZ());
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
                this.writeFloat(this.strength);
                this.writeInt(this.blockCount);
            }
            this.writeOptional(this.knockback, Vector3d::write);
            Particle.write(this, this.particle);
            Sound.write(this, this.explosionSound);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
                WeightedList.write(this, this.blockParticles, ParticleInfo::write);
            }
        } else {
            this.writeFloat(this.strength);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
                this.writeVarInt(this.records.size());
            } else {
                this.writeInt(this.records.size());
            }
            Vector3i floor = this.toFloor(this.position);
            for (Vector3i record : this.records) {
                this.writeByte(record.x - floor.getX());
                this.writeByte(record.y - floor.getY());
                this.writeByte(record.z - floor.getZ());
            }
            this.writeFloat((float)this.knockback.x);
            this.writeFloat((float)this.knockback.y);
            this.writeFloat((float)this.knockback.z);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
                this.writeVarInt(this.blockInteraction.ordinal());
                Particle.write(this, this.smallParticle);
                Particle.write(this, this.particle);
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                    Sound.write(this, this.explosionSound);
                } else {
                    this.writeIdentifier(this.explosionSound.getSoundId());
                    this.writeOptional(this.explosionSound.getRange(), PacketWrapper::writeFloat);
                }
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerExplosion wrapper) {
        this.position = wrapper.position;
        this.strength = wrapper.strength;
        this.blockCount = wrapper.blockCount;
        this.records = wrapper.records;
        this.knockback = wrapper.knockback;
        this.smallParticle = wrapper.smallParticle;
        this.particle = wrapper.particle;
        this.blockInteraction = wrapper.blockInteraction;
        this.explosionSound = wrapper.explosionSound;
        this.blockParticles = wrapper.blockParticles;
    }

    private Vector3i toFloor(Vector3d position) {
        int floorZ;
        int floorY;
        int floorX;
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            floorX = (int)Math.floor(position.x);
            floorY = (int)Math.floor(position.y);
            floorZ = (int)Math.floor(position.z);
        } else {
            floorX = (int)position.x;
            floorY = (int)position.y;
            floorZ = (int)position.z;
        }
        return new Vector3i(floorX, floorY, floorZ);
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public int getBlockCount() {
        if (this.serverVersion.isOlderThan(ServerVersion.V_1_21_9) && this.blockCount == 0) {
            return this.records.size();
        }
        return this.blockCount;
    }

    public void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    public List<Vector3i> getRecords() {
        if (this.records == null) {
            this.records = new ArrayList<Vector3i>();
        }
        return this.records;
    }

    public void setRecords(List<Vector3i> records) {
        this.records = records;
    }

    @Nullable
    public Vector3d getKnockback() {
        return this.knockback;
    }

    public void setKnockback(@Nullable Vector3d knockback) {
        this.knockback = knockback;
    }

    @Deprecated
    @Nullable
    public Vector3f getPlayerMotion() {
        return this.knockback == null ? null : new Vector3f((float)this.knockback.x, (float)this.knockback.y, (float)this.knockback.z);
    }

    @Deprecated
    public void setPlayerMotion(@Nullable Vector3f playerMotion) {
        this.knockback = playerMotion == null ? null : new Vector3d(playerMotion.x, playerMotion.y, playerMotion.z);
    }

    @ApiStatus.Obsolete
    public Particle<?> getSmallExplosionParticles() {
        if (this.smallParticle == null) {
            return new Particle<ParticleData>(ParticleTypes.EXPLOSION);
        }
        return this.smallParticle;
    }

    @ApiStatus.Obsolete
    public void setSmallExplosionParticles(Particle<?> smallExplosionParticles) {
        this.smallParticle = smallExplosionParticles;
    }

    public Particle<?> getParticle() {
        if (this.particle == null) {
            return new Particle<ParticleData>(ParticleTypes.EXPLOSION_EMITTER);
        }
        return this.particle;
    }

    public void setParticle(Particle<?> particle) {
        this.particle = particle;
    }

    @ApiStatus.Obsolete
    public Particle<?> getLargeExplosionParticles() {
        return this.getParticle();
    }

    @ApiStatus.Obsolete
    public void setLargeExplosionParticles(Particle<?> largeExplosionParticles) {
        this.setParticle(largeExplosionParticles);
    }

    @ApiStatus.Obsolete
    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    @ApiStatus.Obsolete
    public void setBlockInteraction(BlockInteraction blockInteraction) {
        this.blockInteraction = blockInteraction;
    }

    public ResourceLocation getExplosionSoundKey() {
        return this.explosionSound.getSoundId();
    }

    public void setExplosionSoundKey(ResourceLocation explosionSoundKey) {
        this.explosionSound = new StaticSound(explosionSoundKey, this.explosionSound.getRange());
    }

    @Nullable
    public Float getExplosionSoundRange() {
        return this.explosionSound.getRange();
    }

    public void setExplosionSoundRange(@Nullable Float explosionSoundRange) {
        this.explosionSound = new StaticSound(this.explosionSound.getSoundId(), explosionSoundRange);
    }

    public Sound getExplosionSound() {
        return this.explosionSound;
    }

    public void setExplosionSound(Sound explosionSound) {
        this.explosionSound = explosionSound;
    }

    public WeightedList<ParticleInfo> getBlockParticles() {
        return this.blockParticles;
    }

    public void setBlockParticles(WeightedList<ParticleInfo> blockParticles) {
        this.blockParticles = blockParticles;
    }

    public static enum BlockInteraction {
        KEEP_BLOCKS,
        DESTROY_BLOCKS,
        DECAY_DESTROYED_BLOCKS,
        TRIGGER_BLOCKS;

    }

    public static final class ParticleInfo {
        private final Particle<?> particle;
        private final float scaling;
        private final float speed;

        public ParticleInfo(Particle<?> particle, float scaling, float speed) {
            this.particle = particle;
            this.scaling = scaling;
            this.speed = speed;
        }

        public static ParticleInfo read(PacketWrapper<?> wrapper) {
            Particle<?> particle = Particle.read(wrapper);
            float scaling = wrapper.readFloat();
            float speed = wrapper.readFloat();
            return new ParticleInfo(particle, scaling, speed);
        }

        public static void write(PacketWrapper<?> wrapper, ParticleInfo info) {
            Particle.write(wrapper, info.particle);
            wrapper.writeFloat(info.scaling);
            wrapper.writeFloat(info.speed);
        }

        public Particle<?> getParticle() {
            return this.particle;
        }

        public float getScaling() {
            return this.scaling;
        }

        public float getSpeed() {
            return this.speed;
        }
    }
}

