/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.wrapper.play.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.craftsupport.anticrasher.packetevents.api.event.PacketSendEvent;
import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.protocol.packettype.PacketType;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerTabComplete
extends PacketWrapper<WrapperPlayServerTabComplete> {
    private Optional<Integer> transactionID;
    private Optional<CommandRange> commandRange;
    private List<CommandMatch> commandMatches;

    public WrapperPlayServerTabComplete(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerTabComplete(@Nullable Integer transactionID, @NotNull CommandRange commandRange, List<CommandMatch> commandMatches) {
        super(PacketType.Play.Server.TAB_COMPLETE);
        this.setTransactionId(transactionID);
        this.setCommandRange(commandRange);
        this.commandMatches = commandMatches;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.transactionID = Optional.of(this.readVarInt());
            int begin = this.readVarInt();
            int len = this.readVarInt();
            int matchLength = this.readVarInt();
            this.commandRange = Optional.of(new CommandRange(begin, begin + len));
            this.commandMatches = new ArrayList<CommandMatch>(matchLength);
            for (int i = 0; i < matchLength; ++i) {
                String text = this.readString();
                Component tooltip = (Component)this.readOptional(PacketWrapper::readComponent);
                CommandMatch commandMatch = new CommandMatch(text, tooltip);
                this.commandMatches.add(commandMatch);
            }
        } else {
            int matchLength = this.readVarInt();
            this.commandMatches = new ArrayList<CommandMatch>(matchLength);
            for (int i = 0; i < matchLength; ++i) {
                String text = this.readString();
                CommandMatch commandMatch = new CommandMatch(text, null);
                this.commandMatches.add(commandMatch);
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.writeVarInt(this.transactionID.orElse(-1));
            CommandRange commandRange = this.commandRange.get();
            this.writeVarInt(commandRange.getBegin());
            this.writeVarInt(commandRange.getLength());
            this.writeVarInt(this.commandMatches.size());
            for (CommandMatch match : this.commandMatches) {
                this.writeString(match.getText());
                boolean hasTooltip = match.getTooltip().isPresent();
                this.writeBoolean(hasTooltip);
                if (!hasTooltip) continue;
                this.writeComponent(match.getTooltip().get());
            }
        } else {
            this.writeVarInt(this.commandMatches.size());
            for (CommandMatch match : this.commandMatches) {
                this.writeString(match.getText());
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerTabComplete wrapper) {
        this.transactionID = wrapper.transactionID;
        this.commandRange = wrapper.commandRange;
        this.commandMatches = wrapper.commandMatches;
    }

    public Optional<Integer> getTransactionId() {
        return this.transactionID;
    }

    public void setTransactionId(@Nullable Integer transactionID) {
        this.transactionID = Optional.ofNullable(transactionID);
    }

    public Optional<CommandRange> getCommandRange() {
        return this.commandRange;
    }

    public void setCommandRange(@Nullable CommandRange commandRange) {
        this.commandRange = Optional.ofNullable(commandRange);
    }

    public List<CommandMatch> getCommandMatches() {
        return this.commandMatches;
    }

    public void setCommandMatches(List<CommandMatch> commandMatches) {
        this.commandMatches = commandMatches;
    }

    public static class CommandRange {
        private int begin;
        private int end;

        public CommandRange(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getLength() {
            return this.end - this.begin;
        }
    }

    public static class CommandMatch {
        private String text;
        private Optional<Component> tooltip;

        public CommandMatch(String text, @Nullable Component tooltip) {
            this.text = text;
            this.setTooltip(tooltip);
        }

        public CommandMatch(String text) {
            this.text = text;
            this.tooltip = Optional.empty();
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Optional<Component> getTooltip() {
            return this.tooltip;
        }

        public void setTooltip(@Nullable Component tooltip) {
            this.tooltip = tooltip != null ? Optional.of(tooltip) : Optional.empty();
        }
    }
}

