/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.impl.handlers;

import com.velocitypowered.api.proxy.Player;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.api.event.PacketReceiveEvent;
import net.craftsupport.anticrasher.packetevents.api.netty.buffer.ByteBufHelper;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.User;
import net.craftsupport.anticrasher.packetevents.api.util.EnumUtil;
import net.craftsupport.anticrasher.packetevents.api.util.EventCreationUtil;
import net.craftsupport.anticrasher.packetevents.api.util.reflection.Reflection;
import net.craftsupport.anticrasher.packetevents.impl.handlers.PacketEventsEncoder;
import net.craftsupport.anticrasher.packetevents.impl.injector.ServerConnectionInitializer;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static Enum<?> VELOCITY_CONNECTION_EVENT_CONSTANT;
    public User user;
    public Player player;
    public boolean handledCompression;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> output) throws Exception {
        ByteBuf transformed = ctx.alloc().buffer().writeBytes(byteBuf);
        try {
            int firstReaderIndex = transformed.readerIndex();
            PacketReceiveEvent packetReceiveEvent = EventCreationUtil.createReceiveEvent(ctx.channel(), this.user, this.player, transformed, false);
            int readerIndex = transformed.readerIndex();
            PacketEvents.getAPI().getEventManager().callEvent(packetReceiveEvent, () -> transformed.readerIndex(readerIndex));
            if (!packetReceiveEvent.isCancelled()) {
                if (packetReceiveEvent.getLastUsedWrapper() != null) {
                    ByteBufHelper.clear(packetReceiveEvent.getByteBuf());
                    packetReceiveEvent.getLastUsedWrapper().writeVarInt(packetReceiveEvent.getPacketId());
                    packetReceiveEvent.getLastUsedWrapper().write();
                }
                transformed.readerIndex(firstReaderIndex);
                output.add(transformed.retain());
            }
            if (packetReceiveEvent.hasPostTasks()) {
                for (Runnable task : packetReceiveEvent.getPostTasks()) {
                    task.run();
                }
            }
        }
        finally {
            transformed.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        if (byteBuf.isReadable()) {
            this.read(ctx, byteBuf, out);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (VELOCITY_CONNECTION_EVENT_CONSTANT == null) {
            Class<?> clazz = Reflection.getClassByNameWithoutException("com.velocitypowered.proxy.protocol.VelocityConnectionEvent");
            VELOCITY_CONNECTION_EVENT_CONSTANT = EnumUtil.valueOf(clazz, "COMPRESSION_ENABLED");
        }
        if (event == VELOCITY_CONNECTION_EVENT_CONSTANT && !this.handledCompression) {
            ChannelPipeline pipe = ctx.pipeline();
            PacketEventsEncoder encoder = (PacketEventsEncoder)pipe.remove(PacketEvents.ENCODER_NAME);
            pipe.addBefore("minecraft-encoder", PacketEvents.ENCODER_NAME, (ChannelHandler)encoder);
            PacketEventsDecoder decoder = (PacketEventsDecoder)pipe.remove(PacketEvents.DECODER_NAME);
            pipe.addBefore("minecraft-decoder", PacketEvents.DECODER_NAME, (ChannelHandler)decoder);
            this.handledCompression = true;
        }
        super.userEventTriggered(ctx, event);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        ServerConnectionInitializer.destroyChannel(ctx.channel());
        super.channelInactive(ctx);
    }
}

