/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.anticrasher.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import info.preva1l.trashcan.Version;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;
import net.craftsupport.anticrasher.api.Platform;
import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.impl.bstats.velocity.Metrics;
import net.craftsupport.anticrasher.packetevents.impl.velocity.factory.VelocityPacketEventsBuilder;
import net.skullian.anticrasher.velocity.api.VelocityAntiCrasherAPI;
import net.skullian.anticrasher.velocity.library.LibraryLoader;
import net.skullian.anticrasher.velocity.service.ServiceManager;
import net.skullian.anticrasher.velocity.user.VelocityUser;
import org.slf4j.Logger;

@Plugin(id="anticrasher", name="AntiCrasher", version="2.0.10", authors={"CraftSupport", "RivenBytes", "Skullians", "RebelMythik", "MachineBreaker"}, url="https://modrinth.com/plugin/anticrasher", dependencies={@Dependency(id="viaversion", optional=true), @Dependency(id="viabackwards", optional=true), @Dependency(id="viarewind", optional=true), @Dependency(id="geyser", optional=true)})
public class AntiCrasher
implements Platform {
    private static AntiCrasher instance;
    public final ProxyServer server;
    public final Logger logger;
    private final PluginContainer pluginContainer;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private VelocityUser consoleUser;

    @Inject
    public AntiCrasher(ProxyServer server, Logger logger, PluginContainer pluginContainer, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.pluginContainer = pluginContainer;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        PacketEvents.setAPI(VelocityPacketEventsBuilder.build(this.server, this.pluginContainer, this.logger, this.dataDirectory));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(true).bStats(true).kickOnPacketException(true);
        PacketEvents.getAPI().load();
        PacketEvents.getAPI().init();
        AntiCrasherAPI.setInstance(new VelocityAntiCrasherAPI());
        this.metricsFactory.make(this, 20218);
        LibraryLoader libraryLoader = new LibraryLoader();
        libraryLoader.load();
        instance.setConsoleUser(new VelocityUser(UUID.randomUUID(), this.server.getConsoleCommandSource()));
        ServiceManager.onEnable();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        ServiceManager.onDisable();
        PacketEvents.getAPI().terminate();
    }

    @Override
    public Path getConfigDirectory() {
        return this.dataDirectory;
    }

    @Override
    public boolean isPluginEnabled(String pluginName) {
        return this.server.getPluginManager().isLoaded(pluginName);
    }

    @Override
    public Version getCurrentVersion() {
        return Version.fromString("2.0.10");
    }

    @Override
    public void runLater(Runnable runnable, long delay) {
        this.server.getScheduler().buildTask((Object)this, runnable).delay(delay / 20L, TimeUnit.SECONDS).schedule();
    }

    @Override
    public String getPlatformType() {
        return "proxy";
    }

    @Generated
    public static AntiCrasher getInstance() {
        return instance;
    }

    @Generated
    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Generated
    public void setConsoleUser(VelocityUser consoleUser) {
        this.consoleUser = consoleUser;
    }

    @Override
    @Generated
    public VelocityUser getConsoleUser() {
        return this.consoleUser;
    }
}

