/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.anticrasher.velocity.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import info.preva1l.trashcan.flavor.annotations.Configure;
import info.preva1l.trashcan.flavor.annotations.Service;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;
import net.craftsupport.anticrasher.api.user.User;
import net.craftsupport.anticrasher.common.command.impl.ReloadCommand;
import net.craftsupport.anticrasher.common.util.ACLogger;
import net.skullian.anticrasher.velocity.AntiCrasher;
import net.skullian.anticrasher.velocity.user.VelocityUser;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.meta.SimpleCommandMeta;
import org.incendo.cloud.velocity.VelocityCommandManager;

@Service
public class VelocityCommandHandler {
    public static final VelocityCommandHandler instance = new VelocityCommandHandler();
    private VelocityCommandManager<User> manager;
    private AnnotationParser<User> annotationParser;

    @Configure
    public void initialise() {
        SenderMapper senderMapper = SenderMapper.create(commandSource -> {
            if (commandSource instanceof Player) {
                Player player = (Player)commandSource;
                return Objects.requireNonNull(AntiCrasherAPI.getInstance().getUserManager().getOrCreate(player.getUniqueId(), player));
            }
            return new VelocityUser(UUID.randomUUID(), commandSource);
        }, sender -> (CommandSource)sender.getSource());
        this.manager = new VelocityCommandManager(AntiCrasher.getInstance().getPluginContainer(), AntiCrasher.getInstance().server, ExecutionCoordinator.asyncCoordinator(), senderMapper);
        this.annotationParser = new AnnotationParser(this.manager, User.class, params -> SimpleCommandMeta.empty());
        this.registerSubCommands();
        ACLogger.info("Registered commands.", new Object[0]);
    }

    private void registerSubCommands() {
        this.annotationParser.parse(new Object[]{new ReloadCommand()});
    }

    @Generated
    public VelocityCommandManager<User> getManager() {
        return this.manager;
    }

    @Generated
    public AnnotationParser<User> getAnnotationParser() {
        return this.annotationParser;
    }
}

