/*
 * Decompiled with CFR 0.152.
 */
package info.preva1l.trashcan.flavor;

import info.preva1l.trashcan.flavor.FlavorOptions;
import info.preva1l.trashcan.flavor.PackageIndexer;
import info.preva1l.trashcan.flavor.annotations.Close;
import info.preva1l.trashcan.flavor.annotations.Configure;
import info.preva1l.trashcan.flavor.annotations.IgnoreAutoScan;
import info.preva1l.trashcan.flavor.annotations.Service;
import info.preva1l.trashcan.flavor.annotations.inject.Inject;
import info.preva1l.trashcan.flavor.binder.FlavorBinder;
import info.preva1l.trashcan.flavor.binder.FlavorBinderContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Flavor {
    private final FlavorOptions options;
    public final PackageIndexer reflections;
    public final List<FlavorBinder<?>> binders = new ArrayList();
    public final Map<Class<?>, Object> services = new HashMap();

    private Flavor(Class<?> initializer, FlavorOptions options) {
        this.options = options;
        this.reflections = new PackageIndexer(initializer, options);
    }

    public static <T> Flavor create(T initializer, FlavorOptions options) {
        return new Flavor(initializer.getClass(), options);
    }

    public static Flavor create(Class<?> initializer, FlavorOptions options) {
        return new Flavor(initializer, options);
    }

    public Flavor inherit(FlavorBinderContainer container) {
        container.populate();
        this.binders.addAll(container.binders);
        return this;
    }

    public <T> T service(Class<T> clazz) {
        Object service = this.services.get(clazz);
        if (service == null) {
            throw new IllegalArgumentException("A non-service class was provided.");
        }
        return (T)service;
    }

    public <T> FlavorBinder<T> bind(Class<T> clazz) {
        FlavorBinder<T> binder = new FlavorBinder<T>(clazz);
        this.binders.add(binder);
        return binder;
    }

    public <T> T injected(Class<T> clazz, Object ... params) {
        T instance;
        try {
            instance = params.length == 0 ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : clazz.getDeclaredConstructor((Class[])Arrays.stream(params).map(Object::getClass).toArray(Class[]::new)).newInstance(Arrays.stream(params).toArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.inject(instance);
        return instance;
    }

    public void inject(Object object) {
        this.scanAndInject(object.getClass(), object);
    }

    public void startup() {
        List<Class> classes = this.reflections.getTypesAnnotatedWith(Service.class).stream().sorted(Comparator.comparingInt(clazz -> {
            Service annotation = clazz.getAnnotation(Service.class);
            return annotation != null ? annotation.priority() : 1;
        }).reversed()).toList();
        for (Class clazz2 : classes) {
            IgnoreAutoScan ignoreAutoScan = clazz2.getAnnotation(IgnoreAutoScan.class);
            if (ignoreAutoScan != null) continue;
            try {
                this.scanAndInject(clazz2, Flavor.objectInstance(clazz2));
            }
            catch (Exception e) {
                this.options.getLogger().log(Level.WARNING, "An exception was thrown during injection", e);
            }
        }
    }

    public void close() {
        for (Map.Entry<Class<?>, Object> entry : this.services.entrySet()) {
            Optional<Method> close = Arrays.stream(entry.getKey().getDeclaredMethods()).filter(it -> it.isAnnotationPresent(Close.class)).findFirst();
            Service service = entry.getKey().getDeclaredAnnotation(Service.class);
            long milli = this.tracked(() -> close.ifPresent(it -> {
                try {
                    it.invoke(entry.getValue(), new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.options.getLogger().log(Level.SEVERE, "An exception was thrown while closing service - {}", e);
                }
            }));
            if (milli != -1L) {
                this.options.getLogger().info("[Services] [%s] Shutdown in %sms.".formatted(!service.name().isEmpty() ? service.name() : entry.getKey().getSimpleName(), milli));
                continue;
            }
            this.options.getLogger().info("[Services] [%s] Failed to shutdown!".formatted(!service.name().isEmpty() ? service.name() : entry.getKey().getSimpleName()));
        }
    }

    private long tracked(Runnable lambda) {
        long start = System.currentTimeMillis();
        try {
            lambda.run();
        }
        catch (Exception exception) {
            this.options.getLogger().log(Level.SEVERE, "Failed to invoke lambda", exception);
            return -1L;
        }
        return System.currentTimeMillis() - start;
    }

    private void scanAndInject(Class<?> clazz, @Nullable Object instance) {
        Object singleton = instance != null ? instance : Flavor.objectInstance(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            List bindersOfType = this.binders.stream().filter(it -> it.getClazz().isAssignableFrom(field.getType())).collect(Collectors.toList());
            for (FlavorBinder flavorBinder : bindersOfType) {
                for (Annotation annotation : field.getDeclaredAnnotations()) {
                    boolean passesCheck;
                    Predicate<Annotation> predicate = flavorBinder.getAnnotationCheck(annotation.getClass());
                    boolean bl = passesCheck = predicate == null || predicate.test(annotation);
                    if (passesCheck) continue;
                    bindersOfType.remove(flavorBinder);
                }
            }
            FlavorBinder binder = (FlavorBinder)bindersOfType.getFirst();
            boolean accessibility = field.canAccess(singleton);
            if (singleton == null) continue;
            try {
                field.setAccessible(true);
                field.set(singleton, binder.instance);
                field.setAccessible(accessibility);
            }
            catch (IllegalAccessException e) {
                this.options.getLogger().log(Level.SEVERE, "An exception was thrown while injecting field - {}", e);
            }
        }
        boolean isServiceClazz = clazz.isAnnotationPresent(Service.class);
        if (!isServiceClazz) {
            return;
        }
        Optional<Method> configure = Arrays.stream(clazz.getDeclaredMethods()).filter(it -> it.isAnnotationPresent(Configure.class)).findFirst();
        this.services.put(clazz, singleton);
        Service service = clazz.getDeclaredAnnotation(Service.class);
        String serviceName = !service.name().isEmpty() ? service.name() : clazz.getSimpleName();
        long milli = this.tracked(() -> configure.ifPresent(it -> {
            try {
                it.invoke(singleton, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.options.getLogger().log(Level.SEVERE, "An exception was thrown while configuring service - " + serviceName, e);
            }
        }));
        if (milli != -1L) {
            this.options.getLogger().info("[Services] [%s] Loaded in %sms.".formatted(serviceName, milli));
        } else {
            this.options.getLogger().info("[Services] [%s] Failed to load!".formatted(serviceName));
        }
    }

    public static Object objectInstance(Class<?> clazz) {
        Field instanceField;
        try {
            instanceField = clazz.getField("INSTANCE");
        }
        catch (NoSuchFieldException ignored) {
            try {
                instanceField = clazz.getField("instance");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return instanceField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

