/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.common.util;

import java.util.List;
import lombok.Generated;
import net.craftsupport.anticrasher.api.util.objects.Tuple;
import net.craftsupport.anticrasher.packetevents.impl.adventure.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public final class TextUtil {
    private static final MiniMessage miniMessage = MiniMessage.builder().build();
    private static final LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.builder().build();

    @SafeVarargs
    public static Component text(String message, Tuple<String, Object> ... args) {
        TagResolver[] resolvers = new TagResolver[args.length];
        for (int i = 0; i < args.length; ++i) {
            Tuple<String, Object> argument = args[i];
            resolvers[i] = Placeholder.parsed(argument.first(), String.valueOf(argument.second()));
        }
        return miniMessage.deserialize(message, TagResolver.resolver(resolvers));
    }

    @SafeVarargs
    public static Component text(List<String> message, Tuple<String, Object> ... args) {
        return TextUtil.text(String.join((CharSequence)"\n", message), args);
    }

    public static String legacy(String message) {
        return legacyComponentSerializer.serialize(TextUtil.text(message, new Tuple[0]));
    }

    @Generated
    private TextUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

