/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.dialog.input;

import net.craftsupport.anticrasher.packetevents.api.protocol.dialog.input.InputControl;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBT;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTString;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Input {
    private final String key;
    private final InputControl control;

    public Input(String key, InputControl control) {
        this.key = key;
        this.control = control;
    }

    public static Input decode(NBT nbt, PacketWrapper<?> wrapper) {
        NBTCompound compound = (NBTCompound)nbt;
        String key = compound.getStringTagValueOrThrow("key");
        InputControl control = InputControl.decode(compound, wrapper);
        return new Input(key, control);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Input input) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("key", new NBTString(input.key));
        InputControl.encode(compound, wrapper, input.control);
        return compound;
    }

    public String getKey() {
        return this.key;
    }

    public InputControl getControl() {
        return this.control;
    }
}

