/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.item.enchantment;

import java.util.Objects;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBT;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTInt;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.ClientVersion;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;

public final class EnchantmentCost {
    private final int base;
    private final int perLevelAboveFirst;

    public EnchantmentCost(int base, int perLevelAboveFirst) {
        this.base = base;
        this.perLevelAboveFirst = perLevelAboveFirst;
    }

    @Deprecated
    public static EnchantmentCost decode(NBT nbt, ClientVersion version) {
        return EnchantmentCost.decode(nbt, PacketWrapper.createDummyWrapper(version));
    }

    public static EnchantmentCost decode(NBT nbt, PacketWrapper<?> wrapper) {
        NBTCompound compound = (NBTCompound)nbt;
        int base = compound.getNumberTagOrThrow("base").getAsInt();
        int perLevelAboveFirst = compound.getNumberTagOrThrow("per_level_above_first").getAsInt();
        return new EnchantmentCost(base, perLevelAboveFirst);
    }

    @Deprecated
    public static NBT encode(EnchantmentCost cost, ClientVersion version) {
        return EnchantmentCost.encode(PacketWrapper.createDummyWrapper(version), cost);
    }

    public static NBT encode(PacketWrapper<?> wrapper, EnchantmentCost cost) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("base", new NBTInt(cost.base));
        compound.setTag("per_level_above_first", new NBTInt(cost.perLevelAboveFirst));
        return compound;
    }

    public int getBase() {
        return this.base;
    }

    public int getPerLevelAboveFirst() {
        return this.perLevelAboveFirst;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnchantmentCost)) {
            return false;
        }
        EnchantmentCost that = (EnchantmentCost)obj;
        if (this.base != that.base) {
            return false;
        }
        return this.perLevelAboveFirst == that.perLevelAboveFirst;
    }

    public int hashCode() {
        return Objects.hash(this.base, this.perLevelAboveFirst);
    }

    public String toString() {
        return "EnchantmentCost{base=" + this.base + ", perLevelAboveFirst=" + this.perLevelAboveFirst + '}';
    }
}

